/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.net;

import java.math.BigInteger;
import org.davic.net.InvalidLocatorException;
import org.davic.net.Locator;
import org.videolan.BDJUtil;
import org.videolan.Logger;

public class BDLocator
extends Locator {
    public static final int NOTLOCATED = -1;
    protected String pathSegments = null;
    protected String disc = null;
    protected int primaryAudioNum = -1;
    protected int secondaryAudioNum = -1;
    protected int primaryVideoNum = -1;
    protected int secondaryVideoNum = -1;
    protected int textStreamNum = -1;
    protected int jar = -1;
    protected int mark = -1;
    protected int playItem = -1;
    protected int playList = -1;
    protected int sound = -1;
    protected int titleNum = -1;
    private static final Logger logger = Logger.getLogger(BDLocator.class.getName());

    private void checkDiscId(String disc) throws InvalidLocatorException {
        if (disc == null) {
            return;
        }
        if (disc.length() == 32) {
            try {
                new BigInteger(disc, 16);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        logger.error("Invalid Disc ID: " + disc);
        throw new InvalidLocatorException();
    }

    private void checkTitle(int title) throws InvalidLocatorException {
        if (title >= -1 && title <= 999) {
            return;
        }
        if (title == 65534 || title == 65535) {
            return;
        }
        logger.error("Invalid title number: " + title);
        throw new InvalidLocatorException();
    }

    private void checkPlaylist(int pl) throws InvalidLocatorException {
        if (pl >= -1 && pl <= 1999) {
            return;
        }
        logger.error("Invalid playlist id: " + pl);
        throw new InvalidLocatorException();
    }

    private void checkPlayitem(int pi) throws InvalidLocatorException {
        if (pi >= -1 && pi <= 998) {
            return;
        }
        logger.error("Invalid playitem id: " + pi);
        throw new InvalidLocatorException();
    }

    private void checkMark(int mark) throws InvalidLocatorException {
        if (mark >= -1 && mark <= 998) {
            return;
        }
        logger.error("Invalid playmark id: " + mark);
        throw new InvalidLocatorException();
    }

    private void checkJar(int jar) throws InvalidLocatorException {
        if (jar >= -1 && jar <= 99999) {
            return;
        }
        logger.error("Invalid JAR id: " + jar);
        throw new InvalidLocatorException();
    }

    private void checkSound(int sound) throws InvalidLocatorException {
        if (sound >= -1 && sound <= 127) {
            return;
        }
        logger.error("Invalid sound id: " + sound);
        throw new InvalidLocatorException();
    }

    public BDLocator(String url) throws InvalidLocatorException {
        super(url);
        try {
            if (!url.startsWith("bd://")) {
                throw new InvalidLocatorException();
            }
            String str = url.substring(5);
            if (!(this.parseJar(str) || this.parseSound(str) || this.parsePlaylist(str))) {
                throw new InvalidLocatorException();
            }
        }
        catch (InvalidLocatorException e) {
            logger.error("Invalid locator: " + url);
            throw e;
        }
    }

    public BDLocator(String disc, int titleNum, int playList) throws InvalidLocatorException {
        super(null);
        this.checkDiscId(disc);
        this.checkTitle(titleNum);
        this.checkPlaylist(playList);
        this.disc = disc;
        this.titleNum = titleNum;
        this.playList = playList;
        this.url = this.getUrl();
    }

    public BDLocator(String disc, int titleNum, int jar, int sound) throws InvalidLocatorException {
        super(null);
        this.checkDiscId(disc);
        this.checkTitle(titleNum);
        this.checkJar(jar);
        this.checkSound(sound);
        if (jar >= 0 && sound >= 0) {
            logger.error("Invalid locator: jar ID and sound ID set");
            throw new InvalidLocatorException();
        }
        this.disc = disc;
        this.titleNum = titleNum;
        this.jar = jar;
        this.sound = sound;
        this.url = this.getUrl();
    }

    public BDLocator(String disc, int titleNum, int playList, int playItem, int mark, String[] componentTags) throws InvalidLocatorException {
        super(null);
        this.checkDiscId(disc);
        this.checkTitle(titleNum);
        this.checkPlaylist(playList);
        this.checkPlayitem(playItem);
        this.checkMark(mark);
        this.disc = disc;
        this.titleNum = titleNum;
        this.playList = playList;
        this.playItem = playItem;
        this.mark = mark;
        if (componentTags != null) {
            try {
                for (int i = 0; i < componentTags.length; ++i) {
                    String comp = componentTags[i];
                    if (comp.startsWith("A1:")) {
                        this.primaryAudioNum = Integer.parseInt(comp.substring(3));
                        continue;
                    }
                    if (comp.startsWith("A2:")) {
                        this.secondaryAudioNum = Integer.parseInt(comp.substring(3));
                        continue;
                    }
                    if (comp.startsWith("V1:")) {
                        this.primaryVideoNum = Integer.parseInt(comp.substring(3));
                        continue;
                    }
                    if (comp.startsWith("V2:")) {
                        this.secondaryVideoNum = Integer.parseInt(comp.substring(3));
                        continue;
                    }
                    if (comp.startsWith("P:")) {
                        this.textStreamNum = Integer.parseInt(comp.substring(2));
                        continue;
                    }
                    logger.error("Invalid locator: unknown component tag in " + comp);
                    throw new InvalidLocatorException();
                }
            }
            catch (NumberFormatException e) {
                logger.error("Invalid locator: invalid component tag found");
                throw new InvalidLocatorException();
            }
        }
        this.url = this.getUrl();
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.url.equals(((BDLocator)obj).url);
    }

    public boolean isJarFileItem() {
        return this.jar >= 0;
    }

    public boolean isPlayListItem() {
        return this.playList >= 0;
    }

    public boolean isSoundItem() {
        return this.sound >= 0;
    }

    public int getComponentTagsCount() {
        if (!this.isPlayListItem()) {
            return 0;
        }
        int nTags = 0;
        if (this.primaryVideoNum > 0) {
            ++nTags;
        }
        if (this.primaryAudioNum > 0) {
            ++nTags;
        }
        if (this.secondaryVideoNum > 0) {
            ++nTags;
        }
        if (this.secondaryAudioNum > 0) {
            ++nTags;
        }
        if (this.textStreamNum > 0) {
            ++nTags;
        }
        return nTags;
    }

    public String[] getComponentTags() {
        int nTags = this.getComponentTagsCount();
        if (nTags <= 0) {
            return new String[0];
        }
        String[] tags = new String[nTags];
        if (this.textStreamNum > 0) {
            tags[--nTags] = "P:" + this.textStreamNum;
        }
        if (this.secondaryAudioNum > 0) {
            tags[--nTags] = "A2:" + this.secondaryAudioNum;
        }
        if (this.secondaryVideoNum > 0) {
            tags[--nTags] = "V2:" + this.secondaryVideoNum;
        }
        if (this.primaryAudioNum > 0) {
            tags[--nTags] = "A1:" + this.primaryAudioNum;
        }
        if (this.primaryVideoNum > 0) {
            tags[--nTags] = "V1:" + this.primaryVideoNum;
        }
        return tags;
    }

    public String getDiscId() {
        return this.disc;
    }

    public int getTitleNumber() {
        return this.titleNum;
    }

    public int getJarFileId() {
        return this.jar;
    }

    public String getPathSegments() {
        return this.pathSegments;
    }

    public int getSoundId() {
        return this.sound;
    }

    public int getPlayListId() {
        return this.playList;
    }

    public int getMarkId() {
        return this.mark;
    }

    public int getPlayItemId() {
        return this.playItem;
    }

    public int getPrimaryAudioStreamNumber() {
        return this.primaryAudioNum;
    }

    public int getSecondaryAudioStreamNumber() {
        return this.secondaryAudioNum;
    }

    public int getPrimaryVideoStreamNumber() {
        return this.primaryVideoNum;
    }

    public int getSecondaryVideoStreamNumber() {
        return this.secondaryVideoNum;
    }

    public int getPGTextStreamNumber() {
        return this.textStreamNum;
    }

    public void setPlayListId(int id) {
        if (id >= 0 && id != this.playList) {
            this.playList = id;
            this.url = this.getUrl();
        }
    }

    public void setMarkId(int id) {
        if (id >= 0 && id != this.mark) {
            this.mark = id;
            this.url = this.getUrl();
        }
    }

    public void setPlayItemId(int id) {
        if (id >= 0 && id != this.playItem) {
            this.playItem = id;
            this.url = this.getUrl();
        }
    }

    public void setPrimaryAudioStreamNumber(int num) {
        if (num >= 0 && num != this.primaryAudioNum) {
            this.primaryAudioNum = num;
            this.url = this.getUrl();
        }
    }

    public void setSecondaryAudioStreamNumber(int num) {
        if (num >= 0 && num != this.secondaryAudioNum) {
            this.secondaryAudioNum = num;
            this.url = this.getUrl();
        }
    }

    public void setPrimaryVideoStreamNumber(int num) {
        if (num >= 0 && num != this.primaryVideoNum) {
            this.primaryVideoNum = num;
            this.url = this.getUrl();
        }
    }

    public void setSecondaryVideoStreamNumber(int num) {
        if (num >= 0 && num != this.secondaryVideoNum) {
            this.secondaryVideoNum = num;
            this.url = this.getUrl();
        }
    }

    public void setPGTextStreamNumber(int num) {
        if (num >= 0 && num != this.textStreamNum) {
            this.textStreamNum = num;
            this.url = this.getUrl();
        }
    }

    protected String getUrl() {
        String str = "bd://";
        if (this.disc != null && this.disc != "") {
            str = str + this.disc;
            if (this.titleNum >= 0) {
                str = str + ".";
            }
        }
        if (this.titleNum >= 0) {
            str = str + Integer.toString(this.titleNum, 16);
            if (this.jar >= 0 || this.playList >= 0 || this.sound >= 0) {
                str = str + ".";
            }
        }
        if (this.jar >= 0) {
            str = str + "JAR:" + BDJUtil.makeFiveDigitStr(this.jar);
            if (this.pathSegments != null) {
                str = str + this.pathSegments;
            }
        } else if (this.playList >= 0) {
            str = str + "PLAYLIST:" + BDJUtil.makeFiveDigitStr(this.playList);
            if (this.playItem >= 0) {
                str = str + ".ITEM:" + BDJUtil.makeFiveDigitStr(this.playItem);
            }
            if (this.mark >= 0) {
                str = str + ".MARK:" + BDJUtil.makeFiveDigitStr(this.mark);
            }
            String prefix = ".";
            if (this.primaryAudioNum > 0) {
                str = str + prefix + "A1:" + this.primaryAudioNum;
                if (prefix.equals(".")) {
                    prefix = "&";
                }
            }
            if (this.secondaryAudioNum > 0) {
                str = str + prefix + "A2:" + this.secondaryAudioNum;
                if (prefix.equals(".")) {
                    prefix = "&";
                }
            }
            if (this.primaryVideoNum > 0) {
                str = str + prefix + "V1:" + this.primaryVideoNum;
                if (prefix.equals(".")) {
                    prefix = "&";
                }
            }
            if (this.secondaryVideoNum > 0) {
                str = str + prefix + "V2:" + this.secondaryVideoNum;
                if (prefix.equals(".")) {
                    prefix = "&";
                }
            }
            if (this.textStreamNum > 0) {
                str = str + prefix + "P:" + this.textStreamNum;
                if (prefix.equals(".")) {
                    String string = "&";
                }
            }
        } else if (this.sound >= 0) {
            str = str + "SOUND:" + Integer.toString(this.sound, 16);
        }
        return str;
    }

    private boolean parseJar(String str) throws InvalidLocatorException {
        if (!str.startsWith("JAR:")) {
            return false;
        }
        if (str.length() < 9) {
            throw new InvalidLocatorException();
        }
        try {
            this.jar = Integer.parseInt(str.substring(4, 9));
        }
        catch (NumberFormatException e) {
            throw new InvalidLocatorException();
        }
        if (str.length() > 9) {
            this.pathSegments = str.substring(9);
        }
        return true;
    }

    private boolean parseSound(String str) throws InvalidLocatorException {
        if (!str.startsWith("SOUND:")) {
            return false;
        }
        try {
            this.sound = Integer.parseInt(str.substring(6), 16);
        }
        catch (NumberFormatException e) {
            throw new InvalidLocatorException();
        }
        return true;
    }

    private boolean parsePlaylist(String str) throws InvalidLocatorException {
        boolean isTag = false;
        int length = str.length();
        int begin = 0;
        int end = str.indexOf(46);
        if (end < 0) {
            end = length;
        }
        while (end <= length) {
            block24: {
                String element = str.substring(begin, end);
                try {
                    if (this.playList < 0) {
                        if (end - begin == 32) {
                            this.checkDiscId(element);
                            this.disc = element;
                            break block24;
                        }
                        if (end - begin <= 4) {
                            this.titleNum = Integer.parseInt(element, 16);
                            this.checkTitle(this.titleNum);
                            break block24;
                        }
                        if (element.startsWith("PLAYLIST:")) {
                            this.playList = Integer.parseInt(element.substring(9));
                            this.checkPlaylist(this.playList);
                            break block24;
                        }
                        throw new InvalidLocatorException();
                    }
                    if (element.startsWith("MARK:")) {
                        this.mark = Integer.parseInt(element.substring(5));
                        this.checkMark(this.mark);
                        break block24;
                    }
                    if (element.startsWith("ITEM:")) {
                        this.playItem = Integer.parseInt(element.substring(5));
                        this.checkPlayitem(this.playItem);
                        break block24;
                    }
                    if (element.startsWith("A1:")) {
                        this.primaryAudioNum = Integer.parseInt(element.substring(3));
                        if (this.primaryAudioNum < 0) {
                            throw new InvalidLocatorException();
                        }
                        isTag = true;
                        break block24;
                    }
                    if (element.startsWith("A2:")) {
                        this.secondaryAudioNum = Integer.parseInt(element.substring(3));
                        if (this.secondaryAudioNum < 0) {
                            throw new InvalidLocatorException();
                        }
                        isTag = true;
                        break block24;
                    }
                    if (element.startsWith("V1:")) {
                        this.primaryVideoNum = Integer.parseInt(element.substring(3));
                        if (this.primaryVideoNum < 0) {
                            throw new InvalidLocatorException();
                        }
                        isTag = true;
                        break block24;
                    }
                    if (element.startsWith("V2:")) {
                        this.secondaryVideoNum = Integer.parseInt(element.substring(3));
                        if (this.secondaryVideoNum < 0) {
                            throw new InvalidLocatorException();
                        }
                        isTag = true;
                        break block24;
                    }
                    if (element.startsWith("P:")) {
                        this.textStreamNum = Integer.parseInt(element.substring(2));
                        if (this.textStreamNum < 0) {
                            throw new InvalidLocatorException();
                        }
                        isTag = true;
                        break block24;
                    }
                    logger.error("Unknown tag: " + element);
                    throw new InvalidLocatorException();
                }
                catch (NumberFormatException e) {
                    logger.error("Parse error: " + e);
                    throw new InvalidLocatorException();
                }
            }
            if (end >= length) break;
            begin = end + 1;
            if (isTag) {
                end = str.indexOf(38, begin);
                if (end < 0) {
                    isTag = false;
                    end = str.indexOf(46, begin);
                }
            } else {
                end = str.indexOf(46, begin);
                if (end < 0) {
                    end = str.indexOf(38, begin);
                }
            }
            if (end >= 0) continue;
            end = length;
        }
        return true;
    }
}

