%  rcs.sl			-*- slang -*-
%
%  This file provides an interface to RCS a la Emacs (sort of).
%
%  Written by Guido Gonzato  <guido@ibogeo.df.unibo.it>
%  Modified by JED on 20 Nov 1999.
%
%  To use this facility, put this in your .jedrc:
%    () = evalfile("rcs.sl");
%
%  The interface provides two functions:
%    rcs_open_file: -- open an RCS file
%    rcs_check_in_and_out: -- check in or out an RCS file
%  You may bind these two keys in your .jedrc file, e.g.,
%
%    setkey ("rcs_open_file", "^X^F");
%    setkey ("rcs_check_in_and_out", "^Xvv");

static variable Last_Comment = "";

% Build a file name like "/home/guido/RCS/file.txt,v"
static define build_rcs_filename (file)
{
   variable dir;
   (dir, file) = parse_filename (file);
   return dircat (dircat (dir, "RCS"), strcat (file, ",v"));
}

static define execute_rcs_cmd (cmd)
{
   variable cbuf, buf;
   
   buf = "*RCS Message*";
   cbuf = whatbuf ();
   setbuf (buf);
   erase_buffer ();
   if (0 != run_shell_cmd (cmd))
     {
	pop2buf (buf);
	return -1;
     }
   bury_buffer (buf);
   setbuf (cbuf);
   return 0;
}


static define checkout (file)
{
   variable cmd;
   variable dir;
   variable name;
   
   flush (sprintf ("Checking out %s...", file));

   (dir, name) = parse_filename (file);

   cmd = sprintf ("cd %s; co -l %s 2>&1", dir, name);
   if (0 != execute_rcs_cmd (cmd))
     verror ("Error checking out %s!", file);

   flush (sprintf ("Checking out %s...done.", file));
}

static define checkin (file)
{
   variable dir, name, cmd;

   () = write_buffer (file);
   
   (dir, name) = parse_filename (file);
   Last_Comment = read_mini ("Enter a change comment:", "", Last_Comment);

   cmd = sprintf ("cd %s; echo \"%s\" | ci %s > /dev/null 2>&1",
		  dir, Last_Comment, name);
   if (0 != execute_rcs_cmd (cmd))
     verror ("Error checking in %s!", file);

   set_readonly (1);
   flush ("Note: file is write protected.");
}


define rcs_open_file ()		% ^X^F
{
   variable rcs_file, file;

   file = read_file_from_mini ("RCS open file:");

  % check whether the file exists; if not, try the RCS version
   
   if (1 == file_status (file)) 
     {
	() = find_file (file);
	return;
     }

   rcs_file = build_rcs_filename (file);

   % now check if this file exists
   if (0 == file_status (rcs_file))
     verror ("RCS file %s not found.", rcs_file);

   checkout (file);
   () = find_file (file);
}


define rcs_check_in_and_out ()	% ^X-v-v
{
   variable dir, file;

   % check if the current buffer is attached to an RCS file.
   (file, dir,,) = getbuf_info();
   file = dircat (dir, file);

   % if it doesn't exist, then create the RCS, check in, and exit
   if (0 == file_status (build_rcs_filename (file)))
     {
	dir = dircat (dir, "RCS");
	if (0 == file_status (dir)) 
	  {
	     if (0 != mkdir (dir, 0777))
	       verror ("Error creating RCS directory %s!", dir);
	  }
	checkin (file);
	return;
     }

   % the RCS file exists; if the buffer is read only, then check it out
   if (is_readonly ())
     {
	checkout (file);
	delbuf (whatbuf());
	() = find_file (file);
	return;
     }

   % Otherwise, check it in
   checkin (file);
}

% --- End of file rcs.sl ---
