/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSearchResults;

public class LDAPSchema {
    private Hashtable objectClasses = new Hashtable();
    private Hashtable attributes = new Hashtable();
    private Hashtable matchingRules = new Hashtable();
    String entryName;

    public void addObjectClass(LDAPObjectClassSchema lDAPObjectClassSchema) {
        this.objectClasses.put(lDAPObjectClassSchema.getName().toLowerCase(), lDAPObjectClassSchema);
    }

    public void addAttribute(LDAPAttributeSchema lDAPAttributeSchema) {
        this.attributes.put(lDAPAttributeSchema.getName().toLowerCase(), lDAPAttributeSchema);
    }

    public void addMatchingRule(LDAPMatchingRuleSchema lDAPMatchingRuleSchema) {
        this.matchingRules.put(lDAPMatchingRuleSchema.getName().toLowerCase(), lDAPMatchingRuleSchema);
    }

    public Enumeration getObjectClasses() {
        return this.objectClasses.elements();
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public Enumeration getMatchingRules() {
        return this.matchingRules.elements();
    }

    public LDAPObjectClassSchema getObjectClass(String string) {
        return (LDAPObjectClassSchema)this.objectClasses.get(string.toLowerCase());
    }

    public LDAPAttributeSchema getAttribute(String string) {
        return (LDAPAttributeSchema)this.attributes.get(string.toLowerCase());
    }

    public LDAPMatchingRuleSchema getMatchingRule(String string) {
        return (LDAPMatchingRuleSchema)this.matchingRules.get(string.toLowerCase());
    }

    public Enumeration getObjectClassNames() {
        return this.objectClasses.keys();
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration getMatchingRuleNames() {
        return this.matchingRules.keys();
    }

    public void fetchSchema(LDAPConnection lDAPConnection) throws LDAPException {
        LDAPMatchingRuleSchema lDAPMatchingRuleSchema;
        String string;
        Object object;
        Enumeration enumeration;
        if (lDAPConnection == null || !lDAPConnection.isConnected()) {
            throw new LDAPException("No connection", 80);
        }
        LDAPEntry lDAPEntry = lDAPConnection.read("");
        if (lDAPEntry == null) {
            throw new LDAPException("", 32);
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("subschemasubentry");
        this.entryName = "cn=schema";
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            this.entryName = (String)enumeration.nextElement();
        }
        if ((lDAPAttribute = (lDAPEntry = this.readSchema(lDAPConnection, this.entryName)).getAttribute("objectclasses")) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                object = new LDAPObjectClassSchema((String)enumeration.nextElement());
                this.addObjectClass((LDAPObjectClassSchema)object);
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute("attributetypes")) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                object = new LDAPAttributeSchema((String)enumeration.nextElement());
                this.addAttribute((LDAPAttributeSchema)object);
            }
        }
        object = new Hashtable();
        lDAPAttribute = lDAPEntry.getAttribute("matchingruleuse");
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                lDAPMatchingRuleSchema = new LDAPMatchingRuleSchema(null, string);
                ((Hashtable)object).put(lDAPMatchingRuleSchema.getOID(), string);
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute("matchingrules")) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                lDAPMatchingRuleSchema = new LDAPMatchingRuleSchema(string, null);
                String string2 = (String)((Hashtable)object).get(lDAPMatchingRuleSchema.getOID());
                if (string2 != null) {
                    lDAPMatchingRuleSchema = new LDAPMatchingRuleSchema(string, string2);
                }
                this.addMatchingRule(lDAPMatchingRuleSchema);
            }
        }
    }

    public String toString() {
        String string = "Object classes: ";
        Enumeration enumeration = this.getObjectClasses();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement();
            string = String.valueOf(string) + ' ';
        }
        string = String.valueOf(string) + "Attributes: ";
        enumeration = this.getAttributes();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement();
            string = String.valueOf(string) + ' ';
        }
        string = String.valueOf(string) + "Matching rules: ";
        enumeration = this.getMatchingRules();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement();
            string = String.valueOf(string) + ' ';
        }
        return string;
    }

    private LDAPEntry readSchema(LDAPConnection lDAPConnection, String string) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, "objectclass=subschema", null, false);
        return lDAPSearchResults.next();
    }

    private static void printEnum(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            LDAPSchemaElement lDAPSchemaElement = (LDAPSchemaElement)enumeration.nextElement();
            System.out.println("  " + lDAPSchemaElement);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: netscape.ldap.LDAPSchema HOST PORT");
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[1]);
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(stringArray[0], n);
            LDAPSchema lDAPSchema = new LDAPSchema();
            lDAPSchema.fetchSchema(lDAPConnection);
            lDAPConnection.disconnect();
            System.out.println("Object classes: ");
            LDAPSchema.printEnum(lDAPSchema.getObjectClasses());
            System.out.println("\nAttributes: ");
            LDAPSchema.printEnum(lDAPSchema.getAttributes());
            System.out.println("\nMatching rules: ");
            LDAPSchema.printEnum(lDAPSchema.getMatchingRules());
            System.exit(0);
            return;
        }
        catch (LDAPException lDAPException) {
            System.err.println(lDAPException);
            return;
        }
    }
}

