/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import sun.misc.Timer;
import sun.misc.TimerTickThread;

class TimerThread
extends Thread {
    public static boolean debug;
    static TimerThread timerThread;
    static boolean notified;
    static Timer timerQueue;

    protected TimerThread() {
        super("TimerThread");
        timerThread = this;
        this.start();
    }

    public synchronized void run() {
        while (true) {
            if (timerQueue == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            notified = false;
            long l = TimerThread.timerQueue.sleepUntil - System.currentTimeMillis();
            if (l > 0L) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (notified) continue;
            Timer timer = timerQueue;
            timerQueue = TimerThread.timerQueue.next;
            TimerTickThread timerTickThread = TimerTickThread.call(timer, timer.sleepUntil);
            if (!debug) continue;
            long l2 = System.currentTimeMillis() - timer.sleepUntil;
            System.out.println("tick(" + timerTickThread.getName() + "," + timer.interval + "," + l2 + ")");
            if (l2 <= 250L) continue;
            System.out.println("*** BIG DELAY ***");
        }
    }

    protected static void enqueue(Timer timer) {
        Timer timer2 = null;
        Timer timer3 = timerQueue;
        if (timer3 == null || timer.sleepUntil <= timer3.sleepUntil) {
            timer.next = timerQueue;
            timerQueue = timer;
            notified = true;
            timerThread.notify();
        } else {
            do {
                timer2 = timer3;
            } while ((timer3 = timer3.next) != null && timer.sleepUntil > timer3.sleepUntil);
            timer.next = timer3;
            timer2.next = timer;
        }
        if (debug) {
            long l = System.currentTimeMillis();
            System.out.print(String.valueOf(Thread.currentThread().getName()) + ": enqueue " + timer.interval + ": ");
            timer3 = timerQueue;
            while (timer3 != null) {
                long l2 = timer3.sleepUntil - l;
                System.out.print(String.valueOf(timer3.interval) + "(" + l2 + ") ");
                timer3 = timer3.next;
            }
            System.out.println();
        }
    }

    protected static boolean dequeue(Timer timer) {
        Timer timer2 = null;
        Timer timer3 = timerQueue;
        while (timer3 != null && timer3 != timer) {
            timer2 = timer3;
            timer3 = timer3.next;
        }
        if (timer3 == null) {
            if (debug) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + ": dequeue " + timer.interval + ": no-op");
            }
            return false;
        }
        if (timer2 == null) {
            timerQueue = timer.next;
            notified = true;
            timerThread.notify();
        } else {
            timer2.next = timer.next;
        }
        timer.next = null;
        if (debug) {
            long l = System.currentTimeMillis();
            System.out.print(String.valueOf(Thread.currentThread().getName()) + ": dequeue " + timer.interval + ": ");
            timer3 = timerQueue;
            while (timer3 != null) {
                long l2 = timer3.sleepUntil - l;
                System.out.print(String.valueOf(timer3.interval) + "(" + l2 + ") ");
                timer3 = timer3.next;
            }
            System.out.println();
        }
        return true;
    }

    protected static void requeue(Timer timer) {
        if (!timer.stopped) {
            long l = System.currentTimeMillis();
            timer.sleepUntil = timer.regular ? (timer.sleepUntil += timer.interval) : l + timer.interval;
            TimerThread.enqueue(timer);
            return;
        }
        if (debug) {
            System.out.println(String.valueOf(Thread.currentThread().getName()) + ": requeue " + timer.interval + ": no-op");
        }
    }

    static {
        timerQueue = null;
    }
}

