/*
 * ports.c (low level acces to the io-ports)
 * Time-stamp: <04 Aug 94 (15:05:40) by pive@ruca.ua.ac.be>
 */

#include "ports.h"

void inline outb_p(char value, unsigned short port)
{
__asm__ __volatile__ ("outb %%al,%%dx"
                ::"a" ((char) value),"d" ((unsigned short) port));
        SLOW_DOWN_IO;
}

unsigned int inline inb_p(unsigned short port)
{
        unsigned int _v;
__asm__ __volatile__ ("inb %%dx,%%al"
                :"=a" (_v):"d" ((unsigned short) port),"0" (0));
        SLOW_DOWN_IO;
        return _v;
}
