/* group.c
 * David Lutz
 * Modified and debugged by Jason Hunter
 *
 * This file contains routines for handling the ext2 groups
 */

#include <stdio.h>
#include <stdlib.h>
#define _GROUP_C_
#include "ext2.h"
#include "proto.h"

/*
 * Group Global Variables
 */
group_desc *gt;
int num_groups;

/* load_groups
 *
 * Load the group descriptors into memory and set some
 * global variables.
 *
 * returns -1 for failure
 *          1 for success
 */
int load_groups( void )
{
  size_t size;

  /* How many groups are there? */
  /* Funky math insures interger divide will round up */
  num_groups = (sb.s_blocks_count - sb.s_first_data_block +
		sb.s_blocks_per_group - 1) / sb.s_blocks_per_group;

  size = sizeof(group_desc) * num_groups;
  if( (gt = (group_desc *)malloc( size )) == NULL )
  {
    fprintf( stderr, "Memory problem in load_groups.\n");
    return( -1 );		/* Memory problem, signal failure */
  }

  if( readdisk( (byte *)gt, BLOCK_SIZE*2, size ) != size )
  {
    fprintf( stderr, "Disk problem in load_groups.\n");
    return( -1 );		/* Disk problem, signal failure */
  }

  return( 1 );			/* Otherwise everything is OK */
}

/* print_groups
 *
 * print out group information (useful for debugging)
 */
void print_groups( void )
{
  int i;

  for( i=0; i < num_groups; i++ )
    {
      printf( "----------------------------\n" );
      printf( "Group Number: %d\n", i );
      printf( "Blocks Bitmap Block: %lu\n", gt[i].bg_block_bitmap );
      printf( "Inodes Bitmap Block: %lu\n", gt[i].bg_inode_bitmap );
      printf( "Inodes Table Block: %lu\n", gt[i].bg_inode_table );
      printf( "Free Blocks: %u\n", gt[i].bg_free_blocks_count );
      printf( "Free Inodes: %u\n", gt[i].bg_free_inodes_count );
      printf( "Used Directories: %u\n", gt[i].bg_used_dirs_count );
    }
}
