/* --------------------------------- stats.h -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* definitions of usage for st.stats[].
*/


#define STAT_NETSENTBYTES		0
#define STATS_NETSENTBYTES		st.stats[STAT_NETSENTBYTES]
#define STAT_NETSENTPACKETS		1
#define STATS_NETSENTPACKETS		st.stats[STAT_NETSENTPACKETS]
#define STAT_NETRECEIVEDBYTES		2
#define STATS_NETRECEIVEDBYTES		st.stats[STAT_NETRECEIVEDBYTES]
#define STAT_NETRECEIVEDPACKETS		3
#define STATS_NETRECEIVEDPACKETS	st.stats[STAT_NETRECEIVEDPACKETS]
#define STAT_NETERRL			4
#define STATS_NETERRL			st.stats[STAT_NETERRL]
#define STAT_NETERRD			5
#define STATS_NETERRD			st.stats[STAT_NETERRD]
#define STAT_NETERRCRC			6
#define STATS_NETERRCRC			st.stats[STAT_NETERRCRC]
#define STAT_NETERRNOPLAYER		7
#define STATS_NETERRNOPLAYER		st.stats[STAT_NETERRNOPLAYER]
#define STAT_NETERRSEND			8
#define STATS_NETERRSEND		st.stats[STAT_NETERRSEND]
#define STAT_NETERRSENDA		9
#define STATS_NETERRSENDA		st.stats[STAT_NETERRSENDA]

#define STAT_CLIPOUT			10
#define STATS_CLIPOUT			st.stats[STAT_CLIPOUT]
#define STAT_CLIPIN			11
#define STATS_CLIPIN			st.stats[STAT_CLIPIN]
#define STAT_CLIPINOUT			12
#define STATS_CLIPINOUT			st.stats[STAT_CLIPINOUT]
#define STAT_CLIPOUTHARD		13
#define STATS_CLIPOUTHARD		st.stats[STAT_CLIPOUTHARD]
#define STAT_CLIPOUTFAILED		14
#define STATS_CLIPOUTFAILED		st.stats[STAT_CLIPOUTFAILED]
#define STAT_CLIPINHARD			15
#define STATS_CLIPINHARD		st.stats[STAT_CLIPINHARD]
#define STAT_CLIPCOUNT			16
#define STATS_CLIPCOUNT			st.stats[STAT_CLIPCOUNT]

#define STAT_NETERRSENDSOFT		18
#define STATS_NETERRSENDSOFT		st.stats[STAT_NETERRSENDSOFT]
#define STAT_NETAUTOTIME		19
#define STATS_NETAUTOTIME		st.stats[STAT_NETAUTOTIME]

#define STAT_NETERRLOW			20		/* 20 - 25 */
#define STATS_NETERRLOW			(st.stats+STAT_NETERRLOW)

#define STAT_DISPLAYLISTSIZE		26
#define STATS_DISPLAYLISTSIZE		st.stats[STAT_DISPLAYLISTSIZE]
#define STAT_TIME3D			27
#define STATS_TIME3D			st.stats[STAT_TIME3D]
#define STAT_TIMESIM			28
#define STATS_TIMESIM			st.stats[STAT_TIMESIM]
#define STAT_TIMESYNC			29
#define STATS_TIMESYNC			st.stats[STAT_TIMESYNC]
#define STAT_TIMEHDD			30
#define STATS_TIMEHDD			st.stats[STAT_TIMEHDD]
#define STAT_FRAMESCOUNT		31
#define STATS_FRAMESCOUNT		st.stats[STAT_FRAMESCOUNT]
#define STAT_TIMETOTAL			32
#define STATS_TIMETOTAL			st.stats[STAT_TIMETOTAL]
#define STAT_TIMEVIDEO			33
#define STATS_TIMEVIDEO			st.stats[STAT_TIMEVIDEO]

#define STAT_TTIME3D			34
#define STATS_TTIME3D			st.stats[STAT_TTIME3D]
#define STAT_TTIMESIM			35
#define STATS_TTIMESIM			st.stats[STAT_TTIMESIM]
#define STAT_TTIMESYNC			36
#define STATS_TTIMESYNC			st.stats[STAT_TTIMESYNC]
#define STAT_TTIMEHDD			37
#define STATS_TTIMEHDD			st.stats[STAT_TTIMEHDD]

#define STAT_DEBUG			40
#define STATS_DEBUG			st.stats[STAT_DEBUG]
#define STAT_LOGTIME			41
#define STATS_LOGTIME			st.stats[STAT_LOGTIME]

#define STAT_MEMMAXUSED			45
#define STATS_MEMMAXUSED		st.stats[STAT_MEMMAXUSED]
#define STAT_MEMALLOCED			46
#define STATS_MEMALLOCED		st.stats[STAT_MEMALLOCED]
#define STAT_MEMTOTAL			47
#define STATS_MEMTOTAL			st.stats[STAT_MEMTOTAL]
#define STAT_MEMNO			48
#define STATS_MEMNO			st.stats[STAT_MEMNO]
#define STAT_MEMLOW			49
#define STATS_MEMLOW			st.stats[STAT_MEMLOW]

#define STAT_NETERRFOUND		50
#define STATS_NETERRFOUND		st.stats[STAT_NETERRFOUND]
#define STAT_NETERRLOST			51
#define STATS_NETERRLOST		st.stats[STAT_NETERRLOST]
#define STAT_NETERRPACKED		52
#define STATS_NETERRPACKED		st.stats[STAT_NETERRPACKED]
#define STAT_NETRECEIVEDP		53
#define STATS_NETRECEIVEDP		st.stats[STAT_NETRECEIVEDP]
#define STAT_NETSENTP			54
#define STATS_NETSENTP			st.stats[STAT_NETSENTP]
#define STAT_NETERRNOISE		55
#define STATS_NETERRNOISE		st.stats[STAT_NETERRNOISE]
#define STAT_NETERROOO			56
#define STATS_NETERROOO			st.stats[STAT_NETERROOO]

#define STAT_GRERRMOVEXLOW		60
#define STATS_GRERRMOVEXLOW		st.stats[STAT_GRERRMOVEXLOW]
#define STAT_GRERRMOVEXHIGH		61
#define STATS_GRERRMOVEXHIGH		st.stats[STAT_GRERRMOVEXHIGH]
#define STAT_GRERRMOVEYLOW		62
#define STATS_GRERRMOVEYLOW		st.stats[STAT_GRERRMOVEYLOW]
#define STAT_GRERRMOVEYHIGH		63
#define STATS_GRERRMOVEYHIGH		st.stats[STAT_GRERRMOVEYHIGH]
#define STAT_GRERRDRAWXLOW		64
#define STATS_GRERRDRAWXLOW		st.stats[STAT_GRERRDRAWXLOW]
#define STAT_GRERRDRAWXHIGH		65
#define STATS_GRERRDRAWXHIGH		st.stats[STAT_GRERRDRAWXHIGH]
#define STAT_GRERRDRAWYLOW		66
#define STATS_GRERRDRAWYLOW		st.stats[STAT_GRERRDRAWYLOW]
#define STAT_GRERRDRAWYHIGH		67
#define STATS_GRERRDRAWYHIGH		st.stats[STAT_GRERRDRAWYHIGH]
#define STAT_ERRBUFLINE			68
#define STATS_ERRBUFLINE		st.stats[STAT_ERRBUFLINE]

#define STAT_TCLIPOUT			70
#define STATS_TCLIPOUT			st.stats[STAT_TCLIPOUT]
#define STAT_TCLIPIN			71
#define STATS_TCLIPIN			st.stats[STAT_TCLIPIN]
#define STAT_TCLIPINOUT			72
#define STATS_TCLIPINOUT		st.stats[STAT_TCLIPINOUT]
#define STAT_TCLIPOUTHARD		73
#define STATS_TCLIPOUTHARD		st.stats[STAT_TCLIPOUTHARD]
#define STAT_TCLIPOUTFAILED		74
#define STATS_TCLIPOUTFAILED		st.stats[STAT_TCLIPOUTFAILED]
#define STAT_TCLIPINHARD		75
#define STATS_TCLIPINHARD		st.stats[STAT_TCLIPINHARD]
#define STAT_TCLIPCOUNT			76
#define STATS_TCLIPCOUNT		st.stats[STAT_TCLIPCOUNT]

#define STAT_MOVECOUNT			78
#define STATS_MOVECOUNT			st.stats[STAT_MOVECOUNT]
#define STAT_DRAWCOUNT			79
#define STATS_DRAWCOUNT			st.stats[STAT_DRAWCOUNT]

#define STAT_TEMP1			80		/* 80 - 89 */
#define STATS_TEMP1			(st.stats+STAT_TEMP1)

#define STAT_TEMP2			90		/* 90 - 99 */
#define STATS_TEMP2			(st.stats+STAT_TEMP2)
