/*  $Id$

    Designed and implemented by Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1995 University of Amsterdam. All rights reserved.
*/

:- module(qlf,
	  [ qcompile/1,		% +File
	    qload/1		% +File
	  ]).

:- style_check(+dollar).

		 /*******************************
		 *	   COMPILATION		*
		 *******************************/

:- module_transparent
	qcompile/1,
	qload/1,
	qload/2.


qcompile([]) :- !.
qcompile([H|T]) :- !,
	qcompile(H),
	qcompile(T).
qcompile(File) :-
	$strip_module(File, Module, FileName),
	$chk_file(FileName, Absolute, [''], ['.pl', '']), !,
	remove_suffix(Absolute, '.pl', ABase),
	ensure_suffix(ABase, '.qlf', Qlf),
	$qlf_open(Qlf),
	flag($compiling, Old, qlf),
	consult(Module:Absolute),
	flag($compiling, _, Old),
	$qlf_close.

remove_suffix(F, S, B) :-
	concat(B, S, F), !.
remove_suffix(F, _, F).

ensure_suffix(X, S, X) :-
	concat(_, S, X), !.
ensure_suffix(X, S, XS) :-
	concat(X, S, XS).

	
		 /*******************************
		 *	      LOADING		*
		 *******************************/

qload([]) :- !.
qload([H|T]) :- !,
	qload(H),
	qload(T).
qload(File) :-
	qload(File, [verbose = true]).

qload(File, Options) :-
	system:statistics(heapused, OldHeap),
	system:statistics(cputime, OldTime),

	$strip_module(File, Module, FileName),
	$chk_file(FileName, Absolute, [''], ['.qlf', '']), !,
	$qlf_load(Absolute, LoadedModule),
	(   atom(LoadedModule)
	->  (   memberchk(import = List, Options),
	        is_list(List)
	    ->	import_all(List,  LoadedModule, Module)
	    ;	export_list(LoadedModule, Public),
		import_all(Public, LoadedModule, Module)
	    )
	;   true
	),

	(   memberchk(verbose=true, Options)
	->  system:statistics(heapused, Heap),
	    system:statistics(cputime, Time),
	    HeapUsed is Heap - OldHeap,
	    TimeUsed is Time - OldTime,
	    $confirm_file(FileName, Absolute, ConfirmFile),
	    confirm_module(LoadedModule, ConfirmModule),

	    $ttyformat('~N~w loaded~w, ~2f sec, ~D bytes.~n',
		       [ConfirmFile, ConfirmModule, TimeUsed, HeapUsed])
	;   true
	).


confirm_module(user, '').
confirm_module(0, '').
confirm_module(Module, S) :-
	sformat(S, ' in module ~w', [Module]).

import_all([], _, _).
import_all([H|T], LoadedModule, Target) :-
	Target:import(LoadedModule:H),
	import_all(T, LoadedModule, Target).
	
