/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* clos_wi5.c non ansi c per windows*/

#include "clos.h"
#pragma hdrstop
#include <ddeml.h>
#include <dde.h>

#include <io.h>

HDDEDATA EXPENTRY _export DDECallback ( WORD wType, WORD wFmt, HCONV hConv, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
				DWORD dwData2 );

DWORD	idInst=0L;
FARPROC lpDdeProc=NULL;
HCONV	hConvApp=NULL;
HSZ     hszService;
HSZ     hszTopic;
char	szDDEData[145];
BOOL	DDEInProgress=FALSE;

BOOL ClosDDEInit(void){

 idInst=0L;
 lpDdeProc = MakeProcInstance ( (FARPROC) DDECallback, hInst );
 if ( DdeInitialize ( (LPDWORD)&idInst, (PFNCALLBACK)lpDdeProc,APPCLASS_STANDARD, 0L ) )
 {
   BWCCMessageBox(hClosWindow,"DDE initialization failure.","Clos Error",MB_OK); 
   return ( FALSE );
 }
 else
 {
   hszService = DdeCreateStringHandle ( idInst, "CLOS", CP_WINANSI );
   hszTopic = DdeCreateStringHandle ( idInst, "LISPFILE", CP_WINANSI );
   DdeNameService ( idInst, hszService, (HSZ) NULL, DNS_REGISTER );
 }
 return TRUE;
}

BOOL ClosDDEUnInit(void){

  if(DDEInProgress){
    DDEInProgress=FALSE;
    if(hClosWindow){
      lisp_print_string("\n-----DDE Return-----\n",stdout);
      //UpdateDynClosWindow(TRUE);
    }
    unlink(szDDEData);
  }

  if ( hConvApp != NULL ){
    DdeDisconnect ( hConvApp );
    hConvApp = NULL;
  }
  DdeFreeStringHandle ( idInst, hszService );
  DdeFreeStringHandle ( idInst, hszTopic );
  FreeProcInstance ( lpDdeProc );
  return DdeUninitialize ( idInst );
}


#pragma argsused
HDDEDATA EXPENTRY _export DDECallback ( WORD wType, WORD wFmt, HCONV hConv, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
                                DWORD dwData2 )
{
  node n;
  switch ( wType ){
    case XTYP_CONNECT:
      if ( hsz2 == hszService ){
        return ( (HDDEDATA) TRUE );
      }else{
        //HandleOutput ( "XTYP_CONNECT: hsz2 != hszService" );
        return ( (HDDEDATA) FALSE );
      }
    case XTYP_POKE:
      if ( hsz1 == hszTopic ){
        DdeGetData ( hData, (LPBYTE) szDDEData, 80L, 0L );
	if ( szDDEData != NULL ){
	  lisp_print_string("\n-----DDE Eval-----\n",stdout);
	  //UpdateDynClosWindow(TRUE);
          DDEInProgress=TRUE;
	  n=eval_lisp_file_async(szDDEData);
          DDEInProgress=FALSE;
	  if(n!=VOID){
	    fprint_func(n,stdout);
	    lisp_print_string("\n",stdout);
	  }
	  lisp_print_string("-----DDE Return-----\n>",stdout);
	  //UpdateDynClosWindow(TRUE);
          unlink(szDDEData);
          return ( (HDDEDATA) DDE_FACK );
        }
      }else
        return ( (HDDEDATA) NULL );
      break;
    case XTYP_CONNECT_CONFIRM:
      hConvApp = hConv;
      break;
    case XTYP_DISCONNECT:
      hConvApp = NULL;
      break;
   }
   return ( (HDDEDATA) NULL );
}