/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_tc3.c */
/* codice non ansi-c per msdos */
#include "clos.h"
#include <graphics.h>

/* void far setlinestyle(int linestyle, unsigned upattern, int thickness);*/
/* void far setfillstyle(int pattern, int color); */

/*  b g r */
int colors[]=
{
    EGA_BLACK,
    EGA_BLUE,
    EGA_GREEN,
    EGA_CYAN,
    EGA_RED,
    EGA_MAGENTA,
    EGA_BROWN,
    EGA_LIGHTGRAY,
    EGA_DARKGRAY,
    EGA_LIGHTBLUE,
    EGA_LIGHTGREEN,
    EGA_LIGHTCYAN,
    EGA_LIGHTRED,
    EGA_LIGHTMAGENTA,
    EGA_YELLOW,
    EGA_WHITE
};

int pen_types[6]={USERBIT_LINE,SOLID_LINE,DASHED_LINE,DOTTED_LINE,CENTER_LINE,USERBIT_LINE};
int pen_patte[6]={0           ,0         ,0          ,0          ,0          ,0x3f33       };
									   /* 0b0011111100110011*/
int brush_types[8]={EMPTY_FILL,SOLID_FILL,LINE_FILL,INTERLEAVE_FILL,HATCH_FILL,SLASH_FILL,BKSLASH_FILL,XHATCH_FILL};
/*
EMPTY_FILL        0   Background color
SOLID_FILL        1   Solid fill
LINE_FILL         2   ---
LTSLASH_FILL      3   ///
SLASH_FILL        4   ///, thick lines
BKSLASH_FILL      5   \\\, thick lines
LTBKSLASH_FILL    6   \\\
HATCH_FILL        7   Light hatch
XHATCH_FILL       8   Heavy crosshatch
INTERLEAVE_FILL   9   Interleaving lines
WIDE_DOT_FILL    10   Widely spaced dots
CLOSE_DOT_FILL   11   Closely spaced dots
USER_FILL        12   User-defined fill pattern
*/
int linetick		=1;
int linetype		=1;
int brushpattern	=1;
int brushcolor		=EGA_WHITE;
int graphopen		=0;
int ncolors		=0;
int palindex		=1;

int translatec(long co)
{
 int c;
 int r,g,b;

 b=(int)( (co&0x00ff0000L) >> 16 );
 g=(int)( (co&0x0000ff00L) >> 8 );
 r=(int)  (co&0x000000ffL);

 if(ncolors==16){
   c=( ( (r&0x80) & (g&0x80) & (b&0x80) ) >>4 );
   /* c=8 se tutti i primi bit di r,g,b sono a 1 */
   if(c){
     c|=( (r&0x40) >> 4 );
     c|=( (g&0x40) >> 5 );
     c|=( (b&0x40) >> 6 );
   }else{
     c|=( ( (r&0x40) >> 4 )|( (r&0x80) >> 5 ) );
     c|=( ( (g&0x40) >> 5 )|( (g&0x80) >> 6 ) );
     c|=( ( (b&0x40) >> 6 )|( (b&0x80) >> 7 ) );
   }
 }else{
   setrgbpalette(palindex,r>>2,g>>2,b>>2);
   c=palindex++;
   if(palindex==256)palindex=1;
 }
 return c;
}

long ctranslate(int co)
{
 long c;
  if(ncolors==16){
  /* co= 0...15 */
  if(co>=8){
    co-=8;
    c=0x00808080L;
  }else{
    c=0;
  }
  if(co&0x1)    /* b*/
    c|=0x00000040L;
  if(co&0x2)   /* g */
    c|=0x00004000L;
  if(co&0x4)  /* r */
    c|=0x00400000L;
  }


 return c;
}


void lg_opengraph(int m,int *row,int *col)
{
 int gm,ggm;
 if(m){
   if(graphopen){
     *row=0;
     *col=0;
     return;
   }
   ggm=VGA;
   switch(m){
     case 1: ggm=IBM8514;gm=IBM8514LO;*row=200;*col=320;ncolors=256;break;
     case 2: ggm=VGA    ;gm=VGAHI    ;*row=480;*col=640;ncolors=16; break;
     case 3: ggm=VGA    ;gm=VGAMED   ;*row=350;*col=640;ncolors=16; break;
     default:ggm=VGA    ;gm=VGALO    ;*row=200;*col=640;ncolors=16; break;
   }
   initgraph(&ggm,&gm,"");
   lg_pencolor(0x00ffffffL);
   lg_brushcolor(0x00ffffffL);
   if(ggm<0){
    *row=0;
    *col=0;
   }else{
    graphopen=1;
   }
 }else{
   if(graphopen)closegraph();
   *row=0;
   *col=0;
   graphopen=0;
 }
}

int lg_graphopen()
{
 return graphopen;
}

void lg_cleargraph()
{
 cleardevice();
}


void lg_pencolor(long co)
{
 setcolor(translatec(co));
}

void lg_pentick(int t)
{
 /* funziona solo con 1 oppure 3 */
 t=t<3?1:3;
 linetick=t;
 setlinestyle(pen_types[linetype],pen_patte[linetype],linetick);
}

void lg_pentype(int t)
{
 if(t<0 || t>5)t=1;  /* 0 1 2 3 4 5 */
 linetype=t;
 setlinestyle(pen_types[linetype],pen_patte[linetype],linetick);
}

void lg_brushcolor(long co)
{
 brushcolor=translatec(co);
 setfillstyle(brush_types[brushpattern],brushcolor);
}

void lg_brushtype(int t)
{
 if(t<0 || t>7)t=1;  /* 0 1 2 3 4 5 6 7*/
 brushpattern=t;
 setfillstyle(brush_types[brushpattern],brushcolor);
}

void lg_putpixel(int x,int y,long c)
{
 putpixel(x,y,translatec(c));
}

long lg_getpixel(int x,int y)
{
 return ctranslate(getpixel(x,y));
}

void lg_moveto(int x,int y)
{
 moveto(x,y);
}

void lg_lineto(int x,int y)
{
 lineto(x,y);
}

void lg_fillpoly(int pts,int *points)
{
 fillpoly(pts,points);
}

void lg_fillsector(int x,int y,int sa,int ea,int xr,int yr)
{
 sector(x,y,sa,ea,xr,yr);
}

void lg_fillellipse(int x,int y,int xr,int yr)
{
 fillellipse(x,y,xr,yr);
}

void lg_graphtext(int x,int y,char *s)
{
 outtextxy(x,y,s);
}