/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_lf5.c */

#include "clos.h"



/*** Predicati e funzioni logiche ***************************************/
/* INTP    , REALP  , RATIOP  , SYSFUNCP , UFUNCP , ACCESSORP           */
/* METHODP , CLASSP , ENAMEP  , CNAMEP   , STREAMP, MACROP		*/
/* SYMBOLP , CONSP  , VALUEP  						*/
/* ATOM    , LISTP  ,FUNCTIONP, NUMBERP	, ENDP     , EQUAL  , EQ	*/
/* ISZERO  , PLUSP  , MINUSP  , ODDP    , EVENP    , GREAT  , LESS      */
/* NUMEQUAL, AND    , OR      , NOT     , IF       , WHEN   , UNLESS	*/
/************************************************************************/

/* Nota**************************************************/
/* NULL		    tradotto in NOT			*/
/* >                   ,,        GREAT			*/
/* <                   ,,        LESS                   */
/*							*/
/* STRINGP,string=,STRING-EQUAL sono definite nei moduli*/
/*                                       delle stringhe */
/********************************************************/


/* (IN EQUAL AGGIUNGERE SYSFUNC,UFUNC,ECC)				*/

void lf_intp LF_PARAMS
{
 /* controlla se il nodo e' un integer  */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_INTEGER)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_realp LF_PARAMS
{
 /* controlla se il nodo e' un real    */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_REAL)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_ratiop LF_PARAMS
{
 /* controlla se il nodo e' un ratio    */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_RATIO)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_sysfuncp LF_PARAMS
{
 /* controlla se il nodo e' una sysfunc */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_SYSFUNC)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_ufuncp LF_PARAMS
{
 /* controlla se il nodo e' una sysfunc */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_UFUNC)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_accessorp LF_PARAMS
{
 /* controlla se il nodo e' una sysfunc */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_ACCESSOR)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_methodp LF_PARAMS
{
 /* controlla se il nodo e' una sysfunc */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_METHOD)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_classp LF_PARAMS
{
 /* controlla se il nodo e' una classe */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_CLASS)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_cnamep LF_PARAMS
{
 /* controlla se il nodo e' un cname  ( :nodo )  */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_CNAME)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_enamep LF_PARAMS
{
 /* controlla se il nodo e' un ename  ( &nodo )  */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_ENAME)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_streamp LF_PARAMS
{
 /* controlla se il nodo e' uno stream */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_STREAM)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_macrop LF_PARAMS
{
 /* controlla se il nodo e' una macro */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_MACRO)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}


void lf_symbolp LF_PARAMS
{
 /* controlla se il nodo e' un simbolo (T) */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nout->node=IS_NAME(calc_pointer(nout))?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}


void lf_consp LF_PARAMS
{
 /* controlla se il nodo e' CONS (T) */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nout->node=IS_CONS(calc_pointer(nout))?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_valuep LF_PARAMS
{
 /* controlla se il nodo e' un nodo-valore (T) */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nout->node=IS_VALUE(calc_pointer(nout))?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

/*-------------------------------------------------------------------------*/

void lf_atom LF_PARAMS
{
 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    nout->node=IS_CONS(calc_pointer(nout))?NIL:T;
    nout->type=P_ALLNODE;
    return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&nin);
}

void lf_listp LF_PARAMS
{
 /* controlla se il nodo e' CONS o NIL (T) */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_CONS(nin)||nin==NIL)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_functionp LF_PARAMS
{
 /* controlla se il nodo e' una funzione */
 REGISTER_MOD n_type t;

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->type=P_ALLNODE;
     if(IS_VALUE(nin)){
       t=GET_VTYPE(nin);
       if(t==NT_SYSFUNC||t==NT_UFUNC||t==NT_METHOD||t==NT_ACCESSOR){
	 nout->node=T;
	 return;
       }
     }
     nout->node=NIL;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_numberp LF_PARAMS
{
 /* controlla se il nodo e' un numero */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=IS_VALUE_AND_NUMBER(nin)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_endp LF_PARAMS
{
 /* controlla se il nodo e' CONS (T) o NIL (NIL) */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     if((nin=calc_pointer(nout))==NIL){
	nout->type=P_ALLNODE;
	nout->node=T;
	return;
     }
     if(IS_CONS(nin)){
	nout->type=P_ALLNODE;
	nout->node=NIL;
	return;
     }
     error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

int compare_nodes();
void lf_equal LF_PARAMS
{
 node value1;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   value1=calc_pointer(nout);
   if(IS_CONS(CONSRIGHT(nin))){
     while(IS_CONS(nin=CONSRIGHT(nin))){
       eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
       if(!compare_nodes(value1,calc_pointer(nout))){
	 nout->node=NIL;
	 nout->type=P_ALLNODE;
	 return;
       }
     }
     nout->node=T;
     nout->type=P_ALLNODE;
     return;
   }
   error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

#define EQUAL 1
#define NEQUAL 0

int compare_nodes(n1,n2)
node n1;
node n2;
{
 if(GET_NTYPE(n1)!=GET_NTYPE(n2))return NEQUAL;
 switch(GET_NTYPE(n1)){
   case NT_IS_CONS:
     return
       compare_nodes(CONSLEFT(n1),CONSLEFT(n2))&&
       compare_nodes(CONSRIGHT(n1),CONSRIGHT(n2));
   case NT_IS_NAME:
     return n1==n2;
   case NT_IS_VALUE:
     if(GET_VTYPE(n1)!=GET_VTYPE(n2))return NEQUAL;
     switch(GET_VTYPE(n1)){
       case NT_INTEGER:
	 return INTEGER(n1)==INTEGER(n2);
       case NT_REAL:
	 return REAL(n1)==REAL(n2);
       case NT_RATIO:
	 return
	   (RATIO_NUM(n1)==RATIO_NUM(n2))&&
	   (RATIO_DEN(n1)==RATIO_DEN(n2));
       case NT_STRING:
	 return
	   !strcmp(string_get(STRING(n1),buf1),string_get(STRING(n2),buf2));
       case NT_CNAME:
	 return compare_nodes(CNAME(n1),CNAME(n2));
       case NT_ENAME:
	 return compare_nodes(ENAME(n1),ENAME(n2));
       case NT_STREAM:
	 return STREAM(n1)==STREAM(n2);
     }
     error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n1);
   }
   return 0;
}

void lf_eq LF_PARAMS
{
 node p1;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   p1=calc_pointer(nout);
   if(IS_CONS(CONSRIGHT(nin))){
     while(IS_CONS(nin=CONSRIGHT(nin))){
       eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
       if(calc_pointer(nout)!=p1){
         nout->node=NIL;
         nout->type=P_ALLNODE;
         return;
       }
     }
     nout->type=P_ALLNODE;
     nout->node=T;
     return;
   }
   error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}



/************************************************************************/

void lf_iszero LF_PARAMS
{
 /* controlla se il nodo e' un numero e se e' zero */
 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    nin=calc_pointer(nout);
    nout->type=P_ALLNODE;
    if(IS_VALUE(nin)){
	switch(GET_VTYPE(nin)){
		case NT_INTEGER:
			nout->node=INTEGER(nin)?NIL:T;
			return;
		case NT_RATIO:
			nout->node=RATIO_NUM(nin)?NIL:T;
			return;
		case NT_REAL:
			nout->node=REAL(nin)?NIL:T;
			return;
	}
    }
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_plusp LF_PARAMS
{
 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    if(IS_VALUE_AND_NUMBER(nin=calc_pointer(nout))){
	nout->type=P_ALLNODE;
	switch(GET_VTYPE(nin)){
	    case NT_INTEGER:
		nout->node=INTEGER(nin)>0?T:NIL;
		return;
	    case NT_REAL:
		nout->node=REAL(nin)>0?T:NIL;
		return;
	    case NT_RATIO:
		nout->node=(RATIO_NUM(nin)>0)^(RATIO_DEN(nin)>0)?NIL:T;
		return;
	}
    }
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_minusp LF_PARAMS
{
 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    if(IS_VALUE_AND_NUMBER(nin=calc_pointer(nout))){
        nout->type=P_ALLNODE;
	switch(GET_VTYPE(nin)){
	    case NT_INTEGER:
                nout->node=INTEGER(nin)<0?T:NIL;
		return;
	    case NT_REAL:
                nout->node=REAL(nin)<0?T:NIL;
                return;
            case NT_RATIO:
		nout->node=(RATIO_NUM(nin)>0)^(RATIO_DEN(nin)>0)?T:NIL;
                return;
        }
    }
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_oddp LF_PARAMS
{
 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    nin=calc_pointer(nout);
    if(IS_VALUE_AND_NUMBER(nin)&&GET_VTYPE(nin)==NT_INTEGER){
	nout->type=P_ALLNODE;
	nout->node=INTEGER(nin)&1?T:NIL;
	return;
    }
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_evenp LF_PARAMS
{
 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    nin=calc_pointer(nout);
    if(IS_VALUE_AND_NUMBER(nin)&&GET_VTYPE(nin)==NT_INTEGER){
        nout->type=P_ALLNODE;
        nout->node=INTEGER(nin)&1?NIL:T;
	return;
    }
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

#define TF_FIRST 0
#define TF_INT   1
#define TF_RAT   2
#define TF_FLO   3

void lf_less LF_PARAMS
{
 /* controlla se gli argomenti sono in ordine strettamente crescente */

 REGISTER_MOD int    type_flag=TF_FIRST;
 REGISTER_MOD n_type t;
 n_int  last_int;
 n_real last_real;
 n_real tmp;
 node	n;

   while(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      if( (t=TYPE(n=calc_pointer(nout)))&NT_IS_VALUE){
	 switch(t&NT_MASK){
	     case NT_INTEGER:
		switch(type_flag){
		   case TF_FIRST:
		      type_flag=TF_INT;
		      last_int=INTEGER(n);
		      nin=CONSRIGHT(nin);
		      continue;
		   case TF_INT:
		      if(last_int<INTEGER(n)){
                        last_int=INTEGER(n);
                        nin=CONSRIGHT(nin);
                        continue;
                      }
                      nout->node=NIL;
                      nout->type=P_ALLNODE;
                      return;
		   case TF_FLO:
		      if(last_real<(n_real)INTEGER(n)){
                        last_real=(n_real)INTEGER(n);
                        nin=CONSRIGHT(nin);
                        continue;
		      }
		      nout->node=NIL;
                      nout->type=P_ALLNODE;
                      return;
		}
             case NT_RATIO:
                switch(type_flag){
		   case TF_FIRST:
                      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      type_flag=TF_FLO;
                      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      if((n_real)last_int<last_real){
			type_flag=TF_FLO;
			nin=CONSRIGHT(nin);
                        continue;
                      }
                      nout->node=NIL;
		      nout->type=P_ALLNODE;
		      return;
                   case TF_FLO:
                      tmp=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
		      if(last_real<tmp){
                        last_real=tmp;
                        nin=CONSRIGHT(nin);
			continue;
                      }
                      nout->node=NIL;
                      nout->type=P_ALLNODE;
                      return;
                }
             case NT_REAL:
                switch(type_flag){
		   case TF_FIRST:
		      last_real=REAL(n);
                      type_flag=TF_FLO;
                      nin=CONSRIGHT(nin);
                      continue;
		   case TF_INT:
		      if((n_real)last_int<REAL(n)){
                        last_real=REAL(n);
                        type_flag=TF_FLO;
			nin=CONSRIGHT(nin);
                        continue;
                      }
		      nout->node=NIL;
                      nout->type=P_ALLNODE;
                      return;
                   case TF_FLO:
                      if(last_real<REAL(n)){
                        last_real=REAL(n);
                        nin=CONSRIGHT(nin);
                        continue;
		      }
		      nout->node=NIL;
                      nout->type=P_ALLNODE;
                      return;
                }
	     default:
	       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
         }/* switch */
      }/* if is-value */
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   }/* while */
 nout->type=P_ALLNODE;
 nout->node=T;
}

void lf_great LF_PARAMS
{
 /* controlla se gli argomenti sono in ordine strettamente crescente */

 REGISTER_MOD int    type_flag=TF_FIRST;
 REGISTER_MOD n_type t;
 n_int  last_int;
 n_real last_real;
 n_real tmp;
 node	n;

   while(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      if( (t=TYPE(n=calc_pointer(nout)))&NT_IS_VALUE){
	 switch(t&NT_MASK){
             case NT_INTEGER:
                switch(type_flag){
		   case TF_FIRST:
		      type_flag=TF_INT;
		      last_int=INTEGER(n);
		      nin=CONSRIGHT(nin);
		      continue;
		   case TF_INT:
		      if(last_int>INTEGER(n)){
			last_int=INTEGER(n);
			nin=CONSRIGHT(nin);
			continue;
		      }
		      nout->node=NIL;
		      nout->type=P_ALLNODE;
		      return;
		   case TF_FLO:
		      if(last_real>(n_real)INTEGER(n)){
			last_real=(n_real)INTEGER(n);
			nin=CONSRIGHT(nin);
			continue;
		      }
		      nout->node=NIL;
                      nout->type=P_ALLNODE;
                      return;
                }
             case NT_RATIO:
                switch(type_flag){
                   case TF_FIRST:
                      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
		      type_flag=TF_FLO;
		      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
                      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
		      if((n_real)last_int>last_real){
			type_flag=TF_FLO;
                        nin=CONSRIGHT(nin);
                        continue;
		      }
                      nout->node=NIL;
                      nout->type=P_ALLNODE;
		      return;
                   case TF_FLO:
                      tmp=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
                      if(last_real>tmp){
                        last_real=tmp;
                        nin=CONSRIGHT(nin);
                        continue;
                      }
		      nout->node=NIL;
		      nout->type=P_ALLNODE;
                      return;
                }
             case NT_REAL:
		switch(type_flag){
		   case TF_FIRST:
                      last_real=REAL(n);
                      type_flag=TF_FLO;
		      nin=CONSRIGHT(nin);
                      continue;
                   case TF_INT:
		      if((n_real)last_int>REAL(n)){
                        last_real=REAL(n);
                        type_flag=TF_FLO;
                        nin=CONSRIGHT(nin);
                        continue;
                      }
                      nout->node=NIL;
                      nout->type=P_ALLNODE;
		      return;
		   case TF_FLO:
                      if(last_real>REAL(n)){
                        last_real=REAL(n);
                        nin=CONSRIGHT(nin);
			continue;
		      }
                      nout->node=NIL;
                      nout->type=P_ALLNODE;
		      return;
                }
             default:
	       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
         }/* switch */
      }/* if is-value */
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   }/* while */
 nout->type=P_ALLNODE;
 nout->node=T;
}

void lf_numequal LF_PARAMS
{
 /* controlla se gli argomenti sono tutti uguali */

 REGISTER_MOD int    type_flag=TF_FIRST;
 REGISTER_MOD n_type t;
 n_int  last_int;
 n_real last_real;
 node	n;

   while(IS_CONS(nin)){
      eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
      if( (t=TYPE(n=calc_pointer(nout)))&NT_IS_VALUE){
	 switch(t&NT_MASK){
	     case NT_INTEGER:
		switch(type_flag){
		   case TF_FIRST:
		      type_flag=TF_INT;
		      last_int=INTEGER(n);
		      nin=CONSRIGHT(nin);
		      continue;
		   case TF_INT:
		      if(last_int==INTEGER(n)){
			nin=CONSRIGHT(nin);
			continue;
		      }
		      nout->node=NIL;
		      nout->type=P_ALLNODE;
		      return;
		   case TF_FLO:
		      if(last_real==(n_real)INTEGER(n)){
			nin=CONSRIGHT(nin);
			continue;
		      }
		      nout->node=NIL;
		      nout->type=P_ALLNODE;
		      return;
		}
	     case NT_RATIO:
		switch(type_flag){
		   case TF_FIRST:
		      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
		      type_flag=TF_FLO;
		      nin=CONSRIGHT(nin);
		      continue;
		   case TF_INT:
		      last_real=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
		      if((n_real)last_int==last_real){
			type_flag=TF_FLO;
			nin=CONSRIGHT(nin);
			continue;
		      }
		      nout->node=NIL;
		      nout->type=P_ALLNODE;
		      return;
		   case TF_FLO:
		    if(last_real==(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n)){
		      nin=CONSRIGHT(nin);
		      continue;
		    }
		    nout->node=NIL;
		    nout->type=P_ALLNODE;
		    return;
		}
	     case NT_REAL:
		switch(type_flag){
		   case TF_FIRST:
		      last_real=REAL(n);
		      type_flag=TF_FLO;
		      nin=CONSRIGHT(nin);
		      continue;
		   case TF_INT:
		      if((n_real)last_int==(last_real=REAL(n))){
			type_flag=TF_FLO;
			nin=CONSRIGHT(nin);
			continue;
		      }
		      nout->node=NIL;
		      nout->type=P_ALLNODE;
		      return;
		   case TF_FLO:
		      if(last_real==REAL(n)){
			nin=CONSRIGHT(nin);
			continue;
		      }
		      nout->node=NIL;
		      nout->type=P_ALLNODE;
		      return;
		}
	     default:
	       error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
	 }/* switch */
      }/* if is-value */
      error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   }/* while */
 nout->type=P_ALLNODE;
 nout->node=T;
}

/* ----------------------------------------------------------------------- */

void lf_and LF_PARAMS
{
 node n=nin;

 nout->type=P_ALLNODE;
 nout->node=NIL;

 while(nin!=NIL){
    if(IS_CONS(nin)){
	eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	if(calc_pointer(nout)==NIL)
	    return;
	nin=CONSRIGHT(nin);
	continue;
    }
    error(E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
 }
}

void lf_or LF_PARAMS
{
 node n=nin;

 nout->type=P_ALLNODE;
 nout->node=NIL;

 while(nin!=NIL){
    if(IS_CONS(nin)){
	eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	if(calc_pointer(nout)!=NIL)
	    return;
	nin=CONSRIGHT(nin);
	continue;
    }
    error(E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
 }
}

void lf_not LF_PARAMS
{
 if(IS_CONS(nin)){
	eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	nout->node=calc_pointer(nout)==NIL?T:NIL;
	nout->type=P_ALLNODE;
	return;
 }
 error(nin==NIL?E_FEWARGS:E_BADLIST,
	ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_if LF_PARAMS
{
 /* sintassi:  (if sTest sTrue sFalse) */
 /* nin= (Stest sTrue sFalse) */

 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=CONSRIGHT(nin);
   if(IS_CONS(nin)){
     if(calc_pointer(nout)==NIL){
       nin=CONSRIGHT(nin);
       if(IS_CONS(nin)){
	 eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	 return;
       }else{
	 error(nin==NIL?E_FEWARGS:E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
       }
     }else{
       eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
       return;
     }
   }else{
     error(nin==NIL?E_FEWARGS:E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
   }
 }else{
   error(nin==NIL?E_FEWARGS:E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
}

void lf_when LF_PARAMS
{
 /* sintassi:  (when sTest sTrue) */
 /* nin= (Stest sTrue ) */
 node n;

 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    n=calc_pointer(nout);
    nout->node=NIL;
    nout->type=P_ALLNODE;
    if(n==NIL)return;
    while(IS_CONS(nin=CONSRIGHT(nin))){
	eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    }
    return;
 }
 error(E_BADLIST,ERR_MNONE|ERR_PVOID|ERR_TBLVL,&nin);
}

void lf_unless LF_PARAMS
{
 /* sintassi:  (when sTest sFalse) */
 /* nin= (Stest sFalse ) */
 node n;

 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    n=calc_pointer(nout);
    nout->node=NIL;
    nout->type=P_ALLNODE;
    if(n!=NIL)return;
    while(IS_CONS(nin=CONSRIGHT(nin))){
	eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    }
    return;
 }
 error(E_BADLIST,ERR_MNONE|ERR_PVOID|ERR_TBLVL,&nin);
}
