/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.Lists;
import com.google.jstestdriver.config.CmdFlags;
import com.google.jstestdriver.config.CmdLineFlag;
import java.util.Iterator;
import java.util.LinkedList;

public class CmdLineFlagsFactory {
    public CmdFlags create(String[] args) {
        CmdLineFlagIterator iterator = new CmdLineFlagIterator(args);
        LinkedList<CmdLineFlag> flags = Lists.newLinkedList();
        while (iterator.hasNext()) {
            flags.add(iterator.next());
        }
        return new CmdFlags(flags);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CmdLineFlagIterator
    implements Iterator<CmdLineFlag> {
        private final String[] args;
        private int pos = 0;

        public CmdLineFlagIterator(String[] args) {
            this.args = args;
        }

        @Override
        public boolean hasNext() {
            while (this.pos < this.args.length) {
                if (this.args[this.pos].startsWith("--")) {
                    return true;
                }
                ++this.pos;
            }
            return false;
        }

        @Override
        public CmdLineFlag next() {
            int next;
            int current = this.pos++;
            if ((next = this.pos++) >= this.args.length || this.args[next].startsWith("--")) {
                if (this.args[current].contains("=")) {
                    String[] flagValue = this.args[current].split("=");
                    return new CmdLineFlag(flagValue[0], flagValue[1]);
                }
                return new CmdLineFlag(this.args[current], null);
            }
            return new CmdLineFlag(this.args[current], this.args[next]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

