/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.DXF;
import com.sun.electric.tool.io.output.EDIF;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Telesis;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExportForeignTest
extends AbstractTest {
    public ExportForeignTest(String name) {
        super(name);
    }

    public ExportForeignTest(String name, boolean interactive) {
        super(name, false, interactive);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new ExportForeignTest("CIF1"));
        list.add(new ExportForeignTest("CIF2"));
        list.add(new ExportForeignTest("DXF"));
        list.add(new ExportForeignTest("EAGLE"));
        list.add(new ExportForeignTest("ECAD"));
        list.add(new ExportForeignTest("EDIF"));
        list.add(new ExportForeignTest("ESIM"));
        list.add(new ExportForeignTest("FastHenry"));
        list.add(new ExportForeignTest("GDS"));
        list.add(new ExportForeignTest("L"));
        list.add(new ExportForeignTest("LEFDEF"));
        list.add(new ExportForeignTest("Mossim"));
        list.add(new ExportForeignTest("PADS"));
        list.add(new ExportForeignTest("PAL"));
        list.add(new ExportForeignTest("PNG", true));
        list.add(new ExportForeignTest("Silos"));
        list.add(new ExportForeignTest("Spice1"));
        list.add(new ExportForeignTest("Spice2"));
        list.add(new ExportForeignTest("Spice3"));
        if (EvalJavaBsh.hasBeanShell()) {
            list.add(new ExportForeignTest("Spice4"));
            list.add(new ExportForeignTest("Spice4_C"));
        }
        list.add(new ExportForeignTest("SpiceBus"));
        list.add(new ExportForeignTest("STL"));
        list.add(new ExportForeignTest("SVG"));
        list.add(new ExportForeignTest("Tegas"));
        list.add(new ExportForeignTest("Telesis"));
        list.add(new ExportForeignTest("Verilog1"));
        list.add(new ExportForeignTest("Verilog2"));
        list.add(new ExportForeignTest("Verilog3"));
        list.add(new ExportForeignTest("Verilog4"));
        list.add(new ExportForeignTest("Verilog5"));
        list.add(new ExportForeignTest("Verilog6"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Database/output/";
    }

    public Boolean CIF1() {
        return ExportForeignTest.exportGDS_CIF("cif", this.getRegressionPath() + "/data/qThree", "qThreeTop.jelib", "qThreeTop", this.getRegressionPath() + "/tools/IO/output/", 750, 0);
    }

    public Boolean CIF2() {
        return ExportForeignTest.exportGDS_CIF("cif", this.getRegressionPath() + "/data/muddChip", "MIPS.jelib", "chip", this.getRegressionPath() + "/tools/IO/output/", 5748, 0);
    }

    public Boolean DXF() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "DXFOut.log", "DXFTest1.dxf", "DXFTest", FileType.DXF);
    }

    public Boolean EAGLE() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "EAGLEOut.log", "EagleTest1.txt", "EaglePadsECADTest{sch}", FileType.EAGLE);
    }

    public Boolean ECAD() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "ECADOut.log", "ECADTest1.enl", "EaglePadsECADTest{sch}", FileType.ECAD);
    }

    public Boolean EDIF() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "EDIFOut.log", "EDIFTest1.edif", "Bus{sch}", FileType.EDIF);
    }

    public Boolean ESIM() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "ESIMOut.log", "SimTest1.sim", "SimTest{lay}", FileType.ESIM);
    }

    public Boolean FastHenry() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "FastHenryOut.log", "FastHenryTest1.inp", "FastHenryTest{lay}", FileType.FASTHENRY);
    }

    public Boolean GDS() {
        return ExportForeignTest.exportGDS_CIF("gds", this.getRegressionPath() + "/tools/IO/data/libs", "simpleDRCTest.jelib", "NoErrorsOnPins", this.getRegressionPath() + "/tools/IO/output/", 0, 0);
    }

    public Boolean L() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "LOut.log", "LTest1.L", "LTest{lay}", FileType.L);
    }

    public Boolean LEFDEF() {
        Boolean result1 = ExportForeignTest.runExportTest(this.getRegressionPath(), "LEFOut.log", "LEFTest1.lef", "LEFTest{lay}", FileType.LEF);
        Boolean result2 = ExportForeignTest.runExportTest(this.getRegressionPath(), "DEFOut.log", "DEFTest1.lef", "LEFTest{lay}", FileType.DEF);
        return result1 != false && result2 != false;
    }

    public Boolean Mossim() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "MossimOut.log", "MOSSIMTest1.ntk", "MOSSIMTest{lay}", FileType.MOSSIM);
    }

    public Boolean PADS() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "PADSOut.log", "PadsTest1.asc", "EaglePadsECADTest{sch}", FileType.PADS);
    }

    public Boolean PAL() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "PALOut.log", "PalTest1.pal", "PalTest{sch}", FileType.PAL);
    }

    public Boolean PNG() {
        if (!(Job.getExtendedUserInterface() instanceof UserInterfaceMain)) {
            return Boolean.TRUE;
        }
        return ExportForeignTest.runExportTestFromMenu(this.getRegressionPath(), "PNGOut.log", "PNGTest1.png", "PNGTest1{lay}", null);
    }

    public Boolean Silos() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "SilosOut.log", "SilosTest1.sil", "SilosTest{sch}", FileType.SILOS);
    }

    public Boolean Spice1() {
        return ExportForeignTest.basicSpice(this.getRegressionPath(), "SpiceOut1.log", "SpiceHOut1.spi", "SpiceTest1{lay}", SimulationTool.SpiceEngine.SPICE_ENGINE_H, SimulationTool.SpiceParasitics.RC_CONSERVATIVE, SimulationTool.SpiceGlobal.USEGLOBALBLOCK, false, false);
    }

    public Boolean Spice2() {
        return ExportForeignTest.basicSpice(this.getRegressionPath(), "SpiceOut2.log", "SpiceHOut2.spi", "SpiceTest2{sch}", SimulationTool.SpiceEngine.SPICE_ENGINE_H, SimulationTool.SpiceParasitics.RC_CONSERVATIVE, SimulationTool.SpiceGlobal.USEGLOBALBLOCK, false, false);
    }

    public Boolean Spice3() {
        return ExportForeignTest.basicSpice(this.getRegressionPath(), "SpiceOut3.log", "Spice3Out1.spi", "SpiceTest2{sch}", SimulationTool.SpiceEngine.SPICE_ENGINE_3, SimulationTool.SpiceParasitics.RC_CONSERVATIVE, SimulationTool.SpiceGlobal.USESUBCKTPORTS, false, false);
    }

    public Boolean Spice4() {
        return ExportForeignTest.basicSpice(this.getRegressionPath(), "SpiceOut4.log", "SpiceHOut4.spi", "SpiceTest4{sch}", SimulationTool.SpiceEngine.SPICE_ENGINE_H, SimulationTool.SpiceParasitics.RC_CONSERVATIVE, SimulationTool.SpiceGlobal.USEGLOBALBLOCK, false, false);
    }

    public Boolean Spice4_C() {
        return ExportForeignTest.basicSpice(this.getRegressionPath(), "SpiceHOut4_c.log", "SpiceHOut4_c.spi", "SpiceTest4{sch}", SimulationTool.SpiceEngine.SPICE_ENGINE_H, SimulationTool.SpiceParasitics.RC_CONSERVATIVE, SimulationTool.SpiceGlobal.USEGLOBALBLOCK, false, true);
    }

    public Boolean SpiceBus() {
        return ExportForeignTest.basicSpice(this.getRegressionPath(), "SpiceBus.log", "SpiceBus.spi", "Bus{sch}", SimulationTool.SpiceEngine.SPICE_ENGINE_H, SimulationTool.SpiceParasitics.RC_CONSERVATIVE, SimulationTool.SpiceGlobal.USESUBCKTPORTS, false, false);
    }

    public Boolean STL() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "STLOut.log", "STLTest.stl", "STLTest{lay}", FileType.STL);
    }

    public Boolean SVG() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "SVGOut.log", "SVG1.svg", "SVGTest1{lay}", FileType.SVG);
    }

    public Boolean Tegas() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "TegasOut.log", "TegasTest1.tdl", "TegasTest{sch}", FileType.TEGAS);
    }

    public Boolean Telesis() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "TelesisOut.log", "TelesisTest.txt", "TelesisTest{sch}", FileType.TELESIS);
    }

    public Boolean Verilog1() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "Verilog1Out.log", "VerilogFile1.v", "VerilogTest1{sch}", FileType.VERILOG);
    }

    public Boolean Verilog2() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "Verilog2Out.log", "VerilogFile2.v", "VerilogTest2{sch}", FileType.VERILOG);
    }

    public Boolean Verilog3() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "Verilog3Out.log", "VerilogFile3.v", "VerilogTest3{sch}", FileType.VERILOG);
    }

    public Boolean Verilog4() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "Verilog4Out.log", "VerilogFile4.v", "VerilogTest4{sch}", FileType.VERILOG);
    }

    public Boolean Verilog5() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "Verilog5Out.log", "VerilogFile5.v", "VerilogTest5{sch}", FileType.VERILOG);
    }

    public Boolean Verilog6() {
        return ExportForeignTest.runExportTest(this.getRegressionPath(), "Verilog6Out.log", "VerilogFile6.v", "VerilogTest6WithVeryLongNameNowIsTheTimeForAllGoodMenToComeToTheAidOfTheParty-1-nowIsTheTimeForAllGoodMenToComeToTheAidOfTheParty-2{lay}", FileType.VERILOG);
    }

    public static Boolean exportGDS_CIF(String type, String regName, String libName, String cellName, int expectedE, int expectedW) {
        return ExportForeignTest.exportGDS_CIF(type, regName, libName, cellName, "", expectedE, expectedW);
    }

    private static Boolean exportGDS_CIF(String type, String regName, String libName, String cellName, String outputDir, int expectedE, int expectedW) {
        FileType theType = FileType.findType(type);
        ExportForeignTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + type + "LogFile.log");
        try {
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            Library rootLib = LayoutLib.openLibForRead(regName + "/" + libName, ep, true);
            Cell lay = rootLib.findNodeProto(cellName + "{lay}");
            Output.OutputPreferences op = Output.getOutputPreferences(theType, null, true, null);
            op.disablePopups();
            Output out = op.doOutput(lay, VarContext.globalContext, outputDir + "output." + type);
            if (out != null) {
                System.out.println("Got " + out.getNumErrors() + " errors and " + out.getNumWarnings() + " warnings");
                if (expectedE != out.getNumErrors() || expectedW != out.getNumWarnings()) {
                    System.out.println("BUT EXPECTED " + expectedE + " errors and " + expectedW + " warnings");
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    private static Boolean basicSpice(String rootPath, String logFile, String outputFile, String cellToWrite, SimulationTool.SpiceEngine engine, SimulationTool.SpiceParasitics parasitics, SimulationTool.SpiceGlobal global, boolean noResistors, boolean useCellParams) {
        Spice.SpicePreferences sp2 = new Spice.SpicePreferences(true, false);
        sp2.engine = engine;
        sp2.ignoreParasiticResistors = noResistors;
        sp2.parasiticsLevel = parasitics;
        sp2.globalTreatment = global;
        sp2.useCellParameters = useCellParams;
        return ExportForeignTest.runExportTestFromMenu(rootPath, logFile, outputFile, cellToWrite, sp2);
    }

    private static Boolean runExportTest(String rootPath, String logFile, String outputFile, String cellToWrite, FileType type) {
        return ExportForeignTest.runExportTestFromMenu(rootPath, logFile, outputFile, cellToWrite, Output.getOutputPreferences(type, null, true, null));
    }

    private static Boolean runExportTestFromMenu(String rootPath, String logFile, String outputFile, String cellToWrite, Output.OutputPreferences op) {
        if (op != null) {
            op.disablePopups();
        }
        String trueRootPath = rootPath != null ? rootPath + "/tools/IO/" : "";
        return ExportForeignTest.runExportTestInternal(trueRootPath, "data/libs", "netlistTests.jelib", logFile, outputFile, cellToWrite, op, Technology.getMocmosTechnology());
    }

    public static Boolean runExportTest(String libPath, String libName, String logFile, String outputFile, String cellToWrite, FileType type, String spiceModel, String layTech, String spiceFlags, String spiceLevel, String spiceGlobal) {
        Output.OutputPreferences op = Output.getOutputPreferences(type, null, true, null);
        if (type == FileType.SPICE) {
            Spice.SpicePreferences sp2 = (Spice.SpicePreferences)op;
            if (spiceModel != null && !spiceModel.equals("")) {
                sp2.engine = SimulationTool.SpiceEngine.valueOf(spiceModel);
            }
            if (spiceFlags.contains("p")) {
                sp2.ignoreParasiticResistors = true;
            }
            if (spiceFlags.contains("c")) {
                sp2.useCellParameters = true;
            }
            if (!spiceLevel.equals("")) {
                sp2.parasiticsLevel = SimulationTool.SpiceParasitics.valueOf(spiceLevel);
            }
            if (!spiceGlobal.equals("")) {
                sp2.globalTreatment = SimulationTool.SpiceGlobal.valueOf(spiceGlobal);
            }
        }
        return ExportForeignTest.runExportTestInternal("", libPath, libName, logFile, outputFile, cellToWrite, op, Technology.findTechnology(layTech));
    }

    private static Boolean runExportTestInternal(String trueRootPath, String libPath, String libName, String logFile, String outputFile, String cellToWrite, Output.OutputPreferences op, Technology layTech) {
        String outputDir = trueRootPath + "output/";
        ExportForeignTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + logFile);
        ProjSettings.readSettings(new File(trueRootPath + "data/projsettings_" + layTech.getTechName() + ".xml"), EDatabase.currentDatabase(), true, true);
        EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
        String destFile = outputDir + outputFile;
        String expectedFilePath = trueRootPath + "data/expected/" + outputFile;
        Boolean good = Boolean.TRUE;
        try {
            URL fileURL = TextUtils.makeURLToFile(trueRootPath + libPath + "/" + libName);
            Library lib = Library.findLibrary(libName);
            if (lib == null) {
                lib = LibraryFiles.readLibrary(ep, fileURL, null, FileType.JELIB, true);
            }
            if (lib == null) {
                System.out.println("Error loading " + fileURL.getFile());
                return Boolean.FALSE;
            }
            Library.repairAllLibraries(ep);
            Job.setCurrentLibraryInJob(lib);
            Cell cell = lib.findNodeProto(cellToWrite);
            String destFileOrdir = destFile;
            if (op == null) {
                new FileMenu.ExportImage(cell, null, destFile, true);
                if (!ExportForeignTest.compareImages(-1, destFile, expectedFilePath)) {
                    good = Boolean.FALSE;
                }
            } else {
                if (op instanceof Spice.SpicePreferences) {
                    ((Spice.SpicePreferences)op).modelFiles = ExportForeignTest.convertVarsToModelFiles(Spice.SPICE_MODEL_FILE_KEY);
                } else if (op instanceof Verilog.VerilogPreferences) {
                    ((Verilog.VerilogPreferences)op).modelFiles = ExportForeignTest.convertVarsToModelFiles(Verilog.VERILOG_BEHAVE_FILE_KEY);
                } else if (op instanceof DXF.DXFPreferences) {
                    ((DXF.DXFPreferences)op).tech = Technology.getMocmosTechnology();
                } else if (op instanceof Telesis.TelesisPreferences) {
                    destFileOrdir = outputDir;
                } else if (op instanceof EDIF.EDIFPreferences) {
                    ((EDIF.EDIFPreferences)op).writeTime = false;
                }
                op.includeDateAndVersionInOutput = false;
                if (cell != null) {
                    Output out = op.doOutput(cell, null, destFileOrdir, ep);
                    System.out.println("Errors writing: " + out.getNumErrors());
                    System.out.println("Warnings writing: " + out.getNumWarnings());
                }
                if (!ExportForeignTest.compareResults(destFile, expectedFilePath)) {
                    good = Boolean.FALSE;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            good = Boolean.FALSE;
        }
        return good;
    }

    private static Map<Cell, String> convertVarsToModelFiles(Variable.Key varKey) {
        HashMap<Cell, String> m = new HashMap<Cell, String>();
        Iterator<Library> lit = Library.getLibraries();
        while (lit.hasNext()) {
            Library lib = lit.next();
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                String unfilteredModelFile = cell.getVarValue(varKey, String.class);
                if (unfilteredModelFile == null || unfilteredModelFile.length() <= 0) continue;
                m.put(cell, unfilteredModelFile);
            }
        }
        return m;
    }
}

