/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.storage;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNode;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarOpenListBase;
import com.sun.electric.tool.routing.experimentalAStar2.storage.AStarNodeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.PriorityQueue;

public class AStarOpenListPriorityQueue
implements AStarOpenListBase<AStarNode> {
    private int initialCapacity = 100;
    private PriorityQueue<AStarNode> queue = new PriorityQueue<AStarNode>(this.initialCapacity, new AStarNodeComparator());

    @Override
    public void addNodeToOpenList(AStarNode node) {
        this.queue.add(node);
        node.markAsOpen();
    }

    @Override
    public AStarNode findOpenNode(int x, int y, int z) {
        for (AStarNode current : this.queue) {
            if (current.getX() != x || current.getY() != y || current.getZ() != z) continue;
            return current;
        }
        return null;
    }

    @Override
    public boolean isOpenListEmpty() {
        return this.queue.size() == 0;
    }

    @Override
    public AStarNode removeCheapestOpenNode() {
        AStarNode node = this.queue.poll();
        if (node != null) {
            node.markAsNoList();
        }
        return node;
    }

    public Collection<AStarNode> dumpOpenList() {
        ArrayList<AStarNode> dump = new ArrayList<AStarNode>(this.queue);
        this.queue.clear();
        return dump;
    }

    @Override
    public void removeNodeFromOpenList(AStarNode node) {
        this.queue.remove(node);
        node.markAsNoList();
    }

    public void setMap(AStarMapBase<AStarNode> map2) {
    }

    @Override
    public void clearOpenList() {
        this.queue.clear();
    }
}

