/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.AssertionErrorWithFacts;
import com.google.common.truth.ComparisonFailures;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.LazyMessage;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FailureMetadata {
    private final FailureStrategy strategy;
    private final ImmutableList<LazyMessage> messages;
    private final ImmutableList<Step> steps;

    static FailureMetadata forFailureStrategy(FailureStrategy failureStrategy) {
        return new FailureMetadata(failureStrategy, (ImmutableList<LazyMessage>)ImmutableList.of(), (ImmutableList<Step>)ImmutableList.of());
    }

    FailureMetadata(FailureStrategy strategy, ImmutableList<LazyMessage> messages, ImmutableList<Step> steps) {
        this.strategy = (FailureStrategy)Preconditions.checkNotNull((Object)strategy);
        this.messages = (ImmutableList)Preconditions.checkNotNull(messages);
        this.steps = (ImmutableList)Preconditions.checkNotNull(steps);
    }

    FailureMetadata updateForSubject(Subject subject) {
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.subjectCreation(subject));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall() {
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(null, null));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall(OldAndNewValuesAreSimilar valuesAreSimilar, Function<String, String> descriptionUpdate) {
        Preconditions.checkNotNull(descriptionUpdate);
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(valuesAreSimilar, descriptionUpdate));
        return this.derive(this.messages, steps);
    }

    FailureMetadata withMessage(String format, Object[] args) {
        ImmutableList<LazyMessage> messages = SubjectUtils.append(this.messages, new LazyMessage(format, args));
        return this.derive(messages, this.steps);
    }

    void failEqualityCheck(ImmutableList<Fact> headFacts, ImmutableList<Fact> tailFacts, String expected, String actual) {
        this.doFail(Platform.makeComparisonFailure(LazyMessage.evaluateAll(this.messages), ComparisonFailures.makeComparisonFailureFacts(SubjectUtils.concat(new Iterable[]{this.description(), headFacts}), SubjectUtils.concat(new Iterable[]{tailFacts, this.rootUnlessThrowable()}), expected, actual), expected, actual, this.rootCause()));
    }

    void fail(ImmutableList<Fact> facts) {
        this.doFail(new AssertionErrorWithFacts(LazyMessage.evaluateAll(this.messages), SubjectUtils.concat(new Iterable[]{this.description(), facts, this.rootUnlessThrowable()}), this.rootCause()));
    }

    private void doFail(AssertionError failure) {
        Platform.cleanStackTrace((Throwable)((Object)failure));
        this.strategy.fail(failure);
    }

    private FailureMetadata derive(ImmutableList<LazyMessage> messages, ImmutableList<Step> steps) {
        return new FailureMetadata(this.strategy, messages, steps);
    }

    private ImmutableList<Fact> description() {
        String description = Platform.inferDescription();
        boolean descriptionIsInteresting = description != null;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                Preconditions.checkState((description != null ? 1 : 0) != 0);
                if (step.descriptionUpdate == null) {
                    description = null;
                    descriptionIsInteresting = false;
                    continue;
                }
                description = (String)Verify.verifyNotNull((Object)step.descriptionUpdate.apply((Object)description));
                descriptionIsInteresting = true;
                continue;
            }
            if (description != null) continue;
            description = step.subject.typeDescription();
        }
        return descriptionIsInteresting ? ImmutableList.of((Object)Fact.fact("value of", description)) : ImmutableList.of();
    }

    private ImmutableList<Fact> rootUnlessThrowable() {
        Step rootSubject = null;
        boolean seenDerivation = false;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                seenDerivation |= step.descriptionUpdate != null && step.valuesAreSimilar == OldAndNewValuesAreSimilar.DIFFERENT;
                continue;
            }
            if (rootSubject != null) continue;
            if (step.subject.actual() instanceof Throwable) {
                return ImmutableList.of();
            }
            rootSubject = step;
        }
        return seenDerivation ? ImmutableList.of((Object)Fact.fact(String.valueOf(rootSubject.subject.typeDescription()).concat(" was"), rootSubject.subject.actualCustomStringRepresentationForPackageMembersToCall())) : ImmutableList.of();
    }

    @Nullable
    private Throwable rootCause() {
        for (Step step : this.steps) {
            if (step.isCheckCall() || !(step.subject.actual() instanceof Throwable)) continue;
            return (Throwable)step.subject.actual();
        }
        return null;
    }

    static enum OldAndNewValuesAreSimilar {
        SIMILAR,
        DIFFERENT;

    }

    private static final class Step {
        @Nullable
        final Subject subject;
        @Nullable
        final Function<String, String> descriptionUpdate;
        @Nullable
        final OldAndNewValuesAreSimilar valuesAreSimilar;

        static Step subjectCreation(Subject subject) {
            return new Step((Subject)Preconditions.checkNotNull((Object)subject), null, null);
        }

        static Step checkCall(OldAndNewValuesAreSimilar valuesAreSimilar, @Nullable Function<String, String> descriptionUpdate) {
            return new Step(null, descriptionUpdate, valuesAreSimilar);
        }

        private Step(@Nullable Subject subject, @Nullable Function<String, String> descriptionUpdate, @Nullable OldAndNewValuesAreSimilar valuesAreSimilar) {
            this.subject = subject;
            this.descriptionUpdate = descriptionUpdate;
            this.valuesAreSimilar = valuesAreSimilar;
        }

        boolean isCheckCall() {
            return this.subject == null;
        }
    }
}

