/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.StringHelper;

final class LatLonPointDistanceQuery
extends Query {
    final String field;
    final double latitude;
    final double longitude;
    final double radiusMeters;

    public LatLonPointDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Rectangle box = Rectangle.fromPointDistance((double)this.latitude, (double)this.longitude, (double)this.radiusMeters);
        final byte[] minLat = new byte[4];
        final byte[] maxLat = new byte[4];
        final byte[] minLon = new byte[4];
        final byte[] maxLon = new byte[4];
        final byte[] minLon2 = new byte[4];
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLatitude((double)box.minLat), (byte[])minLat, (int)0);
        NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLatitude((double)box.maxLat), (byte[])maxLat, (int)0);
        if (box.crossesDateline()) {
            NumericUtils.intToSortableBytes((int)Integer.MIN_VALUE, (byte[])minLon, (int)0);
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.maxLon), (byte[])maxLon, (int)0);
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.minLon), (byte[])minLon2, (int)0);
        } else {
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.minLon), (byte[])minLon, (int)0);
            NumericUtils.intToSortableBytes((int)GeoEncodingUtils.encodeLongitude((double)box.maxLon), (byte[])maxLon, (int)0);
            NumericUtils.intToSortableBytes((int)Integer.MAX_VALUE, (byte[])minLon2, (int)0);
        }
        final double sortKey = GeoUtils.distanceQuerySortKey((double)this.radiusMeters);
        final double axisLat = Rectangle.axisLat((double)this.latitude, (double)this.radiusMeters);
        return new ConstantScoreWeight(this, boost){
            final GeoEncodingUtils.DistancePredicate distancePredicate;
            {
                super(x0, x1);
                this.distancePredicate = GeoEncodingUtils.createDistancePredicate((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)LatLonPointDistanceQuery.this.radiusMeters);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(LatLonPointDistanceQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointDistanceQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, LatLonPointDistanceQuery.this.field);
                PointValues.IntersectVisitor visitor = this.getIntersectVisitor(result);
                1 weight = this;
                return new ScorerSupplier((Weight)weight, visitor, result){
                    long cost = -1L;
                    final /* synthetic */ Weight val$weight;
                    final /* synthetic */ PointValues.IntersectVisitor val$visitor;
                    final /* synthetic */ DocIdSetBuilder val$result;
                    {
                        this.val$weight = weight;
                        this.val$visitor = intersectVisitor;
                        this.val$result = docIdSetBuilder;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        if (values.getDocCount() == reader.maxDoc() && (long)values.getDocCount() == values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                            FixedBitSet result = new FixedBitSet(reader.maxDoc());
                            result.set(0, reader.maxDoc());
                            int[] cost = new int[]{reader.maxDoc()};
                            values.intersect(this.getInverseIntersectVisitor(result, cost));
                            BitSetIterator iterator = new BitSetIterator((BitSet)result, (long)cost[0]);
                            return new ConstantScoreScorer(this.val$weight, this.score(), (DocIdSetIterator)iterator);
                        }
                        values.intersect(this.val$visitor);
                        return new ConstantScoreScorer(this.val$weight, this.score(), this.val$result.build().iterator());
                    }

                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimatePointCount(this.val$visitor);
                        }
                        assert (this.cost >= 0L);
                        return this.cost;
                    }
                };
            }

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        int docLongitude;
                        if (StringHelper.compare((int)4, (byte[])packedValue, (int)0, (byte[])maxLat, (int)0) > 0 || StringHelper.compare((int)4, (byte[])packedValue, (int)0, (byte[])minLat, (int)0) < 0) {
                            return;
                        }
                        if ((StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])maxLon, (int)0) > 0 || StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])minLon, (int)0) < 0) && StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])minLon2, (int)0) < 0) {
                            return;
                        }
                        int docLatitude = NumericUtils.sortableBytesToInt((byte[])packedValue, (int)0);
                        if (distancePredicate.test(docLatitude, docLongitude = NumericUtils.sortableBytesToInt((byte[])packedValue, (int)4))) {
                            this.adder.add(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare((int)4, (byte[])minPackedValue, (int)0, (byte[])maxLat, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)0, (byte[])minLat, (int)0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if ((StringHelper.compare((int)4, (byte[])minPackedValue, (int)4, (byte[])maxLon, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)4, (byte[])minLon, (int)0) < 0) && StringHelper.compare((int)4, (byte[])maxPackedValue, (int)4, (byte[])minLon2, (int)0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        double latMin = GeoEncodingUtils.decodeLatitude((byte[])minPackedValue, (int)0);
                        double lonMin = GeoEncodingUtils.decodeLongitude((byte[])minPackedValue, (int)4);
                        double latMax = GeoEncodingUtils.decodeLatitude((byte[])maxPackedValue, (int)0);
                        double lonMax = GeoEncodingUtils.decodeLongitude((byte[])maxPackedValue, (int)4);
                        return GeoUtils.relate((double)latMin, (double)latMax, (double)lonMin, (double)lonMax, (double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)sortKey, (double)axisLat);
                    }
                };
            }

            private PointValues.IntersectVisitor getInverseIntersectVisitor(final FixedBitSet result, final int[] cost) {
                return new PointValues.IntersectVisitor(){

                    public void visit(int docID) {
                        result.clear(docID);
                        cost[0] = cost[0] - 1;
                    }

                    public void visit(int docID, byte[] packedValue) {
                        int docLongitude;
                        if (StringHelper.compare((int)4, (byte[])packedValue, (int)0, (byte[])maxLat, (int)0) > 0 || StringHelper.compare((int)4, (byte[])packedValue, (int)0, (byte[])minLat, (int)0) < 0) {
                            result.clear(docID);
                            cost[0] = cost[0] - 1;
                            return;
                        }
                        if ((StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])maxLon, (int)0) > 0 || StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])minLon, (int)0) < 0) && StringHelper.compare((int)4, (byte[])packedValue, (int)4, (byte[])minLon2, (int)0) < 0) {
                            result.clear(docID);
                            cost[0] = cost[0] - 1;
                            return;
                        }
                        int docLatitude = NumericUtils.sortableBytesToInt((byte[])packedValue, (int)0);
                        if (!distancePredicate.test(docLatitude, docLongitude = NumericUtils.sortableBytesToInt((byte[])packedValue, (int)4))) {
                            result.clear(docID);
                            cost[0] = cost[0] - 1;
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare((int)4, (byte[])minPackedValue, (int)0, (byte[])maxLat, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)0, (byte[])minLat, (int)0) < 0) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        if ((StringHelper.compare((int)4, (byte[])minPackedValue, (int)4, (byte[])maxLon, (int)0) > 0 || StringHelper.compare((int)4, (byte[])maxPackedValue, (int)4, (byte[])minLon, (int)0) < 0) && StringHelper.compare((int)4, (byte[])maxPackedValue, (int)4, (byte[])minLon2, (int)0) < 0) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        double latMin = GeoEncodingUtils.decodeLatitude((byte[])minPackedValue, (int)0);
                        double lonMin = GeoEncodingUtils.decodeLongitude((byte[])minPackedValue, (int)4);
                        double latMax = GeoEncodingUtils.decodeLatitude((byte[])maxPackedValue, (int)0);
                        double lonMax = GeoEncodingUtils.decodeLongitude((byte[])maxPackedValue, (int)4);
                        PointValues.Relation relation = GeoUtils.relate((double)latMin, (double)latMax, (double)lonMin, (double)lonMax, (double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)sortKey, (double)axisLat);
                        switch (relation) {
                            case CELL_INSIDE_QUERY: {
                                return PointValues.Relation.CELL_OUTSIDE_QUERY;
                            }
                            case CELL_OUTSIDE_QUERY: {
                                return PointValues.Relation.CELL_INSIDE_QUERY;
                            }
                        }
                        return relation;
                    }
                };
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointDistanceQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(LatLonPointDistanceQuery other) {
        return this.field.equals(other.field) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude) && Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }
}

