/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.plaf.Style;
import net.yura.mobile.logging.Logger;

public class Slider
extends Component {
    public static final int MINIMUM_THUMB_SIZE = 5;
    private int min;
    private int max;
    private int value;
    private int extent;
    protected boolean horizontal = true;
    private boolean paintTicks = false;
    private int minorTickSpacing;
    private int majorTickSpacing;
    private int tickSpace;
    private ChangeListener chl;
    private Font font;
    int click;
    int startPos;
    int startValue;
    Style theme1;
    Style theme2;
    public static final int CLICK_NONE = 0;
    public static final int CLICK_UP = 1;
    public static final int CLICK_PGUP = 2;
    public static final int CLICK_THUMB = 3;
    public static final int CLICK_PGDOWN = 4;
    public static final int CLICK_DOWN = 5;

    public Slider() {
        this(0, 100, 50);
    }

    public Slider(int min, int max, int value) {
        this.min = min;
        this.max = max;
        this.value = value;
        this.extent = 0;
        this.tickSpace = this.font.getHeight() / 2;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.chl != null) {
            Logger.warn("trying to add a ChangeListener when there is already one registered");
            Logger.dumpStack();
        }
        if (l == null) {
            Logger.warn("trying to add a null ChangeListener");
            Logger.dumpStack();
        }
        this.chl = l;
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.chl == l) {
            this.chl = null;
        } else {
            Logger.warn("trying to remove a ChangeListener that is not registered");
            Logger.dumpStack();
        }
        if (l == null) {
            Logger.warn("trying to remove a null ChangeListener");
            Logger.dumpStack();
        }
    }

    protected void fireStateChanged() {
        if (this.chl != null) {
            this.chl.changeEvent(this, this.value);
        }
    }

    public void setHorizontal(boolean b) {
        this.horizontal = b;
    }

    public Object getValue() {
        return new Integer(this.value);
    }

    public void setValue(Object o) {
        if (o instanceof Integer) {
            this.setValue((Integer)o);
        } else {
            Logger.warn("trying to set value that is not a Integer " + o);
        }
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        int m = this.max - this.extent;
        if (newValue > m) {
            newValue = m;
        }
        if (newValue < this.min) {
            newValue = this.min;
        }
        this.value = newValue;
        if (this.value != oldValue) {
            this.fireStateChanged();
            this.repaint();
        }
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getExtent() {
        return this.extent;
    }

    public void setMaximum(int m) {
        this.max = m;
    }

    public void setMinimum(int m) {
        this.min = m;
    }

    public void setExtent(int ex) {
        this.extent = ex;
    }

    public void setSnapToTicks(boolean snap) {
    }

    public void setPaintTicks(boolean ticks) {
        this.paintTicks = ticks;
    }

    public void setMajorTickSpacing(int n) {
        this.majorTickSpacing = n;
    }

    public void setMinorTickSpacing(int n) {
        this.minorTickSpacing = n;
    }

    public Font getFont() {
        return this.font;
    }

    public void paintComponent(Graphics2D g) {
        int v = this.value - this.min;
        int m = this.max - this.min;
        if (this.horizontal) {
            this.drawScrollBar(g, 0, 0, this.width, this.height, v, this.extent, m);
        } else {
            int t = g.getTransform();
            g.setTransform(4);
            this.drawScrollBar(g, 0, 0, this.height, this.width, v, this.extent, m);
            g.setTransform(t);
        }
    }

    public void processMouseEvent(int type, int pointX, int pointY, KeyEvent keys) {
        super.processMouseEvent(type, pointX, pointY, keys);
        if (!this.focusable) {
            return;
        }
        if (type == 2) {
            this.click = 0;
        } else if (type == 1) {
            int v = this.value - this.min;
            int m = this.max - this.min;
            this.click = this.horizontal ? this.doClickInScrollbar(0, 0, this.width, this.height, v, this.extent, m, pointX, pointY) : this.doClickInScrollbar(0, 0, this.height, this.width, v, this.extent, m, pointY, pointX);
            if (this.click == 3) {
                this.startPos = this.horizontal ? pointX : pointY;
                this.startValue = this.value;
            } else if (this.click == 1 || this.click == 5) {
                this.getDesktopPane().animateComponent(this);
            } else if (this.click == 2 || this.click == 4) {
                int w = this.horizontal ? this.width : this.height;
                int h = this.horizontal ? this.height : this.width;
                int p = this.horizontal ? pointX : pointY;
                int newValue = this.getNewValueSlider(0, 0, w, h, this.extent, this.min, this.max, p);
                this.setValue(newValue);
            }
        } else if (type == 0 && this.click == 3) {
            int w = this.horizontal ? this.width : this.height;
            int h = this.horizontal ? this.height : this.width;
            int p = this.horizontal ? pointX : pointY;
            int newValue = this.getNewValueSlider(0, 0, w, h, this.startValue, this.extent, this.min, this.max, p - this.startPos);
            this.setValue(newValue);
        }
    }

    public boolean processKeyEvent(KeyEvent keypad) {
        int right;
        int left = this.horizontal ? 2 : 1;
        int n = right = this.horizontal ? 5 : 6;
        if (keypad.isDownAction(left)) {
            this.setValue(this.value - 1);
            return true;
        }
        if (keypad.isDownAction(right)) {
            this.setValue(this.value + 1);
            return true;
        }
        return keypad.justReleasedAction(left) || keypad.justReleasedAction(right);
    }

    protected void workoutMinimumSize() {
        int thickness;
        Border track = this.getTrack();
        int n = thickness = track != null ? track.getTop() + track.getBottom() : 0;
        if (this.paintTicks) {
            thickness += this.tickSpace;
        }
        if (this.horizontal) {
            this.width = 20;
            this.height = thickness;
        } else {
            this.width = thickness;
            this.height = 20;
        }
    }

    public void run() throws InterruptedException {
        while (true) {
            if (this.click == 1 && this.value > this.min) {
                this.setValue(this.value - 1);
            } else {
                if (this.click != 5 || this.value >= this.max - this.extent) break;
                this.setValue(this.value + 1);
            }
            this.wait(50);
        }
    }

    protected String getDefaultName() {
        return "Slider";
    }

    public String getName() {
        String name = super.getName();
        return name;
    }

    public void updateUI() {
        super.updateUI();
        this.font = this.theme.getFont(0);
        this.theme1 = DesktopPane.getDefaultTheme(this.getName() + "Thumb");
        this.theme2 = DesktopPane.getDefaultTheme(this.getName() + "Track");
    }

    protected Border getThumb() {
        return this.theme1.getBorder(this.getCurrentState());
    }

    protected Border getTrack() {
        return this.theme2.getBorder(this.getCurrentState());
    }

    public boolean consumesMotionEvents() {
        return true;
    }

    public int doClickInScrollbar(int x1, int y1, int w1, int h1, int value1, int extent1, int max1, int pointX, int pointY) {
        int[] tmp = this.getOffsets(x1, y1, w1, h1, value1, extent1, max1);
        int box = tmp[0];
        int startX = tmp[1];
        int extentW = tmp[2];
        if (ScrollPane.isPointInsideRect(pointX, pointY, x1, y1, box, h1)) {
            return 1;
        }
        if (ScrollPane.isPointInsideRect(pointX, pointY, x1 + box, y1, startX - x1 - box, h1)) {
            return 2;
        }
        if (ScrollPane.isPointInsideRect(pointX, pointY, startX, y1, extentW, h1)) {
            return 3;
        }
        if (ScrollPane.isPointInsideRect(pointX, pointY, startX + extentW, y1, w1 - box - (startX - x1) - extentW, h1)) {
            return 4;
        }
        if (ScrollPane.isPointInsideRect(pointX, pointY, x1 + w1 - box, y1, box, h1)) {
            return 5;
        }
        return 0;
    }

    public void drawScrollBar(Graphics2D g, int x, int y, int w, int h, int value, int extent, int max) {
        Border track = this.getTrack();
        Border thumb = this.getThumb();
        int[] tmp = this.getOffsets(x, y, w, h, value, extent, max);
        int startX = tmp[1];
        int extentW = tmp[2];
        if (this.paintTicks) {
            int tickX;
            int c;
            g.setColor(this.getForeground());
            h -= this.tickSpace;
            int side = tmp[0] + (thumb != null ? thumb.getLeft() : 0);
            int space = w - side * 2;
            if (this.minorTickSpacing > 0) {
                for (c = 0; c <= max; c += this.minorTickSpacing) {
                    tickX = side + space * c / max;
                    g.drawLine(tickX, h, tickX, h + this.tickSpace / 2);
                }
            }
            if (this.majorTickSpacing > 0) {
                for (c = 0; c <= max; c += this.majorTickSpacing) {
                    tickX = side + space * c / max;
                    g.drawLine(tickX, h, tickX, h + this.tickSpace * 3 / 4);
                }
            }
        }
        if (track != null) {
            g.translate(x + track.getLeft(), y + track.getTop());
            track.paintBorder(this, g, w - track.getLeft() - track.getRight(), h - track.getTop() - track.getBottom());
            g.translate(-x - track.getLeft(), -y - track.getTop());
        }
        if (thumb != null) {
            int y1 = y + (h - thumb.getTop() - thumb.getBottom()) / 2;
            if (y1 + thumb.getTop() + thumb.getBottom() > y + h) {
                y1 = y + h - thumb.getTop() - thumb.getBottom();
            }
            g.translate(startX + thumb.getLeft(), y1 + thumb.getTop());
            thumb.paintBorder(this, g, extentW - thumb.getLeft() - thumb.getRight(), 0);
            g.translate(-startX - thumb.getLeft(), -y1 - thumb.getTop());
        }
    }

    public int[] getOffsets(int x, int y, int w, int h, int value, int extent, int max) {
        int startX;
        Border track = this.getTrack();
        Border thumb = this.getThumb();
        int box = track != null ? (track.getLeft() > h ? h : track.getLeft()) : 0;
        int leftRight = thumb == null ? 0 : thumb.getLeft() + thumb.getRight();
        int space1 = w - box * 2;
        int extentW = (int)((double)(extent * space1) / (double)max + 0.5);
        int min1 = leftRight < 5 ? 5 : leftRight;
        min1 = min1 > space1 / 2 ? space1 / 2 : min1;
        int space = space1;
        if (extentW < min1) {
            extentW = min1;
            space -= extentW;
            max -= extent;
        }
        if ((startX = box + (int)((double)(space * value) / (double)max + 0.5)) + extentW < box + min1) {
            startX = box;
            extentW = min1;
        } else if (startX < box) {
            extentW = startX + extentW - box;
            startX = box;
        } else if (startX > box + space1 - min1) {
            startX = box + space1 - min1;
            extentW = min1;
        } else if (startX + extentW > box + space1) {
            extentW = box + space1 - startX;
        }
        return new int[]{box, x + startX, extentW};
    }

    public int getNewValueSlider(int x, int y, int w, int h, int extent, int min, int max, int pixels) {
        int[] offsets = this.getOffsets(x, y, w, h, 0, extent, max - min);
        return this.getNewValueSlider(offsets, w, h, extent, min, max, pixels);
    }

    public int getNewValueSlider(int x, int y, int w, int h, int startValue, int extent, int min, int max, int pixels) {
        int[] offsets = this.getOffsets(x, y, w, h, startValue - min, extent, max - min);
        return this.getNewValueSlider(offsets, w, h, extent, min, max, offsets[1] + offsets[2] / 2 + pixels);
    }

    private int getNewValueSlider(int[] offsets, int w, int h, int extent, int min, int max, int p) {
        float barWidth = w - offsets[0] * 2 - offsets[2];
        float pixels = p - offsets[0] - offsets[2] / 2;
        float numberOfDivisions = max - min - extent;
        float newValue = pixels / barWidth * numberOfDivisions + 0.5f;
        return (int)newValue + min;
    }

    public int getNewValue(int x, int y, int w, int h, int value, int extent, int max, int pixels) {
        int[] offsets = this.getOffsets(x, y, w, h, 0, extent, max);
        return value + (max - extent) * pixels / (w - offsets[0] * 2 - offsets[2]);
    }
}

