/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.ScmDeviceComponent;

class ScmGauge
extends ScmDeviceComponent {
    Gauge gauge;

    ScmGauge(boolean interactive) {
        super(null, interactive ? "item.gauge.interactive" : "item.gauge", interactive);
    }

    public void init(Gauge gauge) {
        this.gauge = gauge;
        this.item = gauge;
    }

    public boolean keyPressed(String code) {
        if (this.getFocusable()) {
            if (code.equals("LEFT") && this.gauge.value > 0) {
                --this.gauge.value;
                this.repaint();
                return true;
            }
            if (code.equals("RIGHT") && this.gauge.value < this.gauge.maximum) {
                ++this.gauge.value;
                this.repaint();
                return true;
            }
        }
        return super.keyPressed(code);
    }

    public boolean mouseClicked(int button, int x, int y, int modifiers, int clicks) {
        if (super.mouseClicked(button, x, y, modifiers, clicks)) {
            return true;
        }
        if (!this.gauge.isInteractive()) {
            return false;
        }
        if (button == 1) {
            if (x < this.getWidth() / 2) {
                if (this.gauge.value > 0) {
                    this.gauge.value = Math.max(0, this.gauge.value - clicks);
                    this.repaint();
                    return true;
                }
            } else if (this.gauge.value < this.gauge.maximum) {
                this.gauge.value = Math.min(this.gauge.maximum, this.gauge.value + clicks);
                this.repaint();
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.getFocusable() && this.hasFocus()) {
            int m = this.getHeight() / 2;
            for (int i = 0; i < 4; ++i) {
                g.drawLine(i, m - i, i, m + i);
                g.drawLine(this.getWidth() - 1 - i, m - i, this.getWidth() - 1 - i, m + i);
            }
        }
        g.setColor(this.getFontInfo().foreground);
        int w = this.getWidth() - 13;
        int h = this.getHeight() - 3;
        g.drawRect(6, 1, w, h);
        int mx = w * this.gauge.value / this.gauge.maximum;
        g.fillRect(6, 2, mx, h);
    }
}

