/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class MergeTwoValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler,
WeightedAttributesHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 2925048980504034018L;
    private final SingleIndex m_AttIndex = new SingleIndex("last");
    private final SingleIndex m_FirstIndex = new SingleIndex("first");
    private final SingleIndex m_SecondIndex = new SingleIndex("last");

    public String globalInfo() {
        return "Merges two values of a nominal attribute into one value.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        this.m_FirstIndex.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        this.m_SecondIndex.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (instanceInfo.classIndex() > -1 && instanceInfo.classIndex() == this.m_AttIndex.getIndex()) {
            throw new Exception("Cannot process class attribute.");
        }
        if (!instanceInfo.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        if (this.m_SecondIndex.getIndex() <= this.m_FirstIndex.getIndex()) {
            throw new Exception("The second index has to be greater than the first.");
        }
        this.setOutputFormat();
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        Instance newInstance;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if ((int)(newInstance = (Instance)instance.copy()).value(this.m_AttIndex.getIndex()) == this.m_SecondIndex.getIndex()) {
            newInstance.setValue(this.m_AttIndex.getIndex(), (double)this.m_FirstIndex.getIndex());
        } else if ((int)newInstance.value(this.m_AttIndex.getIndex()) > this.m_SecondIndex.getIndex()) {
            newInstance.setValue(this.m_AttIndex.getIndex(), newInstance.value(this.m_AttIndex.getIndex()) - 1.0);
        }
        this.push(newInstance, false);
        return true;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSets the attribute index (default last).", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tSets the first value's index (default first).", "F", 1, "-F <value index>"));
        newVector.addElement(new Option("\tSets the second value's index (default last).", "S", 1, "-S <value index>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String attIndex = Utils.getOption('C', options);
        if (attIndex.length() != 0) {
            this.setAttributeIndex(attIndex);
        } else {
            this.setAttributeIndex("last");
        }
        String firstValIndex = Utils.getOption('F', options);
        if (firstValIndex.length() != 0) {
            this.setFirstValueIndex(firstValIndex);
        } else {
            this.setFirstValueIndex("first");
        }
        String secondValIndex = Utils.getOption('S', options);
        if (secondValIndex.length() != 0) {
            this.setSecondValueIndex(secondValIndex);
        } else {
            this.setSecondValueIndex("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-C");
        options.add("" + this.getAttributeIndex());
        options.add("-F");
        options.add("" + this.getFirstValueIndex());
        options.add("-S");
        options.add("" + this.getSecondValueIndex());
        return options.toArray(new String[0]);
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String firstValueIndexTipText() {
        return "Sets the first value to be merged. (\"first\" and \"last\" are valid values)";
    }

    public String getFirstValueIndex() {
        return this.m_FirstIndex.getSingleIndex();
    }

    public void setFirstValueIndex(String firstIndex) {
        this.m_FirstIndex.setSingleIndex(firstIndex);
    }

    public String secondValueIndexTipText() {
        return "Sets the second value to be merged. (\"first\" and \"last\" are valid values)";
    }

    public String getSecondValueIndex() {
        return this.m_SecondIndex.getSingleIndex();
    }

    public void setSecondValueIndex(String secondIndex) {
        this.m_SecondIndex.setSingleIndex(secondIndex);
    }

    private void setOutputFormat() {
        boolean firstEndsWithPrime = false;
        boolean secondEndsWithPrime = false;
        StringBuffer text = new StringBuffer();
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j != this.m_AttIndex.getIndex()) {
                newAtts.add((Attribute)att.copy());
                continue;
            }
            if (att.value(this.m_FirstIndex.getIndex()).endsWith("'")) {
                firstEndsWithPrime = true;
            }
            if (att.value(this.m_SecondIndex.getIndex()).endsWith("'")) {
                secondEndsWithPrime = true;
            }
            if (firstEndsWithPrime || secondEndsWithPrime) {
                text.append("'");
            }
            if (firstEndsWithPrime) {
                text.append(att.value(this.m_FirstIndex.getIndex()).substring(1, att.value(this.m_FirstIndex.getIndex()).length() - 1));
            } else {
                text.append(att.value(this.m_FirstIndex.getIndex()));
            }
            text.append('_');
            if (secondEndsWithPrime) {
                text.append(att.value(this.m_SecondIndex.getIndex()).substring(1, att.value(this.m_SecondIndex.getIndex()).length() - 1));
            } else {
                text.append(att.value(this.m_SecondIndex.getIndex()));
            }
            if (firstEndsWithPrime || secondEndsWithPrime) {
                text.append("'");
            }
            ArrayList<String> newVals = new ArrayList<String>(att.numValues() - 1);
            for (int i = 0; i < att.numValues(); ++i) {
                if (i == this.m_FirstIndex.getIndex()) {
                    newVals.add(text.toString());
                    continue;
                }
                if (i == this.m_SecondIndex.getIndex()) continue;
                newVals.add(att.value(i));
            }
            Attribute newAtt = new Attribute(att.name(), newVals);
            newAtt.setWeight(this.getInputFormat().attribute(j).weight());
            newAtts.add(newAtt);
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }

    public static void main(String[] argv) {
        MergeTwoValues.runFilter(new MergeTwoValues(), argv);
    }
}

