/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.standard.ShadingUtil;
import org.java.plugin.util.IoUtil;

final class ShadowDataController {
    private static final String META_FILE_NAME = ".meta";
    private final Log log = LogFactory.getLog(class$org$java$plugin$standard$ShadowDataController == null ? (class$org$java$plugin$standard$ShadowDataController = ShadowDataController.class$("org.java.plugin.standard.ShadowDataController")) : class$org$java$plugin$standard$ShadowDataController);
    private final File shadowFolder;
    private final URL shadowFolderUrl;
    private final Properties metaData;
    private final DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static /* synthetic */ Class class$org$java$plugin$standard$ShadowDataController;

    static ShadowDataController init(File file) throws IOException {
        ShadowDataController shadowDataController = new ShadowDataController(file);
        shadowDataController.quickCheck();
        shadowDataController.save();
        return shadowDataController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowDataController(File file) throws IOException {
        this.shadowFolder = file;
        this.shadowFolderUrl = IoUtil.file2url(file);
        File file2 = new File(this.shadowFolder, META_FILE_NAME);
        this.metaData = new Properties();
        if (file2.isFile()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                try {
                    this.metaData.load(fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
                this.log.debug("meta-data loaded from file " + file2);
            }
            catch (IOException iOException) {
                this.log.warn("failed loading meta-data from file " + file2, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        File file = new File(this.shadowFolder, META_FILE_NAME);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            try {
                this.metaData.store(fileOutputStream, "This is automatically generated file.");
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
            this.log.debug("meta-data saved to file " + file);
        }
        catch (IOException iOException) {
            this.log.warn("failed saving meta-data to file " + file, iOException);
        }
    }

    private void quickCheck() {
        Object object;
        File[] fileArray = this.shadowFolder.listFiles(new ShadowFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            object = fileArray[i];
            if (this.metaData.containsValue(((File)object).getName())) continue;
            if (ShadingUtil.deleteFile((File)object)) {
                this.log.debug("deleted shadow file " + object);
                continue;
            }
            this.log.warn("can't delete shadow file " + object);
        }
        HashSet hashSet = new HashSet();
        object = this.metaData.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string = (String)entry.getKey();
            if (!string.startsWith("uid:")) continue;
            hashSet.add(entry.getValue());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.quickCheck((String)object.next());
        }
    }

    private void quickCheck(String string) {
        this.log.debug("quick check of UID " + string);
        String string2 = this.metaData.getProperty("source:" + string, null);
        String string3 = this.metaData.getProperty("file:" + string, null);
        String string4 = this.metaData.getProperty("modified:" + string, null);
        if (string2 == null || string3 == null || string4 == null) {
            this.log.debug("meta-data incomplete, UID=" + string);
            this.remove(string);
            return;
        }
        try {
            if (!this.dtf.parse(string4).equals(ShadingUtil.getLastModified(ShadingUtil.buildURL(this.shadowFolderUrl, string2)))) {
                this.log.debug("source modification detected, UID=" + string + ", source=" + string2);
                this.remove(string);
            }
        }
        catch (IOException iOException) {
            this.log.warn("quick check failed", iOException);
            this.remove(string);
        }
        catch (ParseException parseException) {
            this.log.warn("quick check failed", parseException);
            this.remove(string);
        }
    }

    private void remove(String string) {
        String string2 = this.metaData.getProperty("file:" + string, null);
        if (string2 != null) {
            File file = new File(this.shadowFolder, string2);
            if (ShadingUtil.deleteFile(file)) {
                this.log.debug("deleted lost file " + string2);
            } else {
                this.log.warn("can't delete lost file " + string2);
            }
        }
        boolean bl = this.metaData.remove("uid:" + string) != null;
        bl |= this.metaData.remove("source:" + string) != null;
        bl |= this.metaData.remove("file:" + string) != null;
        if (bl |= this.metaData.remove("modified:" + string) != null) {
            this.log.debug("removed meta-data, UID=" + string);
        }
    }

    private URL add(String string, URL uRL, File file, Date date) throws IOException {
        URL uRL2 = IoUtil.file2url(file);
        this.metaData.setProperty("uid:" + string, string);
        String string2 = ShadingUtil.getRelativeUrl(this.shadowFolder, uRL);
        this.metaData.setProperty("source:" + string, string2);
        this.metaData.setProperty("file:" + string, file.getName());
        this.metaData.setProperty("modified:" + string, this.dtf.format(date));
        this.save();
        this.log.debug("shading done, UID=" + string + ", source=" + string2 + ", file=" + uRL2 + ", modified=" + this.dtf.format(date));
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL shadowResource(URL uRL, String string, boolean bl) {
        Object object;
        Serializable serializable;
        block37: {
            try {
                serializable = this.deepCheck(uRL, string);
                if (serializable != null) {
                    this.log.debug("got actual shaded resource, UID=" + string + ", source=" + uRL + ", file=" + serializable);
                    return serializable;
                }
            }
            catch (Exception exception) {
                this.log.warn("deep check failed, UID=" + string + ", URL=" + uRL, exception);
                this.remove(string);
            }
            try {
                serializable = ShadingUtil.getLastModified(uRL);
            }
            catch (IOException iOException) {
                this.log.error("shading failed, can't get modification date for " + uRL, iOException);
                return uRL;
            }
            File file = IoUtil.url2file(uRL);
            if (file != null && file.isDirectory()) {
                try {
                    File file2 = new File(this.shadowFolder, string);
                    IoUtil.copyFolder(file, file2, true, true);
                    return this.add(string, uRL, file2, (Date)serializable);
                }
                catch (IOException iOException) {
                    this.log.error("failed shading local folder " + file, iOException);
                    return uRL;
                }
            }
            try {
                object = uRL.openConnection();
                if (!(object instanceof JarURLConnection)) break block37;
                JarURLConnection jarURLConnection = (JarURLConnection)object;
                URL uRL2 = jarURLConnection.getJarFileURL();
                if (!bl) {
                    String string2 = ShadingUtil.getExtension(uRL2.getFile());
                    if (string2 == null) {
                        string2 = "jar";
                    }
                    File file3 = new File(this.shadowFolder, string + '.' + string2);
                    InputStream inputStream = uRL2.openStream();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file3, false);
                        try {
                            IoUtil.copyStream(inputStream, fileOutputStream, 1024);
                        }
                        finally {
                            ((OutputStream)fileOutputStream).close();
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    return this.add(string, uRL, file3, (Date)serializable);
                }
                JarFile jarFile = jarURLConnection.getJarFile();
                File file4 = new File(this.shadowFolder, string);
                try {
                    ShadingUtil.unpack(jarFile, file4);
                }
                finally {
                    jarFile.close();
                }
                return this.add(string, uRL, file4, (Date)serializable);
            }
            catch (IOException iOException) {
                this.log.error("failed shading URL connection " + uRL, iOException);
                return uRL;
            }
        }
        object = uRL.getFile();
        if (object == null) {
            this.log.warn("can't get file name from resource " + uRL + ", shading failed");
            return uRL;
        }
        String string3 = ShadingUtil.getExtension((String)object);
        if (string3 == null) {
            this.log.warn("can't get file name extension for resource " + uRL + ", shading failed");
            return uRL;
        }
        if (bl && ("jar".equalsIgnoreCase(string3) || "zip".equalsIgnoreCase(string3))) {
            try {
                InputStream inputStream = uRL.openStream();
                File file = new File(this.shadowFolder, string);
                try {
                    ShadingUtil.unpack(inputStream, file);
                }
                finally {
                    inputStream.close();
                }
                return this.add(string, uRL, file, (Date)serializable);
            }
            catch (IOException iOException) {
                this.log.error("failed shading packed resource " + uRL, iOException);
                return uRL;
            }
        }
        try {
            File file = new File(this.shadowFolder, string + '.' + string3);
            InputStream inputStream = uRL.openStream();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file, false);
                try {
                    IoUtil.copyStream(inputStream, fileOutputStream, 1024);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
            return this.add(string, uRL, file, (Date)serializable);
        }
        catch (IOException iOException) {
            this.log.error("failed shading resource file " + uRL, iOException);
            return uRL;
        }
    }

    private URL deepCheck(URL uRL, String string) throws Exception {
        String string2 = this.metaData.getProperty("source:" + string, null);
        if (string2 == null) {
            this.log.debug("URL not found in meta-data, UID=" + string);
            this.remove(string);
            return null;
        }
        this.log.debug("URL found in meta-data, UID=" + string + ", source=" + uRL + ", storedURL=" + string2);
        URL uRL2 = ShadingUtil.buildURL(this.shadowFolderUrl, string2);
        if (!uRL2.equals(uRL)) {
            this.log.debug("inconsistent URL found in meta-data, UID=" + string + ", source=" + uRL + ", storedSource=" + uRL2);
            this.remove(string);
            return null;
        }
        String string3 = this.metaData.getProperty("modified:" + string, null);
        if (string3 == null) {
            this.log.debug("modification info not found in meta-data, UID=" + string);
            this.remove(string);
            return null;
        }
        if (!ShadingUtil.getLastModified(uRL).equals(this.dtf.parse(string3))) {
            this.log.debug("source modification detected, UID=" + string + ", source=" + uRL);
            this.remove(string);
            return null;
        }
        String string4 = this.metaData.getProperty("file:" + string, null);
        if (string4 == null) {
            this.log.debug("file info not found in meta-data, UID=" + string);
            this.remove(string);
            return null;
        }
        File file = new File(this.shadowFolder, string4);
        if (!file.exists()) {
            this.log.debug("shadow file not found, UID=" + string + ", source=" + uRL + ", file=" + file);
            this.remove(string);
            return null;
        }
        File file2 = IoUtil.url2file(uRL);
        if (file2 != null && file2.isDirectory()) {
            IoUtil.synchronizeFolders(file2, file);
            this.log.debug("folders synchronized, UID=" + string + ", srcFile=" + file2 + ", destFile=" + file);
        } else {
            this.log.debug("source " + uRL + " (file is " + file2 + ") is not local folder, " + "skipping synchronization, UID=" + string);
        }
        return IoUtil.file2url(file);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ShadowFileFilter
    implements FileFilter {
        private ShadowFileFilter() {
        }

        public boolean accept(File file) {
            return !ShadowDataController.META_FILE_NAME.equals(file.getName());
        }
    }
}

