/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils.typedarrays;

import com.eclipsesource.v8.utils.typedarrays.ArrayBuffer;
import com.eclipsesource.v8.utils.typedarrays.TypedArray;
import java.nio.ByteBuffer;

public class UInt16Array
extends TypedArray {
    public UInt16Array(ByteBuffer buffer) {
        super(buffer);
    }

    public UInt16Array(ArrayBuffer arrayBuffer) {
        this(arrayBuffer.getByteBuffer());
    }

    public int get(int index) {
        return 0xFFFF & this.buffer.asShortBuffer().get(index);
    }

    @Override
    public int length() {
        return this.buffer.asShortBuffer().limit();
    }

    public void put(int index, int value) {
        this.buffer.asShortBuffer().put(index, (short)(0xFFFF & value));
    }

    @Override
    public int getType() {
        return 14;
    }
}

