/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.SortKeyRequired;
import pcgen.cdom.enumeration.StringKey;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractStringToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.PostValidationToken;
import pcgen.util.Logging;

public class SortKeyLst
extends AbstractStringToken<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
PostValidationToken<CDOMObject> {
    public String getTokenName() {
        return "SORTKEY";
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    protected StringKey stringKey() {
        return StringKey.SORT_KEY;
    }

    public boolean process(LoadContext context, Collection<? extends CDOMObject> allObjects) {
        List orderSort;
        if (allObjects.isEmpty()) {
            return true;
        }
        CDOMObject sample = allObjects.iterator().next();
        Class<?> cl = sample.getClass();
        boolean sortKeyRequired = sample instanceof SortKeyRequired;
        for (CDOMObject cDOMObject : allObjects) {
            String sortkey = cDOMObject.get(this.stringKey());
            if (sortkey != null || !sortKeyRequired) continue;
            Logging.deprecationPrint((String)("Objects of type " + cDOMObject.getClass().getName() + " will require a SORTKEY " + "in the next version of PCGen (6.7).  " + "Use without a SORTKEY is deprecated"), (LoadContext)context);
        }
        if (!sortKeyRequired) {
            return true;
        }
        AbstractReferenceContext refContext = context.getReferenceContext();
        ArrayList arrayList = new ArrayList(refContext.getSortOrderedList(cl));
        if (!arrayList.equals(orderSort = refContext.getOrderSortedCDOMObjects(cl))) {
            Logging.log((Level)Logging.LST_ERROR, (String)("For " + sample.getClass().getSimpleName() + ", the file order was: " + StringUtil.join(new ArrayList(orderSort), (String)", ") + " while the order based on SORTKEY was: " + StringUtil.join(arrayList, (String)", ") + ".  These lists must match."));
            return false;
        }
        return true;
    }

    public Class<CDOMObject> getValidationTokenClass() {
        return CDOMObject.class;
    }

    public int getPriority() {
        return 11;
    }
}

