/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.plugin.Combatant;
import gmgen.plugin.InitHolderList;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.CombatHasBeenInitiatedMessage;
import gmgen.pluginmgr.messages.FileMenuSaveMessage;
import gmgen.pluginmgr.messages.RequestAddPreferencesPanelMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.Utility;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import plugin.experience.ExperienceAdjusterModel;
import plugin.experience.ExperienceListItem;
import plugin.experience.gui.AddDefeatedCombatant;
import plugin.experience.gui.ExperienceAdjusterView;
import plugin.experience.gui.PreferencesExperiencePanel;

public class ExperienceAdjusterPlugin
implements InteractivePlugin,
ActionListener,
ChangeListener,
KeyListener {
    public static final String LOG_NAME = "Experience_Adjuster";
    protected ExperienceAdjusterModel eaModel;
    protected ExperienceAdjusterView eaView;
    protected InitHolderList initList;
    protected JMenuItem experienceToolsItem = new JMenuItem();
    private static final String NAME = "Experience";
    private static final String IN_NAME = "in_plugin_experience_name";
    private static final String IN_NAME_MN = "in_mn_plugin_experience_name";
    protected String version = "01.00.99.01.00";
    private PCGenMessageHandler messageHandler;

    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.eaModel = new ExperienceAdjusterModel(this.getDataDirectory());
        this.eaView = new ExperienceAdjusterView(this.eaModel);
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddPreferencesPanelMessage((Object)this, this.getLocalizedName(), (PreferencesPanel)new PreferencesExperiencePanel()));
        this.initListeners();
        this.update();
        this.messageHandler.handleMessage((PCGenMessage)new RequestAddTabToGMGenMessage((Object)this, this.getLocalizedName(), (Component)this.getView()));
        this.initMenus();
    }

    public void stop() {
        this.messageHandler = null;
    }

    public int getPriority() {
        return SettingsHandler.getGMGenOption((String)"Experience_Adjuster.LoadOrder", (int)50);
    }

    public ExperienceAdjusterModel getModel() {
        return this.eaModel;
    }

    public String getPluginName() {
        return NAME;
    }

    private String getLocalizedName() {
        return LanguageBundle.getString((String)IN_NAME);
    }

    public JPanel getView() {
        return this.eaView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.eaView.getAddExperienceToCharButton()) {
            this.handleAddExperienceToCharButton();
        }
        if (e.getSource() == this.eaView.getAddExperienceToPartyButton()) {
            this.handleAddExperienceToPartyButton();
        }
        if (e.getSource() == this.eaView.getAddEnemyButton()) {
            this.handleAddEnemyButton();
        }
        if (e.getSource() == this.eaView.getRemoveEnemyButton()) {
            this.handleRemoveEnemyButton();
        }
        if (e.getSource() == this.eaView.getAdjustCRButton()) {
            this.handleAdjustCRButton();
        }
    }

    public void adjustCR(Combatant cbt) {
        String inputValue = JOptionPane.showInputDialog((Component)GMGenSystem.inst, "CR", Float.toString(cbt.getCR()));
        if (inputValue != null) {
            try {
                cbt.setCR(Float.parseFloat(inputValue));
            }
            catch (NumberFormatException e) {
                Logging.errorPrint((String)"Value could not be parsed into a number.");
                this.adjustCR(cbt);
            }
        }
    }

    public void handleAddEnemyButton() {
        AddDefeatedCombatant dialog = new AddDefeatedCombatant((Frame)GMGenSystem.inst, true, this.eaModel);
        dialog.setVisible(true);
        this.handleGroupBox();
        this.update();
        this.eaView.getEnemyList().updateUI();
    }

    public void handleAddExperienceToCharButton() {
        if (this.eaView.getCharacterList().getSelectedIndex() != -1) {
            try {
                Object[] list = this.eaView.getCharacterList().getSelectedValues();
                for (int i = 0; i < list.length; ++i) {
                    this.eaModel.addExperienceToCharacter((ExperienceListItem)list[i], Integer.parseInt(this.eaView.getExperienceField().getText()));
                }
            }
            catch (NumberFormatException e) {
                this.eaView.setExperienceToAdd("");
            }
        }
        this.eaView.getCharacterList().updateUI();
        this.eaView.getExperienceField().setText("0");
    }

    public void handleAddExperienceToPartyButton() {
        this.eaModel.addExperienceToParty();
        this.eaView.getCharacterList().updateUI();
        this.eaModel.clearEnemies();
        this.handleGroupBox();
    }

    public void handleAdjustCRButton() {
        Combatant cbt;
        ExperienceListItem item;
        int i;
        Object[] list;
        if (this.eaView.getCharacterList().getSelectedIndex() != -1) {
            list = this.eaView.getCharacterList().getSelectedValues();
            for (i = 0; i < list.length; ++i) {
                item = (ExperienceListItem)list[i];
                cbt = item.getCombatant();
                this.adjustCR(cbt);
            }
        }
        if (this.eaView.getEnemyList().getSelectedIndex() != -1) {
            list = this.eaView.getEnemyList().getSelectedValues();
            for (i = 0; i < list.length; ++i) {
                item = (ExperienceListItem)list[i];
                cbt = item.getCombatant();
                this.adjustCR(cbt);
            }
        }
        this.update();
    }

    public void handleExportButton() {
    }

    public void handleGroupBox() {
        this.eaModel.updatePartyExperience();
        this.eaView.setExperienceFromCombat(this.eaModel.getPartyExperience());
    }

    public void handleMultiplierSlider() {
        this.handleGroupBox();
    }

    public void handleRemoveEnemyButton() {
        if (this.eaView.getEnemyList().getSelectedIndex() != -1) {
            Object[] list = this.eaView.getEnemyList().getSelectedValues();
            for (int i = 0; i < list.length; ++i) {
                this.eaModel.removeEnemy((ExperienceListItem)list[i]);
            }
        }
        this.handleGroupBox();
        this.update();
        this.eaView.getEnemyList().updateUI();
    }

    public final void initListeners() {
        this.eaView.getAddExperienceToCharButton().addActionListener(this);
        this.eaView.getAddExperienceToPartyButton().addActionListener(this);
        this.eaView.getAdjustCRButton().addActionListener(this);
        this.eaView.getAddEnemyButton().addActionListener(this);
        this.eaView.getRemoveEnemyButton().addActionListener(this);
        this.eaView.getExperienceMultSlider().addChangeListener(this);
    }

    public void setModel(ExperienceAdjusterModel eaModel) {
        this.eaModel = eaModel;
    }

    public void setView(ExperienceAdjusterView eaView) {
        this.eaView = eaView;
    }

    public void initMenus() {
        this.experienceToolsItem.setMnemonic(LanguageBundle.getMnemonic((String)IN_NAME_MN));
        this.experienceToolsItem.setText(this.getLocalizedName());
        this.experienceToolsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExperienceAdjusterPlugin.this.toolMenuItem(evt);
            }
        });
        this.messageHandler.handleMessage((PCGenMessage)new AddMenuItemToGMGenToolsMenuMessage((Object)this, this.experienceToolsItem));
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.update();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.eaView.getExperienceMultSlider()) {
            this.handleMultiplierSlider();
        }
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!(tp.getComponentAt(i) instanceof ExperienceAdjusterView)) continue;
            tp.setSelectedIndex(i);
        }
    }

    public final void update() {
        this.eaModel.populateLists();
        this.eaView.setParty(this.eaModel.getParty());
        this.eaView.setEnemies(this.eaModel.getEnemies());
        this.handleGroupBox();
    }

    public void handleMessage(PCGenMessage message) {
        if (message instanceof CombatHasBeenInitiatedMessage) {
            if (message.getSource() == this) {
                CombatHasBeenInitiatedMessage cmessage = (CombatHasBeenInitiatedMessage)message;
                if (this.initList == null) {
                    this.initList = cmessage.getCombat();
                }
                this.eaModel.setCombat(this.initList);
            }
            this.update();
        } else if (message instanceof FocusOrStateChangeOccurredMessage) {
            if (this.isActive()) {
                this.experienceToolsItem.setEnabled(false);
                if (this.initList == null) {
                    this.messageHandler.handleMessage((PCGenMessage)new CombatHasBeenInitiatedMessage((Object)this));
                }
                this.update();
            } else {
                this.experienceToolsItem.setEnabled(true);
            }
        } else if (message instanceof FileMenuSaveMessage && this.isActive()) {
            this.handleExportButton();
        }
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor((Component)this.eaView);
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.eaView);
    }

    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }
}

