/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.GMGenSystem;
import gmgen.gui.ExtendedHTMLDocument;
import gmgen.gui.ExtendedHTMLEditorKit;
import gmgen.util.MiscUtilities;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import pcgen.cdom.base.Constants;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class NotesTreeNode
implements MutableTreeNode,
DocumentListener {
    private static final String DOCROOT = "docroot";
    private static final String DATA_HTML = "data.html";
    private static final String CVS_DIR = "CVS";
    public static final Enumeration<MutableTreeNode> EMPTY_ENUMERATION = new Enumeration<MutableTreeNode>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public MutableTreeNode nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    protected ExtendedHTMLDocument notesDoc;
    protected File dir;
    protected JTextPane pane;
    protected JTree tree;
    protected MutableTreeNode parent;
    protected transient Object userObject;
    protected Vector<MutableTreeNode> children;
    protected boolean allowsChildren = true;
    protected boolean dirty = false;
    protected boolean hasBeenPopulated = false;
    protected boolean ignoreUpdateSemaphore = false;
    protected int cacheCounter = 0;

    public NotesTreeNode(String name, File dir, JTree tree) {
        this.userObject = name;
        this.tree = tree;
        this.dir = dir;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return this.children.elementAt(index);
    }

    @Override
    public int getChildCount() {
        File[] kids;
        int counter = 0;
        if (this.children != null) {
            counter = this.children.size();
        }
        if (!this.hasBeenPopulated && (kids = this.dir.listFiles()) != null) {
            for (int i = 0; i < kids.length; ++i) {
                if (!this.include(kids[i])) continue;
                ++counter;
            }
        }
        return counter;
    }

    public File getDir() {
        return this.dir;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEmpty() {
        File[] aChildren = this.dir.listFiles();
        return aChildren.length <= 0 && !this.dirty;
    }

    public List<File> getFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (File child : this.dir.listFiles()) {
            if (child.isDirectory() || child.getName().equals(DATA_HTML)) continue;
            list.add(child);
        }
        return list;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if (!this.isNodeChild(node)) {
            return -1;
        }
        return this.children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isNodeAncestor(TreeNode node) {
        if (node == null) {
            return false;
        }
        TreeNode ancestor = this;
        do {
            if (ancestor != node) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean isNodeChild(TreeNode node) {
        boolean retval = node == null ? false : (this.getChildCount() == 0 ? false : node.getParent() == this);
        return retval;
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public JTextPane getTextPane(JTextPane editor) {
        boolean repopulate = false;
        this.cacheCounter = 10;
        if (this.notesDoc != null) {
            this.ignoreUpdateSemaphore = true;
        }
        if (this.pane == null) {
            this.pane = editor;
            repopulate = true;
            ExtendedHTMLEditorKit htmlKit = new ExtendedHTMLEditorKit();
            this.pane.setEditorKit((EditorKit)htmlKit);
            this.notesDoc = (ExtendedHTMLDocument)htmlKit.createDefaultDocument();
            this.notesDoc.putProperty((Object)DOCROOT, (Object)(this.dir.getAbsolutePath() + File.separator + DATA_HTML));
        }
        this.pane.setDocument((Document)this.notesDoc);
        if (repopulate) {
            File notes = new File(this.dir.getAbsolutePath() + File.separator + DATA_HTML);
            if (notes.exists()) {
                try {
                    String newLine;
                    BufferedReader br = new BufferedReader(new FileReader(notes));
                    StringBuilder sb = new StringBuilder();
                    do {
                        if ((newLine = br.readLine()) == null) continue;
                        sb.append(newLine).append(Constants.LINE_SEPARATOR);
                    } while (newLine != null);
                    br.close();
                    this.pane.setText(sb.toString());
                }
                catch (Exception e) {
                    Logging.errorPrint((String)e.getMessage(), (Throwable)e);
                }
            }
            this.notesDoc.addDocumentListener((DocumentListener)this);
        }
        return this.pane;
    }

    public JTextPane getTextPane() {
        boolean repopulate = false;
        this.cacheCounter = 10;
        if (this.pane == null) {
            this.pane = new JTextPane();
            repopulate = true;
            ExtendedHTMLEditorKit htmlKit = new ExtendedHTMLEditorKit();
            this.pane.setEditorKit((EditorKit)htmlKit);
            this.notesDoc = (ExtendedHTMLDocument)htmlKit.createDefaultDocument();
            this.notesDoc.putProperty((Object)DOCROOT, (Object)(this.dir.getAbsolutePath() + File.separator + DATA_HTML));
        }
        this.pane.setDocument((Document)this.notesDoc);
        if (repopulate) {
            File notes = new File(this.dir.getAbsolutePath() + File.separator + DATA_HTML);
            if (notes.exists()) {
                try {
                    String newLine;
                    BufferedReader br = new BufferedReader(new FileReader(notes));
                    StringBuilder sb = new StringBuilder();
                    do {
                        if ((newLine = br.readLine()) == null) continue;
                        sb.append(newLine).append(Constants.LINE_SEPARATOR);
                    } while (newLine != null);
                    br.close();
                    this.pane.setText(sb.toString());
                }
                catch (Exception e) {
                    Logging.errorPrint((String)e.getMessage(), (Throwable)e);
                }
            }
            this.pane.setCaretPosition(0);
            this.notesDoc.addDocumentListener((DocumentListener)this);
        }
        return this.pane;
    }

    public boolean isTreeDirty() {
        if (this.dirty) {
            return true;
        }
        if (this.hasBeenPopulated) {
            Enumeration<MutableTreeNode> newNodes = this.children();
            while (newNodes.hasMoreElements()) {
                NotesTreeNode node = (NotesTreeNode)newNodes.nextElement();
                if (!node.isTreeDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void add(MutableTreeNode node) {
        if (node != null && node.getParent() == this) {
            this.insert(node, this.getChildCount() - 1);
        } else {
            this.insert(node, this.getChildCount());
        }
    }

    public void appendText(String text) {
        try {
            if (this.notesDoc == null) {
                this.getTextPane();
            }
            this.notesDoc.insertAfterEnd(this.notesDoc.getCharacterElement(this.notesDoc.getLength()), text);
        }
        catch (Exception e) {
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.ignoreUpdateSemaphore) {
            this.ignoreUpdateSemaphore = false;
        } else {
            this.dirty = true;
            this.tree.updateUI();
        }
    }

    public void checkCache() {
        if (!this.dirty && this.pane != null) {
            if (this.cacheCounter > 0) {
                --this.cacheCounter;
            } else {
                this.revert();
            }
        }
        if (this.hasBeenPopulated) {
            Enumeration<MutableTreeNode> newNodes = this.children();
            while (newNodes.hasMoreElements()) {
                NotesTreeNode node = (NotesTreeNode)newNodes.nextElement();
                node.checkCache();
            }
        }
    }

    public static String checkName(String name) {
        String returnName = name.replaceAll("\\:", "-");
        returnName = returnName.replaceAll("\\;", "-");
        returnName = returnName.replaceAll("\\+", "-");
        returnName = returnName.replaceAll("\\=", "-");
        returnName = returnName.replaceAll("\\|", "-");
        returnName = returnName.replaceAll("\\?", "-");
        returnName = returnName.replaceAll("\\*", "-");
        return returnName;
    }

    public void checkSave() {
        if (((String)this.userObject).equals("Logs")) {
            int choice;
            if (this.isTreeDirty() && (choice = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "You have unsaved Logs.  Save?", "Save", 0)) == 0) {
                this.save();
                this.saveChildren();
            }
            this.trimEmpty();
        } else {
            int choice;
            if (this.dirty && (choice = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "Note '" + this.getUserObject() + "' changed.  Save?", "Save", 0)) == 0) {
                this.save();
            }
            if (this.hasBeenPopulated) {
                Enumeration<MutableTreeNode> newNodes = this.children();
                while (newNodes.hasMoreElements()) {
                    NotesTreeNode node = (NotesTreeNode)newNodes.nextElement();
                    node.checkSave();
                }
            }
        }
    }

    public Enumeration<MutableTreeNode> children() {
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public NotesTreeNode createChild(String newName) {
        boolean notDone = true;
        newName = NotesTreeNode.checkName(newName);
        int num = 1;
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        while (notDone) {
            File newDir;
            String baseName = newName;
            if (num > 1) {
                baseName = baseName + num;
            }
            if (!(newDir = new File(this.dir.getAbsolutePath() + File.separator + baseName)).exists()) {
                try {
                    newDir.mkdir();
                    notDone = false;
                    NotesTreeNode newNode = new NotesTreeNode(baseName, newDir, this.tree);
                    this.add(newNode);
                    return newNode;
                }
                catch (Exception e) {
                    Logging.errorPrint((String)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            ++num;
        }
        return null;
    }

    public NotesTreeNode createChild() {
        return this.createChild(LanguageBundle.getString((String)"in_plugin_notes_newNote"));
    }

    public void delete() {
        int choice;
        if (!this.isEmpty() && (choice = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "Node " + this.dir.getName() + " Contains Content.  Delete?", "Node Populated", 0, 3)) != 0) {
            return;
        }
        try {
            boolean test;
            for (File child : this.dir.listFiles()) {
                boolean test2 = child.delete();
                if (test2) continue;
                JOptionPane.showMessageDialog(null, "Cannot delete file " + child.getName());
                break;
            }
            if (test = this.dir.delete()) {
                this.removeFromParent();
            } else {
                JOptionPane.showMessageDialog(null, "Cannot delete directory " + this.dir.getName());
            }
        }
        catch (Exception e) {
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean handleDropJavaFileList(DropTargetDropEvent dtde) {
        dtde.acceptDrop(dtde.getDropAction());
        Transferable t = dtde.getTransferable();
        try {
            List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            for (int i = 0; i < fileList.size(); ++i) {
                File newFile = (File)fileList.get(i);
                if (!newFile.exists()) continue;
                MiscUtilities.copy((File)newFile, (File)new File(this.dir.getAbsolutePath() + File.separator + newFile.getName()));
            }
        }
        catch (Exception e) {
            Logging.errorPrint((String)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        MutableTreeNode oldParent;
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (child == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(child)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if ((oldParent = (MutableTreeNode)child.getParent()) != null) {
            oldParent.remove(child);
        }
        child.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(child, index);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.dirty = true;
        this.tree.updateUI();
    }

    public void refresh() {
        if (this.hasBeenPopulated) {
            Enumeration<MutableTreeNode> childNodes = this.children();
            List<File> childDirs = Arrays.asList(this.dir.listFiles());
            ArrayList<File> removeDirs = new ArrayList<File>();
            while (childNodes.hasMoreElements()) {
                NotesTreeNode node = (NotesTreeNode)childNodes.nextElement();
                File nodeDir = node.getDir();
                if (nodeDir.exists()) {
                    for (int i = 0; i < childDirs.size(); ++i) {
                        File childDir = childDirs.get(i);
                        if (!nodeDir.getName().equals(childDir.getName())) continue;
                        removeDirs.add(childDir);
                    }
                    continue;
                }
                this.remove(node);
            }
            for (File childDir : childDirs) {
                if (removeDirs.contains(childDir) || !this.include(childDir)) continue;
                this.add(new NotesTreeNode(childDir.getName(), childDir, this.tree));
            }
            Enumeration<MutableTreeNode> newNodes = this.children();
            while (newNodes.hasMoreElements()) {
                NotesTreeNode node = (NotesTreeNode)newNodes.nextElement();
                node.refresh();
            }
        }
    }

    private boolean include(File f) {
        return f.isDirectory() && !f.getName().equals(CVS_DIR) && !f.isHidden();
    }

    public void rehome(String path) {
        this.dir = new File(path + File.separator + this.dir.getName());
        this.rehomeChildren(this.dir.getAbsolutePath());
        this.notesDoc.putProperty((Object)DOCROOT, (Object)(this.dir.getAbsolutePath() + File.separator + DATA_HTML));
    }

    public void rehomeChildren(String path) {
        if (this.hasBeenPopulated) {
            Enumeration<MutableTreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                NotesTreeNode node = (NotesTreeNode)childNodes.nextElement();
                node.rehome(path);
            }
        }
    }

    @Override
    public void remove(int index) {
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(index);
        this.children.removeElementAt(index);
        child.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(node)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        this.remove(this.getIndex(node));
    }

    public void removeAllChildren() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    @Override
    public void removeFromParent() {
        MutableTreeNode aParent = (MutableTreeNode)this.getParent();
        if (aParent != null) {
            aParent.remove(this);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.dirty = true;
        this.tree.updateUI();
    }

    public void rename(String newName) {
        String path = this.dir.getParent();
        if (this.dir.exists()) {
            String oldPath = this.dir.getAbsolutePath();
            String oldName = this.dir.getName();
            boolean tryrename = this.dir.renameTo(new File(path + File.separator + newName));
            if (!tryrename) {
                this.dir = new File(oldPath);
                this.setUserObject(oldName);
            } else {
                this.dir = new File(path + File.separator + newName);
                this.rehomeChildren(this.dir.getAbsolutePath());
            }
        } else {
            this.dir = new File(path + File.separator + newName);
            this.dir.mkdirs();
        }
    }

    public void revert() {
        int choice;
        if (this.dirty && (choice = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "Note '" + this.getUserObject() + "' has been altered, are you sure you wish to revert to the saved copy?", "Revert?", 0)) == 1) {
            return;
        }
        this.dirty = false;
        this.pane = null;
        this.notesDoc.removeDocumentListener((DocumentListener)this);
        this.notesDoc = null;
    }

    public void save() {
        if (this.dirty) {
            try {
                File notes = new File(this.dir.getAbsolutePath() + File.separator + DATA_HTML);
                if (!notes.exists()) {
                    notes.createNewFile();
                }
                if (this.pane != null) {
                    FileWriter fw = new FileWriter(notes);
                    HTMLWriter hw = new HTMLWriter((Writer)fw, (HTMLDocument)this.notesDoc);
                    hw.write();
                    fw.flush();
                    fw.close();
                    this.dirty = false;
                }
            }
            catch (Exception e) {
                Logging.errorPrint((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void saveChildren() {
        Enumeration<MutableTreeNode> newNodes = this.children();
        while (newNodes.hasMoreElements()) {
            NotesTreeNode node = (NotesTreeNode)newNodes.nextElement();
            node.save();
            node.saveChildren();
        }
    }

    public String toString() {
        if (this.dirty) {
            return "*" + this.getUserObject().toString();
        }
        return this.getUserObject().toString();
    }

    private void populate() {
        this.hasBeenPopulated = true;
        for (File child : this.dir.listFiles()) {
            if (!this.include(child)) continue;
            this.add(new NotesTreeNode(child.getName(), child, this.tree));
        }
    }

    private void trimEmpty() {
        Enumeration<MutableTreeNode> newNodes = this.children();
        while (newNodes.hasMoreElements()) {
            NotesTreeNode node = (NotesTreeNode)newNodes.nextElement();
            node.trimEmpty();
            if (!node.isEmpty()) continue;
            node.delete();
        }
    }
}

