/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.migrate;

import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import pcgen.core.system.MigrationRule;
import pcgen.persistence.lst.MigrationLstToken;
import pcgen.util.Logging;

public class NewCategoryToken
implements MigrationLstToken {
    private Pattern invalidKeyPattern = Pattern.compile(".*[,|\\||\\\\|:|;|\\.|%|\\*|=|\\[|\\]].*");

    public String getTokenName() {
        return "NEWCATEGORY";
    }

    public boolean parse(MigrationRule migrationRule, String value, String gameModeName) {
        if (StringUtils.isBlank((String)value)) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Invalid empty " + this.getTokenName() + " value."));
            return false;
        }
        if (this.invalidKeyPattern.matcher(value).matches()) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Invalid characters in value '" + value + "' of " + this.getTokenName() + ":" + value));
            return false;
        }
        migrationRule.setNewCategory(value);
        return true;
    }
}

