/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.levelability;

import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitLevelAbility;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;

public class LevelAbilityToken
extends AbstractNonEmptyToken<KitLevelAbility>
implements CDOMPrimaryToken<KitLevelAbility>,
DeferredToken<Kit> {
    @Override
    public String getTokenName() {
        return "LEVELABILITY";
    }

    @Override
    public Class<KitLevelAbility> getTokenClass() {
        return KitLevelAbility.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, KitLevelAbility kitLA, String value) {
        int equalLoc = value.indexOf(61);
        if (equalLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " requires an =: " + value, context);
        }
        if (equalLoc != value.lastIndexOf(61)) {
            return new ParseResult.Fail(this.getTokenName() + " requires a single =: " + value, context);
        }
        String className = value.substring(0, equalLoc);
        if (className.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " requires a class name before =: " + value, context);
        }
        String level = value.substring(equalLoc + 1);
        CDOMSingleRef<PCClass> cl = context.getReferenceContext().getCDOMReference(PCClass.class, className);
        try {
            Integer lvl = Integer.valueOf(level);
            if (lvl <= 0) {
                return new ParseResult.Fail(this.getTokenName() + " expected an integer > 0");
            }
            kitLA.setLevel(lvl);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
        kitLA.setClass(cl);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitLevelAbility kitLA) {
        CDOMSingleRef<PCClass> cl = kitLA.getPCClass();
        if (cl == null) {
            return null;
        }
        Integer lvl = kitLA.getLevel();
        return new String[]{cl.getLSTformat(false) + '=' + lvl};
    }

    @Override
    public Class<Kit> getDeferredTokenClass() {
        return Kit.class;
    }

    @Override
    public boolean process(LoadContext context, Kit obj) {
        for (BaseKit bk : obj.getSafeListFor(ListKey.KIT_TASKS)) {
            if (!(bk instanceof KitLevelAbility)) continue;
            obj.setDoLevelAbilities(false);
        }
        return true;
    }
}

