/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.abilitycategory;

import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.AbilityCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class CategoryToken
implements CDOMPrimaryToken<AbilityCategory>,
DeferredToken<AbilityCategory> {
    @Override
    public String getTokenName() {
        return "CATEGORY";
    }

    @Override
    public ParseResult parseToken(LoadContext context, AbilityCategory ac, String value) {
        CDOMSingleRef<AbilityCategory> cat = context.getReferenceContext().getCDOMReference(AbilityCategory.class, value);
        ac.setAbilityCategory(cat);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, AbilityCategory ac) {
        CDOMSingleRef<AbilityCategory> cat = ac.getAbilityCatRef();
        if (cat == null) {
            return null;
        }
        return new String[]{cat.getLSTformat(false)};
    }

    @Override
    public Class<AbilityCategory> getTokenClass() {
        return AbilityCategory.class;
    }

    @Override
    public Class<AbilityCategory> getDeferredTokenClass() {
        return AbilityCategory.class;
    }

    @Override
    public boolean process(LoadContext context, AbilityCategory ac) {
        CDOMSingleRef<AbilityCategory> parent = ac.getAbilityCatRef();
        if (parent == null) {
            Logging.log(Logging.LST_ERROR, "All Ability Categories must have a CATEGORY token. " + ac.getKeyName() + " of " + context.getSourceURI() + " did not");
            return false;
        }
        String parentCat = parent.getLSTformat(false);
        if (!ac.getTypes().isEmpty() && parentCat.equalsIgnoreCase(ac.getKeyName())) {
            Logging.log(Logging.LST_ERROR, "TYPE " + ac.getTypes() + " is not valid in 'parent' category " + ac.getKeyName() + " of " + context.getSourceURI() + ".");
            return false;
        }
        if (ac.isAllAbilityTypes() && parentCat.equalsIgnoreCase(ac.getKeyName())) {
            Logging.log(Logging.LST_ERROR, "TYPE '*' is not valid in 'parent' category " + ac.getKeyName() + " of " + context.getSourceURI() + ".");
            return false;
        }
        if (ac.hasDirectReferences() && parentCat.equalsIgnoreCase(ac.getKeyName())) {
            Logging.log(Logging.LST_ERROR, "ABILITYLIST is not valid in 'parent' category " + ac.getKeyName() + " of " + context.getSourceURI() + ".");
            return false;
        }
        if (ac.getTypes().isEmpty() && !ac.hasDirectReferences() && !ac.isAllAbilityTypes() && !parentCat.equalsIgnoreCase(ac.getKeyName())) {
            Logging.log(Logging.LST_ERROR, "Ability Category " + ac.getKeyName() + " had no TYPE or ABILITYLIST, " + "but has a different CATEGORY.  File was: " + context.getSourceURI());
            return false;
        }
        return true;
    }
}

