/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.cdom.helper.SkillSituation;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.analysis.QualifiedName;
import pcgen.core.analysis.SkillInfoUtilities;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.display.SkillCostDisplay;
import pcgen.core.display.SkillDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SkillToken;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;

public class SkillSitToken
extends Token {
    public static final String TOKENNAME = "SKILLSIT";
    private List<Skill> cachedSkillList = null;
    private PlayerCharacter lastPC = null;
    private int lastPCSerial;

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        SkillToken.SkillDetails details = SkillToken.buildSkillDetails(tokenSource);
        Object aSkill = this.getSkill(pc, details, eh);
        return this.getSkillProperty(aSkill, details.getProperty(0), pc);
    }

    private Object getSkill(PlayerCharacter pc, SkillToken.SkillDetails details, ExportHandler eh) {
        Skill skill = null;
        try {
            Skill sk;
            int i = Integer.parseInt(details.getSkillId());
            ArrayList<Skill> pcSkills = new ArrayList<Skill>(this.getSkillList(pc));
            SkillFilter filter = details.getSkillFilter();
            if (filter == null || filter == SkillFilter.Selected) {
                filter = pc.getSkillFilter();
            }
            Iterator iter = pcSkills.iterator();
            while (iter.hasNext()) {
                sk = (Skill)iter.next();
                if (pc.includeSkill(sk, filter) && sk.qualifies(pc, null)) continue;
                iter.remove();
            }
            if (i >= pcSkills.size() - 1 && eh != null && eh.getExistsOnly()) {
                eh.setNoMoreItems(true);
            }
            iter = pcSkills.iterator();
            while (i >= 0) {
                sk = (Skill)iter.next();
                if (i == 0) {
                    return sk;
                }
                --i;
                ArrayList<String> situations = new ArrayList<String>(sk.getUniqueListFor(ListKey.SITUATION));
                if (situations == null) continue;
                int numSits = situations.size();
                if (i < numSits) {
                    Collections.sort(situations);
                }
                for (String situation : situations) {
                    double bonus = pc.getTotalBonusTo("SITUATION", sk.getKeyName() + "=" + situation);
                    if (!(bonus > 0.01) && !(bonus < -0.01)) continue;
                    if (i == 0) {
                        return new SkillSituation(sk, situation, bonus);
                    }
                    --i;
                }
            }
        }
        catch (NumberFormatException exc) {
            String skillName = details.getSkillId();
            int equalLoc = skillName.indexOf("=");
            if (equalLoc == -1) {
                skill = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, skillName);
            }
            String situation = skillName.substring(equalLoc + 1);
            Skill sk = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Skill.class, skillName.substring(0, equalLoc));
            double bonus = pc.getTotalBonusTo("SITUATION", sk.getKeyName() + "=" + situation);
            return new SkillSituation(sk, situation, bonus);
        }
        return skill;
    }

    private synchronized List<Skill> getSkillList(PlayerCharacter pc) {
        if (pc == this.lastPC && pc.getSerial() == this.lastPCSerial) {
            return this.cachedSkillList;
        }
        List<Skill> pcSkills = SkillDisplay.getSkillListInOutputOrder(pc, pc.getDisplay().getPartialSkillList(View.VISIBLE_EXPORT));
        this.cachedSkillList = pcSkills;
        this.lastPC = pc;
        this.lastPCSerial = pc.getSerial();
        return pcSkills;
    }

    protected String getSkillProperty(Object aSkill, String property, PlayerCharacter pc) {
        if (aSkill == null) {
            return "";
        }
        int action = SkillToken.getPropertyId(property);
        return this.getSkillPropValue(aSkill, action, property, pc);
    }

    private String getSkillPropValue(Object skillSit, int property, String propertyText, PlayerCharacter pc) {
        String situation;
        boolean isSituation;
        Skill skill;
        SkillSituation sit;
        StringBuilder retValue = new StringBuilder();
        if (property == 5 || property == 6) {
            // empty if block
        }
        if (skillSit instanceof Skill) {
            sit = null;
            skill = (Skill)skillSit;
            isSituation = false;
            situation = "";
        } else if (skillSit instanceof SkillSituation) {
            sit = (SkillSituation)skillSit;
            skill = sit.getSkill();
            isSituation = true;
            situation = sit.getSituation();
        } else {
            Logging.errorPrint("Internal Error: unexpected type: " + skillSit.getClass());
            return "";
        }
        switch (property) {
            case 0: {
                String name = QualifiedName.qualifiedName(pc, skill);
                if (isSituation) {
                    name = name + " (" + situation + ")";
                }
                retValue.append(name);
                break;
            }
            case 1: {
                int rank = SkillRankControl.getTotalRank(pc, skill).intValue() + SkillModifier.modifier(skill, pc);
                if (isSituation) {
                    rank = (int)((double)rank + sit.getSituationBonus());
                }
                if (SettingsHandler.getGame().hasSkillRankDisplayText()) {
                    retValue.append(SettingsHandler.getGame().getSkillRankDisplayText(rank));
                    break;
                }
                retValue.append(Integer.toString(rank));
                break;
            }
            case 2: {
                Float sRank = SkillRankControl.getTotalRank(pc, skill);
                if (SettingsHandler.getGame().hasSkillRankDisplayText()) {
                    retValue.append(SettingsHandler.getGame().getSkillRankDisplayText(sRank.intValue()));
                    break;
                }
                retValue.append(SkillRankControl.getTotalRank(pc, skill).toString());
                break;
            }
            case 3: {
                int mod = SkillModifier.modifier(skill, pc);
                if (isSituation) {
                    mod = (int)((double)mod + sit.getSituationBonus());
                }
                retValue.append(Integer.toString(mod));
                break;
            }
            case 4: {
                retValue.append(SkillInfoUtilities.getKeyStatFromStats(pc, skill));
                break;
            }
            case 5: {
                retValue.append(Integer.toString(SkillModifier.getStatMod(skill, pc)));
                break;
            }
            case 6: {
                int misc = SkillModifier.modifier(skill, pc);
                if (isSituation) {
                    misc = (int)((double)misc + sit.getSituationBonus());
                }
                retValue.append(Integer.toString(misc -= SkillModifier.getStatMod(skill, pc)));
                break;
            }
            case 7: {
                retValue.append(skill.getSafe(ObjectKey.USE_UNTRAINED) != false ? "Y" : "NO");
                break;
            }
            case 8: {
                retValue.append(skill.getSafe(ObjectKey.EXCLUSIVE) != false ? "Y" : "N");
                break;
            }
            case 9: {
                retValue.append(SkillToken.getUntrainedOutput(skill, propertyText));
                break;
            }
            case 10: {
                retValue.append(SkillToken.getAcpOutput(skill, propertyText));
                break;
            }
            case 15: {
                Enum cost = null;
                for (PCClass pcc : pc.getDisplay().getClassSet()) {
                    if (cost == null) {
                        cost = pc.getSkillCostForClass(skill, pcc);
                    } else {
                        SkillCost newCost = pc.getSkillCostForClass(skill, pcc);
                        if (SkillCost.CLASS.equals((Object)newCost) || SkillCost.EXCLUSIVE.equals(cost)) {
                            cost = newCost;
                        }
                    }
                    if (!SkillCost.CLASS.equals(cost)) continue;
                    break;
                }
                retValue.append(cost.toString());
                break;
            }
            case 11: {
                boolean b;
                int etRank = SkillRankControl.getTotalRank(pc, skill).intValue();
                boolean bl = b = (skill.getSafe(ObjectKey.EXCLUSIVE) != false || skill.getSafe(ObjectKey.USE_UNTRAINED) == false) && etRank == 0;
                if (b) {
                    retValue.append("0");
                    break;
                }
                int mRank = etRank + SkillModifier.modifier(skill, pc);
                if (isSituation) {
                    mRank = (int)((double)mRank + sit.getSituationBonus());
                }
                retValue.append(Integer.toString(mRank));
                break;
            }
            case 12: {
                boolean isNotTrained;
                int tRank = SkillRankControl.getTotalRank(pc, skill).intValue();
                boolean bl = isNotTrained = skill.getSafe(ObjectKey.USE_UNTRAINED) == false && tRank == 0;
                if (isNotTrained) {
                    retValue.append("0");
                    break;
                }
                int mRank = tRank + SkillModifier.modifier(skill, pc);
                if (isSituation) {
                    mRank = (int)((double)mRank + sit.getSituationBonus());
                }
                retValue.append(Integer.toString(mRank));
                break;
            }
            case 13: {
                boolean shortFrom = !"_LONG".equals(propertyText.substring(7));
                String bonusDetails = SkillCostDisplay.getModifierExplanation(skill, pc, shortFrom);
                if (isSituation) {
                    String sitDetails = SkillCostDisplay.getSituationModifierExplanation(skill, situation, pc, shortFrom);
                    retValue.append(bonusDetails + " situational: " + sitDetails);
                    break;
                }
                retValue.append(bonusDetails);
                break;
            }
            case 14: {
                String type = skill.getType();
                retValue.append(type);
                break;
            }
            case 16: {
                int i = (int)pc.getSizeAdjustmentBonusTo("SKILL", skill.getKeyName());
                if (isSituation) {
                    i = (int)((double)i + pc.getSizeAdjustmentBonusTo("SITUATION", skill.getKeyName() + "=" + situation));
                }
                retValue.append(Integer.toString(i));
                break;
            }
            case 17: {
                ArrayList<String> classes = new ArrayList<String>();
                for (PCClass aClass : pc.getClassList()) {
                    if (pc.getSkillCostForClass(skill, aClass) != SkillCost.CLASS) continue;
                    classes.add(aClass.getDisplayName());
                }
                retValue.append(StringUtils.join(classes, "."));
                break;
            }
            default: {
                Logging.errorPrint("In ExportHandler._writeSkillProperty the propIdvalue " + property + " is not handled.");
            }
        }
        return retValue.toString();
    }
}

