/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.base.util.MapToList;
import pcgen.base.util.TreeMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.rules.context.AssociatedChanges;

public class ListChanges<T extends CDOMObject>
implements AssociatedChanges<CDOMReference<T>> {
    private final String tokenName;
    private final CDOMObject positive;
    private final CDOMObject negative;
    private final CDOMReference<? extends CDOMList<T>> list;
    private final boolean clear;

    public ListChanges(String token, CDOMObject added, CDOMObject removed, CDOMReference<? extends CDOMList<T>> listref, boolean globallyCleared) {
        this.tokenName = token;
        this.positive = added;
        this.negative = removed;
        this.list = listref;
        this.clear = globallyCleared;
    }

    @Override
    public boolean includesGlobalClear() {
        return this.clear;
    }

    public boolean isEmpty() {
        return !this.clear && !this.hasAddedItems() && !this.hasRemovedItems();
    }

    @Override
    public Collection<CDOMReference<T>> getAdded() {
        TreeSet<CDOMReference<T>> set = new TreeSet<CDOMReference<T>>(ReferenceUtilities.REFERENCE_SORTER);
        Collection listMods = this.positive.getListMods(this.list);
        if (listMods != null) {
            for (CDOMReference ref : listMods) {
                for (AssociatedPrereqObject assoc : this.positive.getListAssociations(this.list, ref)) {
                    if (!this.tokenName.equals(assoc.getAssociation(AssociationKey.TOKEN))) continue;
                    set.add(ref);
                }
            }
        }
        return set;
    }

    public boolean hasAddedItems() {
        return this.positive != null && this.positive.getListMods(this.list) != null && !this.positive.getListMods(this.list).isEmpty();
    }

    @Override
    public Collection<CDOMReference<T>> getRemoved() {
        TreeSet<CDOMReference<T>> set = new TreeSet<CDOMReference<T>>(ReferenceUtilities.REFERENCE_SORTER);
        if (this.negative == null) {
            return set;
        }
        Collection listMods = this.negative.getListMods(this.list);
        if (listMods != null) {
            for (CDOMReference ref : listMods) {
                for (AssociatedPrereqObject assoc : this.negative.getListAssociations(this.list, ref)) {
                    if (!this.tokenName.equals(assoc.getAssociation(AssociationKey.TOKEN))) continue;
                    set.add(ref);
                }
            }
        }
        return set;
    }

    public boolean hasRemovedItems() {
        return this.negative != null && this.negative.getListMods(this.list) != null && !this.negative.getListMods(this.list).isEmpty();
    }

    @Override
    public MapToList<CDOMReference<T>, AssociatedPrereqObject> getAddedAssociations() {
        Collection mods = this.positive.getListMods(this.list);
        if (mods == null) {
            return null;
        }
        TreeMapToList owned = new TreeMapToList(ReferenceUtilities.REFERENCE_SORTER);
        for (CDOMReference lw : mods) {
            Collection<AssociatedPrereqObject> assocs = this.positive.getListAssociations(this.list, lw);
            for (AssociatedPrereqObject assoc : assocs) {
                if (!this.tokenName.equals(assoc.getAssociation(AssociationKey.TOKEN))) continue;
                owned.addToListFor(lw, (Object)assoc);
            }
        }
        if (owned.isEmpty()) {
            return null;
        }
        return owned;
    }

    @Override
    public MapToList<CDOMReference<T>, AssociatedPrereqObject> getRemovedAssociations() {
        TreeMapToList owned = new TreeMapToList(ReferenceUtilities.REFERENCE_SORTER);
        if (this.negative == null) {
            return owned;
        }
        Collection mods = this.negative.getListMods(this.list);
        if (mods == null) {
            return owned;
        }
        for (CDOMReference lw : mods) {
            Collection<AssociatedPrereqObject> assocs = this.negative.getListAssociations(this.list, lw);
            for (AssociatedPrereqObject assoc : assocs) {
                if (!this.tokenName.equals(assoc.getAssociation(AssociationKey.TOKEN))) continue;
                owned.addToListFor(lw, (Object)assoc);
            }
        }
        if (owned.isEmpty()) {
            return null;
        }
        return owned;
    }
}

