/*
 * Decompiled with CFR 0.152.
 */
package pcgen.pluginmgr;

import javax.swing.event.EventListenerList;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.ComponentAddedMessage;
import pcgen.pluginmgr.messages.ComponentRemovedMessage;

public class MessageHandlerManager {
    private final PCGenMessageHandler postbox;
    private final EventListenerList chain = new EventListenerList();

    public MessageHandlerManager() {
        this.postbox = new PCGenMessagePostbox();
    }

    public void addMember(PCGenMessageHandler plugin) {
        this.chain.add(PCGenMessageHandler.class, plugin);
        this.postbox.handleMessage(new ComponentAddedMessage(this, plugin));
    }

    public void removeMember(PCGenMessageHandler plugin) {
        this.postbox.handleMessage(new ComponentRemovedMessage(this, plugin));
        this.chain.remove(PCGenMessageHandler.class, plugin);
    }

    public PCGenMessageHandler getPostbox() {
        return this.postbox;
    }

    private final class PCGenMessagePostbox
    implements PCGenMessageHandler {
        private PCGenMessagePostbox() {
        }

        @Override
        public void handleMessage(PCGenMessage msg) {
            Object[] listeners = MessageHandlerManager.this.chain.getListenerList();
            boolean sourceListening = false;
            for (int i = 0; i < listeners.length - 1; i += 2) {
                if (listeners[i] != PCGenMessageHandler.class) continue;
                PCGenMessageHandler handler = (PCGenMessageHandler)listeners[i + 1];
                if (handler == msg.getSource()) {
                    sourceListening = true;
                    continue;
                }
                handler.handleMessage(msg);
                if (msg.isConsumed()) break;
            }
            if (!msg.isConsumed() && sourceListening) {
                ((PCGenMessageHandler)msg.getSource()).handleMessage(msg);
            }
        }
    }
}

