/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.tools.PrefTableColumnModel;
import pcgen.gui2.util.ArrowIcon;
import pcgen.gui2.util.JTableSortingHeader;
import pcgen.gui2.util.JTreeTable;
import pcgen.gui2.util.event.DynamicTableColumnModelListener;
import pcgen.gui2.util.table.DynamicTableColumnModel;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewTableModel;
import pcgen.system.PropertyContext;
import pcgen.util.CollectionMaps;
import pcgen.util.ListMap;

public class JTreeViewTable<T>
extends JTreeTable {
    private static final String TREE_VIEW_COL_PREFS_KEY = "TreeView";
    private static final String VIEW_INDEX_PREFS_KEY = "viewIdx";
    private final DynamicTableColumnModelListener listener = new DynamicTableColumnModelListener(){

        @Override
        public void availableColumnAdded(TableColumnModelEvent event) {
            int index = event.getToIndex();
            TableColumn column = JTreeViewTable.this.dynamicColumnModel.getAvailableColumns().get(index);
            JTreeViewTable.this.menu.insert(JTreeViewTable.this.createMenuItem(column), index);
            JTreeViewTable.this.cornerButton.setVisible(true);
        }

        @Override
        public void availableColumnRemove(TableColumnModelEvent event) {
            JTreeViewTable.this.menu.remove(event.getFromIndex());
            if (JTreeViewTable.this.menu.getComponentCount() == 0) {
                JTreeViewTable.this.cornerButton.setVisible(false);
            }
        }
    };
    private final JButton cornerButton = new JButton(new CornerAction());
    private DynamicTableColumnModel dynamicColumnModel = null;
    private JPopupMenu menu = new JPopupMenu();
    protected TreeViewTableModel<T> treetableModel;
    private TreeViewModel<T> viewModel;
    private TreeViewsPopupMenu treeviewMenu = new TreeViewsPopupMenu();
    private PropertyContext baseContext;

    public JTreeViewTable() {
        this.setTableHeader(new JTreeViewHeader());
        this.setAutoCreateColumnsFromModel(false);
        this.getTree().setLargeModel(true);
        this.baseContext = UIPropertyContext.createContext("tablePrefs");
    }

    protected <TM> TreeViewTableModel<TM> createDefaultTreeViewTableModel(DataView<TM> dataView) {
        return new TreeViewTableModel<TM>(dataView);
    }

    private JCheckBoxMenuItem createMenuItem(TableColumn column) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        boolean visible = this.dynamicColumnModel.isVisible(column);
        item.setSelected(visible);
        item.setAction(new MenuAction(column, visible));
        return item;
    }

    private DynamicTableColumnModel createTableColumnModel(TreeView<?> startingView, DataView<?> dataView) {
        ListMap<DataViewColumn.Visibility, TableColumn, ArrayList> listMap = CollectionMaps.createListMap(HashMap.class, ArrayList.class);
        int index = 1;
        for (DataViewColumn column : dataView.getDataColumns()) {
            TableColumn tableColumn = new TableColumn(index++);
            tableColumn.setHeaderValue(column.getName());
            DataViewColumn.Visibility vis = column.getVisibility();
            listMap.add(vis, tableColumn);
        }
        List columns = (List)listMap.get((Object)DataViewColumn.Visibility.ALWAYS_VISIBLE);
        if (columns == null) {
            columns = Collections.emptyList();
        }
        PrefTableColumnModel model = new PrefTableColumnModel(this.viewModel.getDataView().getPrefsKey(), columns.size() + 1);
        TableColumn viewColumn = new TableColumn();
        viewColumn.setHeaderValue(startingView.getViewName());
        viewColumn.setIdentifier(TREE_VIEW_COL_PREFS_KEY);
        model.addColumn(viewColumn, true, 150);
        for (TableColumn column : columns) {
            model.addColumn(column, true, 75);
        }
        columns = (List)listMap.get((Object)DataViewColumn.Visibility.INITIALLY_VISIBLE);
        if (columns != null) {
            for (TableColumn column : columns) {
                model.addColumn(column, true, 75);
            }
        }
        if ((columns = (List)listMap.get((Object)DataViewColumn.Visibility.INITIALLY_INVISIBLE)) != null) {
            for (TableColumn column : columns) {
                model.addColumn(column, false, 75);
            }
        }
        return model;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        }
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        Container gp;
        super.unconfigureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setCorner("UPPER_RIGHT_CORNER", null);
        }
    }

    public List<Object> getSelectedData() {
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> data = new ArrayList<Object>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            data.add(node.getUserObject());
        }
        return data;
    }

    public Object getSelectedObject() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            return this.getModel().getValueAt(selectedRow, 0);
        }
        return null;
    }

    public void refreshModelData() {
        if (this.treetableModel != null) {
            this.treetableModel.refreshData();
        }
        this.resizeAndRepaint();
    }

    public void updateDisplay() {
        this.resizeAndRepaint();
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        if (this.dynamicColumnModel != null) {
            this.dynamicColumnModel.removeDynamicTableColumnModelListener(this.listener);
            this.cornerButton.setVisible(false);
        }
        super.setColumnModel(columnModel);
    }

    public void setColumnModel(DynamicTableColumnModel columnModel) {
        if (this.dynamicColumnModel != null) {
            this.dynamicColumnModel.removeDynamicTableColumnModelListener(this.listener);
        }
        this.dynamicColumnModel = columnModel;
        columnModel.addDynamicTableColumnModelListener(this.listener);
        super.setColumnModel(columnModel);
        List<TableColumn> columns = columnModel.getAvailableColumns();
        this.menu.removeAll();
        if (!columns.isEmpty()) {
            for (TableColumn column : columns) {
                this.menu.add(this.createMenuItem(column));
            }
            this.cornerButton.setVisible(true);
        } else {
            this.cornerButton.setVisible(false);
        }
    }

    protected void setTreeView(TreeView<? super T> view) {
        TableColumn viewColumn = this.getColumn(TREE_VIEW_COL_PREFS_KEY);
        this.treetableModel.setSelectedTreeView(view);
        viewColumn.setHeaderValue(view.getViewName());
        this.sortModel();
        this.getTableHeader().repaint();
        PropertyContext context = this.baseContext.createChildContext(this.viewModel.getDataView().getPrefsKey());
        int index = this.getIndex(this.viewModel.getTreeViews(), view);
        if (index >= 0) {
            context.setInt(VIEW_INDEX_PREFS_KEY, index);
        }
    }

    private int getIndex(ListFacade<? extends TreeView<T>> treeViews, TreeView<? super T> view) {
        for (int i = 0; i < treeViews.getSize(); ++i) {
            TreeView<T> treeView = treeViews.getElementAt(i);
            if (!treeView.equals(view)) continue;
            return i;
        }
        return -1;
    }

    public TreeViewModel<?> getTreeViewModel() {
        return this.viewModel;
    }

    public void setTreeViewModel(TreeViewModel<T> viewModel) {
        ListFacade<TreeView<T>> views = viewModel.getTreeViews();
        PropertyContext context = this.baseContext.createChildContext(viewModel.getDataView().getPrefsKey());
        int viewIndex = context.initInt(VIEW_INDEX_PREFS_KEY, viewModel.getDefaultTreeViewIndex());
        TreeView<T> startingView = views.getElementAt(viewIndex);
        DataView<T> dataView = viewModel.getDataView();
        TreeViewTableModel<T> model = this.createDefaultTreeViewTableModel(dataView);
        this.treetableModel = model;
        if (this.viewModel != null) {
            this.viewModel.getTreeViews().removeListListener(this.treeviewMenu);
        }
        this.viewModel = viewModel;
        this.treeviewMenu.resetComponents();
        this.viewModel.getTreeViews().addListListener(this.treeviewMenu);
        model.setDataModel(viewModel.getDataModel());
        model.setSelectedTreeView(startingView);
        this.setTreeTableModel(model);
        this.setColumnModel(this.createTableColumnModel(startingView, dataView));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTreeViewTable.this.sortModel();
            }
        });
    }

    public TreeView<? super T> getSelectedTreeView() {
        return this.treetableModel.getSelectedTreeView();
    }

    private TreeView<? super T> findViewByName(ListFacade<? extends TreeView<T>> views, String viewName) {
        for (TreeView treeView : views) {
            if (!treeView.getViewName().equals(viewName)) continue;
            return treeView;
        }
        return views.getElementAt(0);
    }

    protected class JTreeViewHeader
    extends JTableSortingHeader {
        public JTreeViewHeader() {
            super(JTreeViewTable.this);
        }

        @Override
        protected TableCellRenderer createDefaultRenderer() {
            return new TreeViewHeaderRenderer();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!JTreeViewTable.this.treeviewMenu.isVisible()) {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.maybeShowPopup(e);
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && this.getTrackedColumn() != null && this.getTrackedColumn().getHeaderValue() == JTreeViewTable.this.treetableModel.getSelectedTreeView().getViewName()) {
                TableColumnModel columnmodel = this.getColumnModel();
                Rectangle rect = this.getHeaderRect(columnmodel.getColumnIndexAtX(e.getX()));
                JTreeViewTable.this.treeviewMenu.setPopupSize(rect.width, ((JTreeViewTable)JTreeViewTable.this).treeviewMenu.getPreferredSize().height);
                JTreeViewTable.this.treeviewMenu.show(JTreeViewTable.this.getParent(), rect.x, rect.y);
            }
        }

        private class TreeViewHeaderRenderer
        extends JTableSortingHeader.SortingHeaderRenderer {
            private JLabel arrowLabel = new JLabel(new ArrowIcon(5, 5));

            public TreeViewHeaderRenderer() {
                this.arrowLabel.setPreferredSize(new Dimension(16, 16));
                this.arrowLabel.setMaximumSize(new Dimension(16, Integer.MAX_VALUE));
                this.arrowLabel.setAlignmentX(1.0f);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, column);
                this.removeAll();
                if (JTreeViewTable.this.treetableModel.getSelectedTreeView().getViewName() == value) {
                    this.add(this.arrowLabel);
                }
                return this;
            }
        }
    }

    private class ChangeViewAction
    extends AbstractAction {
        private TreeView<T> view;

        public ChangeViewAction(TreeView<T> view) {
            super(view.getViewName());
            this.view = view;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTreeViewTable.this.setTreeView(this.view);
        }
    }

    private class MenuAction
    extends AbstractAction {
        private boolean visible;
        private TableColumn column;

        public MenuAction(TableColumn column, boolean visible) {
            super(column.getHeaderValue().toString());
            this.visible = visible;
            this.column = column;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.visible = !this.visible;
            JTreeViewTable.this.dynamicColumnModel.setVisible(this.column, this.visible);
        }
    }

    private class CornerAction
    extends AbstractAction {
        public CornerAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container parent = JTreeViewTable.this.getParent();
            JTreeViewTable.this.menu.setVisible(true);
            JTreeViewTable.this.menu.show(parent, parent.getWidth() - JTreeViewTable.this.menu.getWidth(), 0);
        }
    }

    private class TreeViewsPopupMenu
    extends JPopupMenu
    implements ListListener<TreeView<T>> {
        private ButtonGroup group = new ButtonGroup();

        private TreeViewsPopupMenu() {
        }

        @Override
        public void elementAdded(ListEvent<TreeView<T>> e) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(new ChangeViewAction(e.getElement()));
            this.group.add(item);
            this.add((Component)item, e.getIndex());
        }

        @Override
        public void elementRemoved(ListEvent<TreeView<T>> e) {
            this.group.remove((AbstractButton)this.getComponent(e.getIndex()));
            this.remove(e.getIndex());
        }

        public void resetComponents() {
            this.elementsChanged((ListEvent<TreeView<T>>)null);
        }

        @Override
        public void elementsChanged(ListEvent<TreeView<T>> e) {
            ListFacade views = JTreeViewTable.this.viewModel.getTreeViews();
            PropertyContext context = JTreeViewTable.this.baseContext.createChildContext(JTreeViewTable.this.viewModel.getDataView().getPrefsKey());
            int viewIndex = context.initInt(JTreeViewTable.VIEW_INDEX_PREFS_KEY, JTreeViewTable.this.viewModel.getDefaultTreeViewIndex());
            TreeView startingView = views.getElementAt(viewIndex);
            this.group = new ButtonGroup();
            this.removeAll();
            for (TreeView treeView : views) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(new ChangeViewAction(treeView));
                item.setSelected(startingView == treeView);
                this.group.add(item);
                this.add(item);
            }
        }

        @Override
        public void elementModified(ListEvent<TreeView<T>> e) {
        }
    }
}

