/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import pcgen.core.BodyStructure;
import pcgen.facade.core.BodyStructureFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tabs.equip.EquipmentModel;
import pcgen.gui2.tabs.equip.EquipmentModels;
import pcgen.gui2.tabs.equip.EquipmentSelection;
import pcgen.gui2.tabs.models.CharacterComboBoxModel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.tools.PrefTableColumnModel;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.JDynamicTable;
import pcgen.gui2.util.JTableEx;
import pcgen.gui2.util.JTreeTable;
import pcgen.gui2.util.SortMode;
import pcgen.gui2.util.SortingPriority;
import pcgen.gui2.util.event.PopupMouseAdapter;
import pcgen.gui2.util.table.DynamicTableColumnModel;
import pcgen.gui2.util.table.SortableTableModel;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Tab;

public class EquipInfoTab
extends FlippingSplitPane
implements CharacterInfoTab,
TodoHandler {
    private static final DataFlavor equipNodeArrayFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + EquipmentSetFacade.EquipNode[].class.getName() + "\"", null);
    private final JDynamicTable equipmentTable = new JDynamicTable();
    private final JComboBox equipViewBox = new JComboBox<EquipmentModels.EquipView>(EquipmentModels.EquipView.values());
    private final JTreeTable equipmentSetTable;
    private final InfoPane infoPane = new InfoPane();
    private final JButton unequipButton;
    private final JButton unequipAllButton;
    private final JButton moveUpButton;
    private final JButton moveDownButton;
    private final JButton equipButton;
    private final JComboBox equipSetBox;
    private final JButton newSetButton;
    private final JButton removeSetButton;
    private final JButton exportTemplateButton;
    private final JButton viewBrowserButton;
    private final JButton exportFileButton;
    private final JButton setNoteButton;
    private final JButton expandAllButton;
    private final JButton collapseAllButton;
    private final JLabel weightLabel;
    private final JLabel loadLabel;
    private final JLabel limitLabel;
    private DisplayableFilter<Object, Object> tableFilter;

    public EquipInfoTab() {
        super("Equip");
        this.equipmentSetTable = new JTreeTable(){

            @Override
            protected void configureEnclosingScrollPane() {
            }
        };
        this.equipButton = new JButton();
        this.unequipButton = new JButton();
        this.unequipAllButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.equipSetBox = new JComboBox();
        this.newSetButton = new JButton();
        this.removeSetButton = new JButton();
        this.exportTemplateButton = new JButton();
        this.viewBrowserButton = new JButton();
        this.exportFileButton = new JButton();
        this.setNoteButton = new JButton();
        this.expandAllButton = new JButton();
        this.collapseAllButton = new JButton();
        this.weightLabel = new JLabel();
        this.loadLabel = new JLabel();
        this.limitLabel = new JLabel();
        this.initComponents();
    }

    private void initComponents() {
        FontManipulation.small(this.newSetButton);
        this.newSetButton.setMargin(new Insets(0, 0, 0, 0));
        FontManipulation.small(this.removeSetButton);
        this.removeSetButton.setMargin(new Insets(0, 0, 0, 0));
        this.exportTemplateButton.setText(LanguageBundle.getString("in_equipExportTemplate"));
        this.viewBrowserButton.setText(LanguageBundle.getString("in_equipViewBrowser"));
        this.exportFileButton.setText(LanguageBundle.getString("in_equipExportFile"));
        this.setNoteButton.setText(LanguageBundle.getString("in_equipSetNote"));
        this.setOrientation(1);
        FlippingSplitPane splitPane = new FlippingSplitPane(0, "EquipMain");
        JPanel panel = new JPanel(new BorderLayout());
        Box bar = Box.createHorizontalBox();
        bar.add(Box.createHorizontalStrut(5));
        bar.add(new JLabel(LanguageBundle.getString("in_equipView")));
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.equipViewBox);
        bar.add(Box.createHorizontalStrut(5));
        this.tableFilter = new SearchFilterPanel();
        bar.add(this.tableFilter.getFilterComponent());
        bar.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        panel.add((Component)bar, "North");
        this.equipmentTable.setAutoCreateColumnsFromModel(false);
        this.equipmentTable.setColumnModel(this.createEquipmentColumnModel());
        this.equipmentTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.equipmentTable.sortModel();
        panel.add((Component)new JScrollPane(this.equipmentTable), "Center");
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.add(Box.createHorizontalGlue());
        this.equipButton.setHorizontalTextPosition(10);
        buttonsBox.add(this.equipButton);
        buttonsBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)buttonsBox, "South");
        splitPane.setTopComponent(panel);
        splitPane.setBottomComponent(this.infoPane);
        this.setLeftComponent(splitPane);
        panel = new JPanel(new BorderLayout());
        Box equipPane = Box.createVerticalBox();
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(LanguageBundle.getString("in_equipSetLabel")));
        box.add(Box.createHorizontalStrut(3));
        box.add(this.equipSetBox);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.newSetButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.removeSetButton);
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(LanguageBundle.getString("in_equipWeightLabel")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.weightLabel);
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(LanguageBundle.getString("in_equipLoadLabel")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.loadLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.limitLabel);
        box.add(Box.createHorizontalGlue());
        equipPane.add(Box.createVerticalStrut(3));
        equipPane.add(box);
        equipPane.add(Box.createVerticalStrut(3));
        box = Box.createHorizontalBox();
        box.add(this.exportTemplateButton);
        this.exportTemplateButton.setEnabled(false);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.viewBrowserButton);
        this.viewBrowserButton.setEnabled(false);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.exportFileButton);
        this.exportFileButton.setEnabled(false);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.setNoteButton);
        this.setNoteButton.setEnabled(false);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.expandAllButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.collapseAllButton);
        equipPane.add(box);
        equipPane.add(Box.createVerticalStrut(3));
        panel.add((Component)equipPane, "North");
        EquipmentModel.initializeTreeTable(this.equipmentSetTable);
        panel.add((Component)new JScrollPane(this.equipmentSetTable), "Center");
        Box selPanelbuttonsBox = Box.createHorizontalBox();
        selPanelbuttonsBox.add(Box.createHorizontalStrut(3));
        selPanelbuttonsBox.add(this.unequipButton);
        selPanelbuttonsBox.add(Box.createHorizontalStrut(3));
        selPanelbuttonsBox.add(this.unequipAllButton);
        selPanelbuttonsBox.add(Box.createHorizontalStrut(3));
        selPanelbuttonsBox.add(this.moveUpButton);
        selPanelbuttonsBox.add(Box.createHorizontalStrut(3));
        selPanelbuttonsBox.add(this.moveDownButton);
        selPanelbuttonsBox.add(Box.createHorizontalGlue());
        selPanelbuttonsBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)selPanelbuttonsBox, "South");
        this.setRightComponent(panel);
    }

    private DynamicTableColumnModel createEquipmentColumnModel() {
        PrefTableColumnModel model = new PrefTableColumnModel("EquipList", 1);
        TableColumn column = new TableColumn(0);
        column.setHeaderValue(LanguageBundle.getString("in_nameLabel"));
        model.addColumn(column, true, 150);
        column = new TableColumn(1);
        column.setHeaderValue(LanguageBundle.getString("in_type"));
        model.addColumn(column, true, 75);
        column = new TableColumn(2);
        column.setHeaderValue(LanguageBundle.getString("in_equipLocationAbbrev"));
        model.addColumn(column, true, 75);
        column = new TableColumn(3);
        column.setHeaderValue(LanguageBundle.getString("in_equipQuantityAbbrev"));
        model.addColumn(column, true, 75);
        column = new TableColumn(4);
        column.setHeaderValue(LanguageBundle.getString("in_equipWeightAbbrev"));
        model.addColumn(column, true, 75);
        column = new TableColumn(5);
        column.setHeaderValue(LanguageBundle.getString("in_descrip"));
        model.addColumn(column, false, 75);
        return model;
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(EquipmentModel.class, new EquipmentModel(character, this.equipmentSetTable));
        models.put(EquipmentModels.class, new EquipmentModels(character));
        models.put(UnequipAllAction.class, new UnequipAllAction(character));
        models.put(EquipSetBoxModel.class, new EquipSetBoxModel(character));
        models.put(AddSetAction.class, new AddSetAction(character));
        models.put(RemoveSetAction.class, new RemoveSetAction(character));
        models.put(LabelsUpdater.class, new LabelsUpdater(character));
        models.put(EquipInfoHandler.class, new EquipInfoHandler(character));
        models.put(EquipmentRenderer.class, new EquipmentRenderer(character));
        models.put(EquipmentTransferHandler.class, new EquipmentTransferHandler(character));
        models.put(EquipmentSetTransferHandler.class, new EquipmentSetTransferHandler(character));
        models.put(OrderPopupMenuHandler.class, new OrderPopupMenuHandler(character));
        models.put(ExpandAllAction.class, new ExpandAllAction());
        models.put(CollapseAllAction.class, new CollapseAllAction());
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(EquipmentModel.class).install();
        models.get(EquipmentModels.class).install(this.equipViewBox, this.equipmentTable, this.tableFilter, this.equipmentSetTable, this.equipButton, this.unequipButton, this.moveUpButton, this.moveDownButton);
        models.get(LabelsUpdater.class).install();
        models.get(EquipInfoHandler.class).install();
        models.get(EquipmentRenderer.class).install();
        models.get(EquipmentTransferHandler.class).install();
        models.get(EquipmentSetTransferHandler.class).install();
        models.get(OrderPopupMenuHandler.class).install();
        this.unequipAllButton.setAction(models.get(UnequipAllAction.class));
        this.newSetButton.setAction(models.get(AddSetAction.class));
        this.removeSetButton.setAction(models.get(RemoveSetAction.class));
        this.expandAllButton.setAction(models.get(ExpandAllAction.class));
        this.collapseAllButton.setAction(models.get(CollapseAllAction.class));
        this.equipSetBox.setModel(models.get(EquipSetBoxModel.class));
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(LabelsUpdater.class).uninstall();
        models.get(EquipmentModel.class).uninstall();
        models.get(EquipmentModels.class).uninstall();
        models.get(EquipInfoHandler.class).uninstall();
        models.get(OrderPopupMenuHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return new TabTitle(Tab.EQUIPPING);
    }

    private List<Integer> getMenuTargets(JTable table, MouseEvent e) {
        int row = table.rowAtPoint(e.getPoint());
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        ArrayList<Integer> targets = new ArrayList<Integer>();
        for (int selRow : table.getSelectedRows()) {
            targets.add(selRow);
        }
        return targets;
    }

    public void setLoadLabel(String text) {
        Font font = this.loadLabel.getFont();
        Color color = UIPropertyContext.getQualifiedColor();
        Load encumbrance = Load.getLoadType(text);
        switch (encumbrance) {
            case MEDIUM: {
                font = FontManipulation.bold(font);
                color = UIPropertyContext.getAutomaticColor();
                break;
            }
            case HEAVY: {
                font = FontManipulation.bold_italic(font);
                color = UIPropertyContext.getVirtualColor();
                break;
            }
            case OVERLOAD: {
                font = FontManipulation.bold_italic(font);
                color = UIPropertyContext.getNotQualifiedColor();
                break;
            }
            default: {
                font = FontManipulation.plain(font);
            }
        }
        this.loadLabel.setText(text);
        this.loadLabel.setFont(font);
        this.loadLabel.setForeground(color);
    }

    @Override
    public void adviseTodo(String fieldName) {
    }

    private class SortEquipMenuItem
    extends JMenuItem
    implements ActionListener {
        private final CharacterFacade character;
        private final List<EquipmentSetFacade.EquipNode> targets;

        SortEquipMenuItem(CharacterFacade character, List<EquipmentSetFacade.EquipNode> targets) {
            super(LanguageBundle.getString("in_equipSortAscMenuCommand"));
            this.character = character;
            this.targets = targets;
            this.setToolTipText(LanguageBundle.getString("in_equipSortAscMenuDesc"));
            this.setIcon(Icons.FForward16.getImageIcon());
            this.setEnabled(!targets.isEmpty());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EquipmentSetFacade equipSet = this.character.getEquipmentSetRef().getReference();
            for (EquipmentSetFacade.EquipNode equipNode : this.targets) {
                equipSet.sortEquipment(equipNode);
            }
        }
    }

    private class MoveEquipDownMenuItem
    extends JMenuItem
    implements ActionListener {
        private final CharacterFacade character;
        private final List<EquipmentSetFacade.EquipNode> targets;
        private final EquipmentSetFacade.EquipNode afterNode;

        MoveEquipDownMenuItem(CharacterFacade character, List<EquipmentSetFacade.EquipNode> targets, EquipmentSetFacade.EquipNode beforeNode) {
            super(LanguageBundle.getString("in_equipMoveDownMenuCommand"));
            this.character = character;
            this.targets = targets;
            this.afterNode = beforeNode;
            this.setToolTipText(LanguageBundle.getString("in_equipMoveDownMenuDesc"));
            this.setIcon(Icons.Down16.getImageIcon());
            this.setEnabled(!targets.isEmpty());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EquipmentSetFacade equipSet = this.character.getEquipmentSetRef().getReference();
            for (EquipmentSetFacade.EquipNode equipNode : this.targets) {
                equipSet.moveEquipment(equipNode, 1);
            }
        }
    }

    private class MoveEquipUpMenuItem
    extends JMenuItem
    implements ActionListener {
        private final CharacterFacade character;
        private final List<EquipmentSetFacade.EquipNode> targets;
        private final EquipmentSetFacade.EquipNode beforeNode;

        MoveEquipUpMenuItem(CharacterFacade character, List<EquipmentSetFacade.EquipNode> targets, EquipmentSetFacade.EquipNode beforeNode) {
            super(LanguageBundle.getString("in_equipMoveUpMenuCommand"));
            this.character = character;
            this.targets = targets;
            this.beforeNode = beforeNode;
            this.setToolTipText(LanguageBundle.getString("in_equipMoveUpMenuDesc"));
            this.setIcon(Icons.Up16.getImageIcon());
            this.setEnabled(!targets.isEmpty());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EquipmentSetFacade equipSet = this.character.getEquipmentSetRef().getReference();
            for (EquipmentSetFacade.EquipNode equipNode : this.targets) {
                equipSet.moveEquipment(equipNode, -1);
            }
        }
    }

    private class OrderPopupMenuHandler
    extends PopupMouseAdapter {
        private final CharacterFacade character;

        OrderPopupMenuHandler(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public void showPopup(MouseEvent e) {
            List targets = EquipInfoTab.this.getMenuTargets(EquipInfoTab.this.equipmentSetTable, e);
            if (targets.isEmpty()) {
                return;
            }
            ArrayList<EquipmentSetFacade.EquipNode> upTargets = new ArrayList<EquipmentSetFacade.EquipNode>();
            ArrayList<EquipmentSetFacade.EquipNode> downTargets = new ArrayList<EquipmentSetFacade.EquipNode>();
            ArrayList<EquipmentSetFacade.EquipNode> sortTargets = new ArrayList<EquipmentSetFacade.EquipNode>();
            EquipmentSetFacade.EquipNode[] relativeNodes = this.filterTargets(targets, upTargets, downTargets, sortTargets);
            JPopupMenu popupMenu = new JPopupMenu();
            if (!upTargets.isEmpty() || !downTargets.isEmpty()) {
                popupMenu.add(new MoveEquipUpMenuItem(this.character, upTargets, relativeNodes[0]));
                popupMenu.add(new MoveEquipDownMenuItem(this.character, downTargets, relativeNodes[1]));
            }
            if (!sortTargets.isEmpty()) {
                if (!upTargets.isEmpty() || !downTargets.isEmpty()) {
                    popupMenu.addSeparator();
                }
                popupMenu.add(new SortEquipMenuItem(this.character, sortTargets));
            }
            if (popupMenu.getComponents().length > 0) {
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private EquipmentSetFacade.EquipNode[] filterTargets(List<Integer> targetRows, List<EquipmentSetFacade.EquipNode> upTargets, List<EquipmentSetFacade.EquipNode> downTargets, List<EquipmentSetFacade.EquipNode> sortTargets) {
            EquipmentSetFacade equipSet = this.character.getEquipmentSetRef().getReference();
            SortableTableModel equipSetModel = EquipInfoTab.this.equipmentSetTable.getModel();
            int beforeRow = equipSetModel.getRowCount();
            int afterRow = 0;
            for (Integer selRow : targetRows) {
                EquipmentSetFacade.EquipNode equipNode;
                Object value = equipSetModel.getValueAt(selRow, 0);
                if (!(value instanceof EquipmentSetFacade.EquipNode) || !this.isInGeneralBodyStructure(equipNode = (EquipmentSetFacade.EquipNode)value)) continue;
                switch (equipNode.getNodeType()) {
                    case BODY_SLOT: {
                        sortTargets.add(equipNode);
                        break;
                    }
                    case EQUIPMENT: {
                        upTargets.add(equipNode);
                        downTargets.add(equipNode);
                        if (!equipSet.isContainer(equipNode.getEquipment())) break;
                        sortTargets.add(equipNode);
                        break;
                    }
                }
            }
            EquipmentSetFacade.EquipNode[] relativeNodes = new EquipmentSetFacade.EquipNode[]{null, null};
            if (beforeRow >= 0) {
                relativeNodes[0] = (EquipmentSetFacade.EquipNode)equipSetModel.getValueAt(beforeRow, 0);
            }
            if (afterRow < equipSetModel.getRowCount()) {
                relativeNodes[1] = (EquipmentSetFacade.EquipNode)equipSetModel.getValueAt(afterRow, 0);
            }
            return relativeNodes;
        }

        private boolean isInGeneralBodyStructure(EquipmentSetFacade.EquipNode equipNode) {
            BodyStructureFacade bodyStructure = equipNode.getBodyStructure();
            return bodyStructure instanceof BodyStructure && ((BodyStructure)bodyStructure).getEquipSlots().isEmpty();
        }

        public void install() {
            EquipInfoTab.this.equipmentSetTable.addMouseListener(this);
        }

        public void uninstall() {
            EquipInfoTab.this.equipmentSetTable.removeMouseListener(this);
        }
    }

    private class EquipmentSetTransferHandler
    extends TransferHandler {
        private CharacterFacade character;

        public EquipmentSetTransferHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            EquipInfoTab.this.equipmentSetTable.setTransferHandler(this);
            EquipInfoTab.this.equipmentSetTable.setDragEnabled(true);
            EquipInfoTab.this.equipmentSetTable.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c == EquipInfoTab.this.equipmentSetTable) {
                int[] rows = EquipInfoTab.this.equipmentSetTable.getSelectedRows();
                if (ArrayUtils.isEmpty(rows)) {
                    return null;
                }
                EquipmentSetFacade.EquipNode[] nodeArray = new EquipmentSetFacade.EquipNode[rows.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    nodeArray[i] = (EquipmentSetFacade.EquipNode)EquipInfoTab.this.equipmentSetTable.getModel().getValueAt(rows[i], 0);
                }
                return new EquipNodeSelection(nodeArray);
            }
            return super.createTransferable(c);
        }

        private EquipmentFacade[] getEquipmentArray(TransferHandler.TransferSupport support) {
            EquipmentFacade[] equipmentArray = null;
            try {
                equipmentArray = (EquipmentFacade[])support.getTransferable().getTransferData(EquipmentSelection.equipmentArrayFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                Logger.getLogger(EquipInfoTab.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(EquipInfoTab.class.getName()).log(Level.SEVERE, null, ex);
            }
            return equipmentArray;
        }

        private EquipmentSetFacade.EquipNode[] getEquipNodeArray(TransferHandler.TransferSupport support) {
            EquipmentSetFacade.EquipNode[] equipNodeArray = null;
            try {
                equipNodeArray = (EquipmentSetFacade.EquipNode[])support.getTransferable().getTransferData(equipNodeArrayFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                Logger.getLogger(EquipInfoTab.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(EquipInfoTab.class.getName()).log(Level.SEVERE, null, ex);
            }
            return equipNodeArray;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            JTable.DropLocation location = (JTable.DropLocation)support.getDropLocation();
            int row = location.getRow();
            EquipmentSetFacade.EquipNode node = (EquipmentSetFacade.EquipNode)EquipInfoTab.this.equipmentSetTable.getValueAt(row, 0);
            if (node == null) {
                return false;
            }
            if (location.isInsertRow()) {
                node = node.getParent();
            }
            EquipmentSetFacade equipSet = this.character.getEquipmentSetRef().getReference();
            if (support.isDataFlavorSupported(equipNodeArrayFlavor)) {
                EquipmentSetFacade.EquipNode[] equipNodeArray = this.getEquipNodeArray(support);
                if (equipNodeArray == null) {
                    return false;
                }
                for (EquipmentSetFacade.EquipNode equipNode : equipNodeArray) {
                    if (equipSet.canEquip(node, equipNode.getEquipment())) continue;
                    return false;
                }
                return true;
            }
            if (support.isDataFlavorSupported(EquipmentSelection.equipmentArrayFlavor)) {
                EquipmentFacade[] equipmentArray = this.getEquipmentArray(support);
                if (equipmentArray == null) {
                    return false;
                }
                for (EquipmentFacade equipmentFacade : equipmentArray) {
                    if (equipSet.canEquip(node, equipmentFacade)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            block7: {
                EquipmentSetFacade equipSet;
                EquipmentSetFacade.EquipNode beforeNode;
                EquipmentSetFacade.EquipNode node;
                block6: {
                    if (!this.canImport(support) || !support.isDrop()) {
                        return false;
                    }
                    JTable.DropLocation location = (JTable.DropLocation)support.getDropLocation();
                    int row = location.getRow();
                    node = (EquipmentSetFacade.EquipNode)EquipInfoTab.this.equipmentSetTable.getValueAt(row, 0);
                    beforeNode = null;
                    if (location.isInsertRow()) {
                        beforeNode = node;
                        node = node.getParent();
                    }
                    equipSet = this.character.getEquipmentSetRef().getReference();
                    if (!support.isDataFlavorSupported(equipNodeArrayFlavor)) break block6;
                    EquipmentSetFacade.EquipNode[] equipNodeArray = this.getEquipNodeArray(support);
                    if (equipNodeArray == null) {
                        return false;
                    }
                    for (EquipmentSetFacade.EquipNode equipNode : equipNodeArray) {
                        int quantity = equipSet.getQuantity(equipNode);
                        equipSet.removeEquipment(equipNode, quantity);
                        equipSet.addEquipment(node, equipNode.getEquipment(), quantity, beforeNode);
                    }
                    break block7;
                }
                if (!support.isDataFlavorSupported(EquipmentSelection.equipmentArrayFlavor)) break block7;
                EquipmentFacade[] equipmentArray = this.getEquipmentArray(support);
                if (equipmentArray == null) {
                    return false;
                }
                for (EquipmentFacade equipmentFacade : equipmentArray) {
                    equipSet.addEquipment(node, equipmentFacade, 1, beforeNode);
                }
            }
            return true;
        }
    }

    private class EquipmentTransferHandler
    extends TransferHandler {
        private CharacterFacade character;

        public EquipmentTransferHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            EquipInfoTab.this.equipmentTable.setDragEnabled(true);
            EquipInfoTab.this.equipmentTable.setDropMode(DropMode.ON);
            EquipInfoTab.this.equipmentTable.setTransferHandler(this);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c == EquipInfoTab.this.equipmentTable) {
                int[] rows = EquipInfoTab.this.equipmentTable.getSelectedRows();
                if (ArrayUtils.isEmpty(rows)) {
                    return null;
                }
                EquipmentFacade[] equipArray = new EquipmentFacade[rows.length];
                for (int i = 0; i < equipArray.length; ++i) {
                    equipArray[i] = (EquipmentFacade)EquipInfoTab.this.equipmentTable.getModel().getValueAt(rows[i], 0);
                }
                return new EquipmentSelection(equipArray);
            }
            return super.createTransferable(c);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(equipNodeArrayFlavor)) {
                return false;
            }
            support.setShowDropLocation(false);
            return true;
        }

        private EquipmentSetFacade.EquipNode[] getEquipNodeArray(TransferHandler.TransferSupport support) {
            EquipmentSetFacade.EquipNode[] equipNodeArray = null;
            try {
                equipNodeArray = (EquipmentSetFacade.EquipNode[])support.getTransferable().getTransferData(equipNodeArrayFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                Logger.getLogger(EquipInfoTab.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(EquipInfoTab.class.getName()).log(Level.SEVERE, null, ex);
            }
            return equipNodeArray;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            if (!support.isDrop()) {
                return false;
            }
            EquipmentSetFacade.EquipNode[] nodes = this.getEquipNodeArray(support);
            if (nodes == null) {
                return false;
            }
            EquipmentSetFacade equipSet = this.character.getEquipmentSetRef().getReference();
            for (EquipmentSetFacade.EquipNode equipNode : nodes) {
                equipSet.removeEquipment(equipNode, 1);
            }
            return true;
        }
    }

    private static class EquipNodeSelection
    implements Transferable {
        private static DataFlavor[] FLAVORS = new DataFlavor[]{EquipInfoTab.access$500(), EquipmentSelection.equipmentArrayFlavor};
        private EquipmentSetFacade.EquipNode[] nodeArray;

        public EquipNodeSelection(EquipmentSetFacade.EquipNode[] nodeArray) {
            this.nodeArray = nodeArray;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == FLAVORS[0] || flavor == FLAVORS[1];
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == equipNodeArrayFlavor) {
                return this.nodeArray;
            }
            if (flavor == EquipmentSelection.equipmentArrayFlavor) {
                EquipmentFacade[] equipArray = new EquipmentFacade[this.nodeArray.length];
                for (int i = 0; i < equipArray.length; ++i) {
                    equipArray[i] = this.nodeArray[i].getEquipment();
                }
                return equipArray;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class EquipmentRenderer
    extends DefaultTableCellRenderer {
        private CharacterFacade character;

        public EquipmentRenderer(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            EquipInfoTab.this.equipmentTable.setDefaultRenderer(Object.class, this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof EquipmentFacade && !this.character.isQualifiedFor((EquipmentFacade)value)) {
                this.setForeground(UIPropertyContext.getNotQualifiedColor());
            } else if (!isSelected) {
                this.setForeground(UIPropertyContext.getQualifiedColor());
            }
            return this;
        }
    }

    private class EquipInfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private String text;

        public EquipInfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            EquipInfoTab.this.equipmentTable.getSelectionModel().addListSelectionListener(this);
            EquipInfoTab.this.equipmentSetTable.getSelectionModel().addListSelectionListener(this);
            EquipInfoTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            EquipInfoTab.this.equipmentTable.getSelectionModel().removeListSelectionListener(this);
            EquipInfoTab.this.equipmentSetTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JTableEx target = EquipInfoTab.this.equipmentTable;
            if (EquipInfoTab.this.equipmentSetTable.getSelectionModel().equals(e.getSource())) {
                target = EquipInfoTab.this.equipmentSetTable;
            }
            if (!e.getValueIsAdjusting()) {
                int[] selectedRows = target.getSelectedRows();
                StringBuilder sb = new StringBuilder(2000);
                for (int row : selectedRows) {
                    EquipmentFacade equip = null;
                    if (row != -1) {
                        Object value = ((JTable)target).getModel().getValueAt(row, 0);
                        if (value instanceof EquipmentFacade) {
                            equip = (EquipmentFacade)value;
                        } else if (value instanceof EquipmentSetFacade.EquipNode) {
                            equip = ((EquipmentSetFacade.EquipNode)value).getEquipment();
                        }
                    }
                    if (equip == null) continue;
                    sb.append(this.character.getInfoFactory().getHTMLInfo(equip));
                }
                this.text = "<html>" + sb.toString() + "</html>";
                EquipInfoTab.this.infoPane.setText(this.text);
            }
        }
    }

    private class LabelsUpdater
    implements ReferenceListener<String> {
        private final ReferenceFacade<String> weightRef;
        private final ReferenceFacade<String> loadRef;
        private final ReferenceFacade<String> limitRef;

        public LabelsUpdater(CharacterFacade character) {
            this.weightRef = character.getCarriedWeightRef();
            this.loadRef = character.getLoadRef();
            this.limitRef = character.getWeightLimitRef();
        }

        public void install() {
            EquipInfoTab.this.weightLabel.setText(this.weightRef.getReference());
            EquipInfoTab.this.setLoadLabel(this.loadRef.getReference());
            EquipInfoTab.this.limitLabel.setText(this.limitRef.getReference());
            this.weightRef.addReferenceListener(this);
            this.loadRef.addReferenceListener(this);
            this.limitRef.addReferenceListener(this);
        }

        public void uninstall() {
            this.weightRef.removeReferenceListener(this);
            this.loadRef.removeReferenceListener(this);
            this.limitRef.removeReferenceListener(this);
        }

        @Override
        public void referenceChanged(ReferenceEvent<String> e) {
            Object source = e.getSource();
            if (source == this.weightRef) {
                EquipInfoTab.this.weightLabel.setText(e.getNewReference());
            } else if (source == this.loadRef) {
                EquipInfoTab.this.setLoadLabel(e.getNewReference());
            } else {
                EquipInfoTab.this.limitLabel.setText(e.getNewReference());
            }
        }
    }

    private class UnequipAllAction
    extends AbstractAction {
        private final CharacterFacade character;

        public UnequipAllAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_equipUnequipAll"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ret = JOptionPane.showConfirmDialog(EquipInfoTab.this, LanguageBundle.getString("in_equipUnequipConfirm"), LanguageBundle.getString("in_areYouSure"), 0);
            if (ret == 0) {
                this.character.getEquipmentSetRef().getReference().removeAllEquipment();
            }
        }
    }

    private class CollapseAllAction
    extends AbstractAction {
        public CollapseAllAction() {
            super("-");
            this.putValue("ShortDescription", LanguageBundle.getString("in_collapseAllTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = EquipInfoTab.this.equipmentSetTable.getTree();
            for (int i = tree.getRowCount() - 1; i >= 0; --i) {
                tree.collapseRow(i);
            }
        }
    }

    private class ExpandAllAction
    extends AbstractAction {
        public ExpandAllAction() {
            super("+");
            this.putValue("ShortDescription", LanguageBundle.getString("in_expandAllTip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = EquipInfoTab.this.equipmentSetTable.getTree();
            for (int i = 0; i < tree.getRowCount(); ++i) {
                tree.expandRow(i);
            }
        }
    }

    private class EquipSetBoxModel
    extends CharacterComboBoxModel<EquipmentSetFacade> {
        private final CharacterFacade character;

        public EquipSetBoxModel(CharacterFacade character) {
            this.character = character;
            this.setListFacade(character.getEquipmentSets());
            this.setReference(character.getEquipmentSetRef());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.character.setEquipmentSet((EquipmentSetFacade)anItem);
        }
    }

    private class RemoveSetAction
    extends AbstractAction {
        private final CharacterFacade character;

        public RemoveSetAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_remove"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.deleteEquipmentSet(this.character.getEquipmentSetRef().getReference());
        }
    }

    private class AddSetAction
    extends AbstractAction {
        private final CharacterFacade character;

        public AddSetAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_new"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(EquipInfoTab.this), (Object)"Name of new set");
            if (StringUtils.isNotEmpty(name)) {
                this.character.setEquipmentSet(this.character.createEquipmentSet(name));
            }
        }
    }
}

