/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.Type;
import pcgen.core.PObject;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.system.LanguageBundle;

public abstract class GeneralChooserFacadeBase
implements ChooserFacade {
    private final String name;
    private final List<InfoFacade> origAvailable;
    private final List<InfoFacade> origSelected;
    private final int maxNewSelections;
    private DefaultListFacade<InfoFacade> availableList;
    private DefaultListFacade<InfoFacade> selectedList;
    private DefaultReferenceFacade<Integer> numSelectionsRemain;
    private final String availableTableTypeNameTitle;
    private final String selectedTableTitle;
    private final String selectionCountName;
    private final String addButtonName;
    private final String removeButtonName;
    private final String availableTableTitle;
    private ChooserFacade.ChooserTreeViewType defaultView = ChooserFacade.ChooserTreeViewType.TYPE_NAME;
    private boolean requireCompleteSelection;
    private boolean preferRadioSelection;
    private final InfoFactory infoFactory;

    GeneralChooserFacadeBase(String name, List<InfoFacade> available, List<InfoFacade> selected, int maxNewSelections, InfoFactory infoFactory) {
        this(name, available, selected, maxNewSelections, LanguageBundle.getString("in_available"), LanguageBundle.getString("in_typeName"), LanguageBundle.getString("in_selected"), LanguageBundle.getString("in_selRemain"), LanguageBundle.getString("in_add"), LanguageBundle.getString("in_remove"), infoFactory);
    }

    GeneralChooserFacadeBase(String name, List<InfoFacade> available, List<InfoFacade> selected, int maxNewSelections, String availableTableTitle, String availableTableTypeNameTitle, String selectedTableTitle, String selectionCountName, String addButtonName, String removeButtonName, InfoFactory infoFactory) {
        this.name = name;
        this.origAvailable = available;
        this.origSelected = selected;
        this.maxNewSelections = maxNewSelections;
        this.availableTableTitle = availableTableTitle;
        this.availableTableTypeNameTitle = availableTableTypeNameTitle;
        this.selectedTableTitle = selectedTableTitle;
        this.selectionCountName = selectionCountName;
        this.addButtonName = addButtonName;
        this.removeButtonName = removeButtonName;
        this.infoFactory = infoFactory;
        this.availableList = new DefaultListFacade<InfoFacade>(this.origAvailable);
        this.selectedList = new DefaultListFacade<InfoFacade>(this.origSelected);
        this.numSelectionsRemain = new DefaultReferenceFacade<Integer>(maxNewSelections);
    }

    @Override
    public final ListFacade<InfoFacade> getAvailableList() {
        return this.availableList;
    }

    @Override
    public final ListFacade<InfoFacade> getSelectedList() {
        return this.selectedList;
    }

    @Override
    public final void addSelected(InfoFacade item) {
        if (this.numSelectionsRemain.getReference() <= 0) {
            return;
        }
        this.selectedList.addElement(item);
        this.availableList.removeElement(item);
        this.numSelectionsRemain.setReference(this.numSelectionsRemain.getReference() - 1);
    }

    @Override
    public final void removeSelected(InfoFacade item) {
        this.selectedList.removeElement(item);
        this.availableList.addElement(item);
        this.numSelectionsRemain.setReference(this.numSelectionsRemain.getReference() + 1);
    }

    @Override
    public ReferenceFacade<Integer> getRemainingSelections() {
        return this.numSelectionsRemain;
    }

    @Override
    public abstract void commit();

    @Override
    public final void rollback() {
        this.availableList.setContents(this.origAvailable);
        this.selectedList.setContents(this.origSelected);
        this.numSelectionsRemain.setReference(this.maxNewSelections);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getAvailableTableTypeNameTitle() {
        return this.availableTableTypeNameTitle;
    }

    @Override
    public String getAvailableTableTitle() {
        return this.availableTableTitle;
    }

    @Override
    public String getSelectedTableTitle() {
        return this.selectedTableTitle;
    }

    @Override
    public String getAddButtonName() {
        return this.addButtonName;
    }

    @Override
    public String getRemoveButtonName() {
        return this.removeButtonName;
    }

    @Override
    public String getSelectionCountName() {
        return this.selectionCountName;
    }

    @Override
    public List<String> getBranchNames(InfoFacade item) {
        ArrayList<String> branches = new ArrayList<String>();
        if (item instanceof PObject) {
            PObject pObject = (PObject)((Object)item);
            for (Type type : pObject.getTrueTypeList(true)) {
                branches.add(type.toString());
            }
        }
        return branches;
    }

    @Override
    public ChooserFacade.ChooserTreeViewType getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(ChooserFacade.ChooserTreeViewType defaultView) {
        this.defaultView = defaultView;
    }

    public void setRequireCompleteSelection(boolean requireCompleteSelection) {
        this.requireCompleteSelection = requireCompleteSelection;
    }

    @Override
    public boolean isRequireCompleteSelection() {
        return this.requireCompleteSelection;
    }

    @Override
    public boolean isPreferRadioSelection() {
        return this.preferRadioSelection;
    }

    @Override
    public boolean isUserInput() {
        return false;
    }

    public void setPreferRadioSelection(boolean preferRadioSelection) {
        this.preferRadioSelection = preferRadioSelection;
    }

    @Override
    public boolean isInfoAvailable() {
        return true;
    }

    @Override
    public InfoFactory getInfoFactory() {
        return this.infoFactory;
    }
}

