/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.coreview;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.meta.CorePerspective;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CoreViewNodeFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DelegatingListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.gui2.util.JTreeViewTable;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class CoreViewFrame
extends JFrame {
    private JComboBoxEx perspectiveChooser;
    private final JTreeViewTable<CoreViewNodeFacade> viewTable = new JTreeViewTable();

    public CoreViewFrame(Frame frame, CharacterFacade character) {
        this.perspectiveChooser = new JComboBoxEx();
        for (CorePerspective pers : CorePerspective.getAllConstants()) {
            this.perspectiveChooser.addItem(pers);
        }
        CoreViewTreeViewModel coreViewTreeViewModel = new CoreViewTreeViewModel(character);
        PerspectiveActionListener pal = new PerspectiveActionListener(coreViewTreeViewModel);
        this.perspectiveChooser.addActionListener(pal);
        this.initialize(character);
        this.perspectiveChooser.setSelectedItem(this.perspectiveChooser.getItemAt(0));
    }

    public void initialize(CharacterFacade character) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(2, 2, 2, 2);
        int col = 0;
        Utility.buildConstraints(c, col, 0, 1, 1, 100.0, 20.0);
        JLabel label = new JLabel(LanguageBundle.getFormattedString("in_CoreView_Perspective", new Object[0]));
        gridbag.setConstraints(label, c);
        this.getContentPane().add(label);
        Utility.buildConstraints(c, col++, 1, 1, 1, 0.0, 20.0);
        gridbag.setConstraints(this.perspectiveChooser, c);
        this.getContentPane().add(this.perspectiveChooser);
        Utility.buildConstraints(c, 0, 2, col, 1, 0.0, 1000.0);
        JScrollPane pane = new JScrollPane(this.viewTable);
        pane.setPreferredSize(new Dimension(500, 300));
        gridbag.setConstraints(pane, c);
        this.getContentPane().add(pane);
        this.setTitle("Core Debug View");
        this.getContentPane().setSize(500, 400);
        this.pack();
        Utility.centerFrame(this, true);
    }

    private static class CoreViewTreeViewModel
    extends DelegatingListFacade<AbilityFacade>
    implements TreeViewModel<CoreViewNodeFacade>,
    DataView<CoreViewNodeFacade> {
        private final CharacterFacade character;
        private DefaultListFacade<CoreViewNodeFacade> coreViewList;
        private final List<? extends DataViewColumn> dataColumns;

        public CoreViewTreeViewModel(CharacterFacade character) {
            this.character = character;
            this.dataColumns = Arrays.asList(new DefaultDataViewColumn("Key", String.class), new DefaultDataViewColumn("Node Type", String.class), new DefaultDataViewColumn("Source", String.class), new DefaultDataViewColumn("Requirements", String.class));
        }

        public void setPerspective(CorePerspective corePerspective) {
            List<CoreViewNodeFacade> coreViewNodes = this.character.getCoreViewTree(corePerspective);
            this.coreViewList = new DefaultListFacade<CoreViewNodeFacade>(coreViewNodes);
        }

        @Override
        public ListFacade<? extends TreeView<CoreViewNodeFacade>> getTreeViews() {
            DefaultListFacade<GrantedTreeView> views = new DefaultListFacade<GrantedTreeView>();
            views.addElement(new GrantedTreeView());
            return views;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<CoreViewNodeFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<CoreViewNodeFacade> getDataModel() {
            return this.coreViewList;
        }

        @Override
        public List<?> getData(CoreViewNodeFacade obj) {
            return Arrays.asList(obj.getKey(), obj.getNodeType(), obj.getSource(), obj.getRequirements());
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.dataColumns;
        }

        @Override
        public String getPrefsKey() {
            return "CoreDebugView";
        }
    }

    private static class GrantedTreeView
    implements TreeView<CoreViewNodeFacade> {
        @Override
        public String getViewName() {
            return "Object Tree";
        }

        @Override
        public List<TreeViewPath<CoreViewNodeFacade>> getPaths(CoreViewNodeFacade pobj) {
            ArrayList<List<CoreViewNodeFacade>> abilityPaths = new ArrayList<List<CoreViewNodeFacade>>();
            this.addPaths(abilityPaths, pobj.getGrantedByNodes(), new ArrayList<CoreViewNodeFacade>());
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Converted " + pobj.getGrantedByNodes() + " into " + abilityPaths + " for " + pobj);
            }
            if (abilityPaths.isEmpty()) {
                return Collections.singletonList(new TreeViewPath<CoreViewNodeFacade>(pobj));
            }
            ArrayList<TreeViewPath<CoreViewNodeFacade>> paths = new ArrayList<TreeViewPath<CoreViewNodeFacade>>();
            for (List list : abilityPaths) {
                Collections.reverse(list);
                paths.add(new TreeViewPath<CoreViewNodeFacade>(list.toArray(), pobj));
            }
            return paths;
        }

        private void addPaths(List<List<CoreViewNodeFacade>> abilityPaths, List<CoreViewNodeFacade> grantedByNodes, ArrayList<CoreViewNodeFacade> path) {
            if (path.size() > 20) {
                Logging.errorPrint("Found probable ability prereq cycle [" + StringUtils.join(path, ",") + "] with prereqs [" + StringUtils.join(grantedByNodes, ",") + "]. Skipping.");
                return;
            }
            for (CoreViewNodeFacade node : grantedByNodes) {
                ArrayList pathclone = (ArrayList)path.clone();
                pathclone.add(node);
                List<CoreViewNodeFacade> preAbilities2 = node.getGrantedByNodes();
                preAbilities2.remove(node);
                if (preAbilities2.isEmpty()) {
                    abilityPaths.add(pathclone);
                    continue;
                }
                this.addPaths(abilityPaths, preAbilities2, pathclone);
            }
        }
    }

    private final class PerspectiveActionListener
    implements ActionListener {
        private final CoreViewTreeViewModel coreViewTreeViewModel;

        private PerspectiveActionListener(CoreViewTreeViewModel coreViewTreeViewModel) {
            this.coreViewTreeViewModel = coreViewTreeViewModel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CorePerspective perspective = (CorePerspective)CoreViewFrame.this.perspectiveChooser.getSelectedItem();
            this.coreViewTreeViewModel.setPerspective(perspective);
            CoreViewFrame.this.viewTable.setTreeViewModel(this.coreViewTreeViewModel);
        }
    }
}

