/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SystemCollections;
import pcgen.core.npcgen.EqmodItem;
import pcgen.core.npcgen.EqmodTable;
import pcgen.core.npcgen.EqmodTableEntry;
import pcgen.core.npcgen.EquipmentItem;
import pcgen.core.npcgen.EquipmentTable;
import pcgen.core.npcgen.EquipmentTableEntry;
import pcgen.core.npcgen.Table;
import pcgen.core.npcgen.TableEntry;
import pcgen.core.npcgen.TreasureGenerator;
import pcgen.util.Logging;

public class EquipmentTableParser {
    private SAXParser theParser;
    private GameMode theMode;
    private HashMap<EquipmentItem, String> theLinkTable = new HashMap();
    private HashMap<EqmodItem, String> theEqmodLinkTable = new HashMap();

    public EquipmentTableParser(GameMode aMode) throws ParserConfigurationException, SAXException {
        this.theMode = aMode;
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(true);
        this.theParser = parserFactory.newSAXParser();
    }

    public List<EquipmentTable> parse(File[] aFileList) throws SAXException, IOException {
        ArrayList<EquipmentTable> ret = new ArrayList<EquipmentTable>();
        for (File fileName : aFileList) {
            try {
                this.theParser.parse(fileName, (DefaultHandler)new EquipmentTableHandler(this.theMode, ret));
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        for (EquipmentItem item : this.theLinkTable.keySet()) {
            EquipmentTable table = EquipmentTable.get(this.theLinkTable.get(item));
            if (table == null) {
                Logging.errorPrint("Could not find linked table " + this.theLinkTable.get(item) + " for " + item);
                continue;
            }
            item.setLookup(table);
        }
        for (EqmodItem item : this.theEqmodLinkTable.keySet()) {
            EqmodTable table = EqmodTable.get(this.theEqmodLinkTable.get(item));
            if (table == null) {
                Logging.errorPrint("Could not find linked table " + this.theEqmodLinkTable.get(item) + " for " + item);
                continue;
            }
            item.setLookup(table);
        }
        return ret;
    }

    class EquipmentTableHandler
    extends DefaultHandler {
        private List<EquipmentTable> theList;
        private GameMode theGameMode = null;
        private boolean theValidFlag = false;
        private ParserState theState = ParserState.INIT;
        private Table theCurrentData = null;
        private TableEntry theCurrentEntry = null;
        private EquipmentItem theCurrentItem = null;

        public EquipmentTableHandler(GameMode aMode, List<EquipmentTable> aList) {
            this.theGameMode = aMode;
            this.theList = aList;
        }

        @Override
        public void startElement(String uri, String localName, String aName, Attributes anAttrs) throws SAXException {
            if (this.theState == ParserState.INIT && "equipment_tables".equals(aName)) {
                if (anAttrs != null) {
                    String gm = anAttrs.getValue("game_mode");
                    if (!SystemCollections.getGameModeNamed(gm).equals(this.theGameMode)) {
                        throw new IllegalArgumentException("Incorrect game mode");
                    }
                    this.theValidFlag = true;
                }
                return;
            }
            if (!this.theValidFlag) {
                throw new SAXException("Generators.Equipment.InvalidFileFormat");
            }
            if (this.theState == ParserState.INIT) {
                if ("table".equals(aName)) {
                    if (anAttrs != null) {
                        String name = anAttrs.getValue("name");
                        String id = anAttrs.getValue("id");
                        EquipmentTable table = EquipmentTable.get(id);
                        if (table == null) {
                            table = new EquipmentTable(id);
                            table.setName(name);
                            EquipmentTable.addTable(table);
                            this.theList.add(table);
                        }
                        this.theCurrentData = table;
                        this.theState = ParserState.EQTABLEDATA;
                    }
                } else if ("eqmod_table".equals(aName) && anAttrs != null) {
                    String name = anAttrs.getValue("name");
                    String id = anAttrs.getValue("id");
                    EqmodTable table = EqmodTable.get(id);
                    if (table == null) {
                        table = new EqmodTable(id);
                        table.setName(name);
                        EqmodTable.addTable(table);
                    }
                    this.theCurrentData = table;
                    this.theState = ParserState.EQMODTABLEDATA;
                }
            } else if (this.theState == ParserState.EQTABLEDATA) {
                String entryName;
                if ("entry".equals(aName) && anAttrs != null && (entryName = anAttrs.getValue("name")) != null) {
                    EquipmentTableEntry te = new EquipmentTableEntry(entryName);
                    this.theCurrentEntry = te;
                    this.theState = ParserState.ENTRYDATA;
                    int weight = this.getWeight(anAttrs);
                    this.theCurrentData.add(weight, te);
                }
            } else if (this.theState == ParserState.EQMODTABLEDATA) {
                String entryName;
                if ("entry".equals(aName) && anAttrs != null && (entryName = anAttrs.getValue("name")) != null) {
                    EqmodTableEntry te = new EqmodTableEntry(entryName);
                    this.theCurrentEntry = te;
                    this.theState = ParserState.ENTRYDATA;
                    int weight = this.getWeight(anAttrs);
                    this.theCurrentData.add(weight, te);
                }
            } else if (this.theState == ParserState.ENTRYDATA) {
                if ("equipment".equals(aName)) {
                    if (anAttrs != null) {
                        String linkLoc;
                        this.theCurrentItem = new EquipmentItem();
                        String rolls = anAttrs.getValue("rolls");
                        if (rolls != null) {
                            this.theCurrentItem.setTimes(rolls);
                        }
                        if ((linkLoc = anAttrs.getValue("link")) != null) {
                            EquipmentTable table = EquipmentTable.get(linkLoc);
                            if (table == null) {
                                EquipmentTableParser.this.theLinkTable.put(this.theCurrentItem, linkLoc);
                            } else {
                                this.theCurrentItem.setLookup(table);
                            }
                        } else {
                            String choiceStr = anAttrs.getValue("choose");
                            if (choiceStr != null) {
                                String[] choices = choiceStr.split("\\|");
                                this.theCurrentItem.setVariableEquipment(anAttrs.getValue("value"), Arrays.asList(choices));
                            } else {
                                String val = anAttrs.getValue("value");
                                if (val != null) {
                                    Equipment eq = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, val);
                                    if (eq == null) {
                                        Logging.errorPrint("Could not find equipment named: " + val);
                                    }
                                    this.theCurrentItem.setEquipment(eq);
                                }
                                String qty = anAttrs.getValue("quantity");
                                this.theCurrentItem.setQuantity(qty);
                            }
                        }
                        this.theCurrentEntry.addData(this.theCurrentItem);
                    }
                    this.theState = ParserState.EQUIPMENT;
                }
            } else if (this.theState == ParserState.EQUIPMENT && "eqmod".equals(aName) && anAttrs != null) {
                EqmodItem eqmodItem = new EqmodItem();
                String link = anAttrs.getValue("link");
                if (link != null) {
                    EqmodTable table = EqmodTable.get(link);
                    if (table == null) {
                        EquipmentTableParser.this.theEqmodLinkTable.put(eqmodItem, link);
                    } else {
                        eqmodItem.setLookup(table);
                    }
                } else {
                    String val;
                    String rollStr = anAttrs.getValue("roll");
                    if (rollStr != null) {
                        eqmodItem.setRollString(rollStr);
                    }
                    if ((val = anAttrs.getValue("value")) != null) {
                        eqmodItem.setEqmod(val);
                    }
                }
                this.theCurrentItem.addEqMod(eqmodItem);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("equipment_tables".equals(qName)) {
                this.theState = ParserState.INIT;
            } else if ("table".equals(qName)) {
                this.theState = ParserState.INIT;
                TreasureGenerator.addTable(this.theGameMode, (EquipmentTable)this.theCurrentData);
            } else if ("eqmod_table".equals(qName)) {
                this.theState = ParserState.INIT;
            } else if ("entry".equals(qName)) {
                if (this.theCurrentData instanceof EquipmentTable) {
                    this.theState = ParserState.EQTABLEDATA;
                } else if (this.theCurrentData instanceof EqmodTable) {
                    this.theState = ParserState.EQMODTABLEDATA;
                }
            } else if ("equipment".equals(qName)) {
                this.theState = ParserState.ENTRYDATA;
            } else if ("eqmod".equals(qName)) {
                // empty if block
            }
        }

        private int getWeight(Attributes anAttrs) {
            int weight = 1;
            String wtStr = anAttrs.getValue("weight");
            if (wtStr != null) {
                weight = Integer.parseInt(wtStr.trim());
            }
            return weight;
        }
    }

    private static enum ParserState {
        INIT,
        EQTABLEDATA,
        EQMODTABLEDATA,
        ENTRYDATA,
        EQUIPMENT;

    }
}

