/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.commons.lang.math.Fraction;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.Nature;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PCCheck;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.QualifiedName;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.VisionDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.MovementToken;
import pcgen.util.enumeration.AttackType;

public class PlayerCharacterOutput {
    private PlayerCharacter pc;
    private CharacterDisplay display;

    public PlayerCharacterOutput(PlayerCharacter pc) {
        this.pc = pc;
        this.display = pc == null ? null : pc.getDisplay();
    }

    public String getAC() {
        return Integer.toString(this.display.getACTotal());
    }

    public String getACFlatFooted() {
        return Integer.toString(this.display.flatfootedAC());
    }

    public String getACTouch() {
        return Integer.toString(this.display.touchAC());
    }

    public String getAlignmentLong() {
        PCAlignment pcAlignment = this.display.getPCAlignment();
        return pcAlignment == null ? "" : pcAlignment.getDisplayName();
    }

    public String getAlignmentShort() {
        PCAlignment pcAlignment = this.display.getPCAlignment();
        return pcAlignment == null ? "" : pcAlignment.getKeyName();
    }

    public String getBAB() {
        return Integer.toString(this.pc.baseAttackBonus());
    }

    public String getCR() {
        Integer calcCR = this.display.calcCR();
        float cr = calcCR == null ? -1.0f : (float)calcCR.intValue();
        String retString = "";
        String crAsString = Float.toString(cr);
        String decimalPlaceValue = crAsString.substring(crAsString.length() - 2);
        if (cr > 0.0f && cr < 1.0f) {
            Fraction fraction = Fraction.getFraction(cr);
            int denominator = fraction.getDenominator();
            int numerator = fraction.getNumerator();
            retString = numerator + "/" + denominator;
        } else if (cr >= 1.0f || cr == 0.0f) {
            int newCr = -99;
            if (decimalPlaceValue.equals(".0")) {
                newCr = (int)cr;
            }
            retString = newCr > -99 ? retString + newCr : retString + cr;
        }
        return retString;
    }

    public String getClasses() {
        StringBuilder sb = new StringBuilder();
        for (PCClass mClass : this.display.getClassSet()) {
            sb.append(mClass.getDisplayName()).append(this.display.getLevel(mClass)).append(" ");
        }
        return sb.toString();
    }

    public String getRaceType() {
        return this.display.getRaceType();
    }

    public String getDeity() {
        Deity deity = this.display.getDeity();
        if (deity != null) {
            return deity.getOutputName();
        }
        return null;
    }

    public String getDomainName(Domain domain) {
        return domain.getDisplayName();
    }

    public String getEquipmentList() {
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        for (Equipment eq : this.pc.getEquipmentListInOutputOrder()) {
            if (!firstLine) {
                sb.append(", ");
            }
            firstLine = false;
            DecimalFormat formater = new DecimalFormat();
            formater.setMaximumFractionDigits(1);
            formater.setMinimumFractionDigits(0);
            sb.append(formater.format(eq.getQty())).append(" ").append(eq.getName());
        }
        return sb.toString();
    }

    public String getExportToken(String token) {
        try {
            StringWriter retWriter = new StringWriter();
            BufferedWriter bufWriter = new BufferedWriter(retWriter);
            ExportHandler export = new ExportHandler(new File(""));
            export.replaceTokenSkipMath(this.pc, token, bufWriter);
            retWriter.flush();
            try {
                bufWriter.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            return retWriter.toString();
        }
        catch (Exception e) {
            System.out.println("Failure fetching token: " + token);
            return "";
        }
    }

    public String getFeatList() {
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        for (CNAbility cna : this.pc.getCNAbilities(AbilityCategory.FEAT, Nature.NORMAL)) {
            if (!firstLine) {
                sb.append(", ");
            }
            firstLine = false;
            sb.append(QualifiedName.qualifiedName(this.pc, Collections.singletonList(cna)));
        }
        return sb.toString();
    }

    public String getGender() {
        return this.display.getGenderObject().toString();
    }

    public String getHitDice() {
        return this.getExportToken("HITDICE");
    }

    public String getHitPoints() {
        return Integer.toString(this.pc.hitPoints());
    }

    public String getInitMiscMod() {
        PCStat dex = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "DEX");
        int statMod = this.pc.getStatModFor(dex);
        int miscMod = this.display.initiativeMod() - statMod;
        return "+" + miscMod;
    }

    public String getInitStatMod() {
        PCStat dex = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "DEX");
        int statMod = this.pc.getStatModFor(dex);
        return "+" + statMod;
    }

    public String getInitTotal() {
        return "+" + this.display.initiativeMod();
    }

    public String getMeleeTotal() {
        int tohitBonus = (int)this.pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)this.pc.getTotalBonusTo("TOHIT", "TYPE.MELEE") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT.MELEE");
        return this.pc.getAttackString(AttackType.MELEE, tohitBonus);
    }

    public String getName() {
        return this.display.getName();
    }

    public String getRaceName() {
        return this.display.getRace().getDisplayName();
    }

    public String getRangedTotal() {
        int tohitBonus = (int)this.pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)this.pc.getTotalBonusTo("TOHIT", "TYPE.RANGED") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT.RANGED");
        return this.pc.getAttackString(AttackType.MELEE, tohitBonus);
    }

    public String getRegion() {
        return this.display.getRegionString();
    }

    public String getSaveFort() {
        return "+" + this.pc.getTotalCheck(Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCCheck.class, "FORT"));
    }

    public String getSaveRef() {
        return "+" + this.pc.getTotalCheck(Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCCheck.class, "REF"));
    }

    public String getSaveWill() {
        return "+" + this.pc.getTotalCheck(Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCCheck.class, "WILL"));
    }

    public String getSize() {
        return this.display.getSize();
    }

    public String getSpecialAbilities() {
        return StringUtil.join(this.pc.getSpecialAbilityTimesList(), (String)", ");
    }

    public String getSpeed() {
        return MovementToken.getMovementToken(this.display);
    }

    public String getStat(PCStat stat) {
        return Integer.toString(this.pc.getTotalStatFor(stat));
    }

    public String getStatMod(PCStat stat) {
        int returnValue = this.pc.getStatModFor(stat);
        return returnValue < 0 ? Integer.toString(returnValue) : "+" + returnValue;
    }

    public String getVision() {
        return VisionDisplay.getVision(this.display);
    }

    public String getWeaponToken(int weaponNo, String Token2) {
        return this.getExportToken("WEAPON." + weaponNo + "." + Token2);
    }

    public String getWeaponCritMult(int weaponNo) {
        return this.getWeaponToken(weaponNo, "MULT");
    }

    public String getWeaponCritRange(int weaponNo) {
        return this.getWeaponToken(weaponNo, "CRIT");
    }

    public String getWeaponDamage(int weaponNo) {
        return this.getWeaponToken(weaponNo, "DAMAGE");
    }

    public String getWeaponHand(Equipment eq) {
        int end;
        String location = eq.getLocation().getString();
        int start = location.indexOf(40) + 1;
        if (start > 0 && (end = location.indexOf(41, start)) > 0) {
            location = location.substring(start, end);
        }
        return location;
    }

    public String getWeaponName(Equipment eq) {
        return eq.getOutputName() + eq.getAppliedName();
    }

    public String getWeaponRange(Equipment eq) {
        return eq.getRange(this.pc).toString() + Globals.getGameModeUnitSet().getDistanceUnit();
    }

    public String getWeaponSize(Equipment eq) {
        return eq.getSize();
    }

    public String getWeaponSpecialProperties(Equipment eq) {
        return eq.getSpecialProperties(this.pc);
    }

    public String getWeaponToHit(int weaponNo) {
        return this.getWeaponToken(weaponNo, "TOTALHIT");
    }

    public String getWeaponType(Equipment eq) {
        String types = this.getWeaponType(eq, true);
        if (eq.isDouble()) {
            types = types + '/' + this.getWeaponType(eq, false);
        }
        return types;
    }

    public String getWeaponType(Equipment eq, boolean primary) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer aTok = new StringTokenizer(SettingsHandler.getGame().getWeaponTypes(), "|", false);
        while (aTok.countTokens() >= 2) {
            String aType = aTok.nextToken();
            String abbrev = aTok.nextToken();
            if (!eq.isType(aType, true)) continue;
            sb.append(abbrev);
        }
        return sb.toString();
    }

    public String getUnarmedAttack() {
        return this.getExportToken("WEAPONH.TOTALHIT");
    }

    public String getUnarmedDamage() {
        return this.getExportToken("WEAPONH.DAMAGE");
    }

    public String getUnarmedCritRange() {
        return this.getExportToken("WEAPONH.CRIT");
    }

    public String getUnarmedCritMult() {
        return this.getExportToken("WEAPONH.MULT");
    }

    public Collection<PCStat> getUnmodifiableStatList() {
        return this.display.getStatSet();
    }
}

