/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.search;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.search.CompletionPublisher;
import javax.swing.Icon;

public interface Completion {
    public String getReplacementText();

    public Icon getIcon();

    public String getDisplayString();

    public Object getAdditionalInfo();

    public String getCategory();

    public int getRank();

    public boolean isAutoInsertable();

    public int getCaretPosition();

    public static abstract class AbstractBuilder<C extends Completion, B extends AbstractBuilder<C, B>> {
        protected String replacementText;
        protected String displayString;
        protected Icon icon;
        protected Object additionalInfo;
        protected String category;
        protected int rank;
        protected boolean autoInsertable = true;
        protected int caretPosition = -1;

        public B replacementText(String text, Object ... args) {
            Preconditions.checkNotNull(text, "The %s must not be null.", "replacement text");
            this.replacementText = Strings.get(text, args);
            return (B)this;
        }

        public B icon(Icon icon) {
            this.icon = icon;
            return (B)this;
        }

        public B displayString(String text, Object ... args) {
            Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "display string");
            this.displayString = Strings.get(text, args);
            return (B)this;
        }

        public B additionalInfo(Object info) {
            this.additionalInfo = info;
            return (B)this;
        }

        public B additionalInfo(String info, Object ... args) {
            this.additionalInfo = Strings.get(info, args);
            return (B)this;
        }

        public B category(String category) {
            this.category = category;
            return (B)this;
        }

        public B rank(int rank) {
            this.rank = rank;
            return (B)this;
        }

        public B autoInsertable(boolean b) {
            this.autoInsertable = b;
            return (B)this;
        }

        public B caretPosition(int caretPosition) {
            this.caretPosition = caretPosition;
            return (B)this;
        }

        public void publish(CompletionPublisher publisher) {
            publisher.publish(new Completion[]{this.build()});
        }

        public abstract C build();
    }

    public static final class Builder
    extends AbstractBuilder<DefaultCompletion, Builder> {
        @Override
        public DefaultCompletion build() {
            return new DefaultCompletion(this.replacementText, this.displayString, this.icon, this.additionalInfo, this.category, this.rank, this.autoInsertable, this.caretPosition);
        }
    }

    public static class DefaultCompletion
    implements Completion {
        private final String replacementText;
        private final String displayString;
        private final Icon icon;
        private final Object additionalInfo;
        private final String category;
        private final int rank;
        private final boolean autoInsertable;
        private final int caretPosition;

        DefaultCompletion(String replacementText, String displayString, Icon icon, Object additionalInfo, String category, int rank, boolean autoInsertable, int caretPosition) {
            this.replacementText = replacementText;
            this.category = category;
            this.displayString = displayString;
            this.icon = icon;
            this.rank = rank;
            this.additionalInfo = additionalInfo;
            this.autoInsertable = autoInsertable;
            this.caretPosition = caretPosition;
        }

        @Override
        public String getReplacementText() {
            return this.replacementText;
        }

        @Override
        public String getDisplayString() {
            return this.displayString != null ? this.displayString : this.replacementText;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Object getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public int getRank() {
            return this.rank;
        }

        @Override
        public boolean isAutoInsertable() {
            return this.autoInsertable;
        }

        @Override
        public int getCaretPosition() {
            return this.caretPosition;
        }
    }
}

