/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.navigation.views;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.layout.factories.CC;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.navigation.internal.FocusTrackerSupport;
import com.jgoodies.navigation.views.AbstractViewModel;
import com.jgoodies.navigation.views.Activatable;
import com.jgoodies.navigation.views.FocusTracker;
import com.jgoodies.navigation.views.View;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractFrame<V extends View, M extends AbstractViewModel<V>>
extends JPanel
implements FocusTracker {
    protected final M model;

    public AbstractFrame(M model) {
        super(new FormLayout("fill:0:grow", "f:d:g"));
        this.model = (AbstractViewModel)Preconditions.checkNotNull(model, "The %s must not be null.", "model");
        this.setOpaque(false);
        this.initEventHandling();
        this.replaceContent(null, (View)this.getSelectedView());
    }

    private void initEventHandling() {
        ((Bean)this.model).addPropertyChangeListener(this::onModelPropertyChange);
        FocusTrackerSupport.trackFocusFor(this);
    }

    public final M getModel() {
        return this.model;
    }

    @Override
    public final void requestInitialFocus() {
        if (this.getSelectedView() instanceof FocusTracker) {
            ((FocusTracker)this.getSelectedView()).requestInitialFocus();
        }
    }

    @Override
    public final void setMostRecentFocusOwner(Component newFocusOwner) {
        V view = this.getSelectedView();
        if (view instanceof FocusTracker) {
            ((FocusTracker)view).setMostRecentFocusOwner(newFocusOwner);
        }
    }

    private V getSelectedView() {
        return ((AbstractViewModel)this.getModel()).getSelectedView();
    }

    private void replaceContent(View oldView, View newView) {
        if (oldView instanceof Activatable) {
            ((Activatable)((Object)oldView)).onDeactivating();
        }
        this.removeAll();
        if (newView instanceof Activatable) {
            ((Activatable)((Object)newView)).onActivating();
        }
        if (newView != null) {
            JComponent panel = newView.getPanel();
            this.add((Component)panel, CC.xy(1, 1));
            if (FocusTrackerSupport.isInitialFocusRequested(panel)) {
                this.requestInitialFocus();
            }
        }
        if (this.contentChangesRequireContainerValidation()) {
            this.revalidate();
        } else {
            this.validate();
        }
        this.repaint();
        if (newView instanceof Activatable) {
            ((Activatable)((Object)newView)).onActivated();
        }
    }

    protected abstract boolean contentChangesRequireContainerValidation();

    protected void onModelPropertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        switch (propertyName) {
            case "selectedView": {
                this.replaceContent((View)oldValue, (View)newValue);
                break;
            }
        }
        this.firePropertyChange(propertyName, oldValue, newValue);
    }
}

