/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.DateUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGFormattedTextField;
import com.jgoodies.components.JGTextArea;
import com.jgoodies.components.JGTextField;
import com.jgoodies.dialogs.basics.ReturnValue;
import com.jgoodies.dialogs.basics.internal.JSDLBasicsUtils;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.internal.AbstractPaneBuilder;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.Dimension;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public final class InputPaneBuilder
extends AbstractPaneBuilder<TaskPane, InputPaneBuilder> {
    private final TaskPaneBuilder builder = new TaskPaneBuilder();
    private String supplementalInstructionText = null;
    private JComponent inputComponent = null;
    private boolean contentGrowsHorizontally = true;
    private Boolean contentGrowsVertically = null;

    public InputPaneBuilder() {
        this.builder.internalPreferredWidth(PreferredWidth.MEDIUM);
    }

    public InputPaneBuilder mainInstructionText(String text, Object ... args) {
        this.builder.mainInstructionText(text, args);
        return this;
    }

    public InputPaneBuilder supplementalInstructionText(String text, Object ... args) {
        this.supplementalInstructionText = Strings.get(text, args);
        Preconditions.checkNotBlank(this.supplementalInstructionText, "The %s must not be null, empty, or whitespace.", "supplemental instruction");
        return this;
    }

    protected InputPaneBuilder inputComponent(JComponent component) {
        this.inputComponent = component;
        return this;
    }

    public InputPaneBuilder verificationText(String text, Object ... args) {
        this.builder.verificationText(text, args);
        return this;
    }

    public InputPaneBuilder verificationSelected(boolean b) {
        this.builder.verificationSelected(b);
        return this;
    }

    public InputPaneBuilder verification(Verification verification) {
        this.builder.verification(verification);
        return this;
    }

    public InputPaneBuilder preferredWidth(int customValue) {
        this.builder.preferredWidth(customValue);
        return this;
    }

    public InputPaneBuilder preferredWidth(PreferredWidth standardizedValue) {
        this.builder.preferredWidth(standardizedValue);
        return this;
    }

    public InputPaneBuilder aspectRatio(double customValue) {
        this.builder.aspectRatio(customValue);
        return this;
    }

    public InputPaneBuilder aspectRatio(AspectRatio standardizedValue) {
        this.builder.aspectRatio(standardizedValue);
        return this;
    }

    @Override
    public InputPaneBuilder resizable(boolean resizable) {
        return (InputPaneBuilder)super.resizable(resizable);
    }

    @Override
    public InputPaneBuilder minimumSize(Dimension minimumSize) {
        return (InputPaneBuilder)super.minimumSize(minimumSize);
    }

    @Override
    public InputPaneBuilder minimumSize(int minimumWidth, int minimumHeight) {
        return (InputPaneBuilder)super.minimumSize(minimumWidth, minimumHeight);
    }

    @Override
    public InputPaneBuilder maximumSize(Dimension minimumSize) {
        return (InputPaneBuilder)super.maximumSize(minimumSize);
    }

    @Override
    public InputPaneBuilder maximumSize(int maximumWidth, int maximumHeight) {
        return (InputPaneBuilder)super.maximumSize(maximumWidth, maximumHeight);
    }

    public InputPaneBuilder contentGrowsHorizontally(boolean grows) {
        this.contentGrowsHorizontally = grows;
        return this;
    }

    public InputPaneBuilder contentGrowsVertically(boolean grows) {
        this.contentGrowsVertically = grows;
        return this;
    }

    public TaskPane build() {
        InputPaneBuilder.checkMainInstructionNotBlank(this.builder.build().getMainInstructionText());
        Preconditions.checkNotNull(this.inputComponent, "The %s must not be null.", "input component");
        this.builder.mainInstructionLabelsContent(true);
        if (this.supplementalInstructionText == null) {
            this.builder.marginContentTop(0);
        }
        this.builder.content(this.buildContent());
        this.builder.commitCommands(CommandValue.OK, CommandValue.CANCEL);
        this.checkStyle();
        return this.builder.build();
    }

    private JComponent buildContent() {
        boolean hasInstruction = this.supplementalInstructionText != null;
        String instructionGap = hasInstruction ? "$pg" : "0";
        JTextComponent instruction = JGComponentFactory.getCurrent().createStaticText(this.supplementalInstructionText, new Object[0]);
        String contentColumn = this.contentGrowsHorizontally ? "fill:default:grow" : "pref";
        String contentRow = this.contentGrowsVertically() ? "fill:default:grow" : "pref, 0:grow";
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns(contentColumn, new Object[0])).rows("p, %1$s, %2$s", instructionGap, contentRow)).add(hasInstruction, instruction).xy(1, 1)).add(this.inputComponent).xy(1, 3)).build();
    }

    private boolean contentGrowsVertically() {
        if (this.contentGrowsVertically != null) {
            return this.contentGrowsVertically;
        }
        return this.inputComponent instanceof JScrollPane;
    }

    public boolean showInputDialogReturnCancelled(JComponent inputComponent) {
        this.inputComponent(inputComponent);
        return this.showDialogReturnCancelled(this.build());
    }

    public boolean showInputDialogReturnProceed(JComponent inputComponent) {
        this.inputComponent(inputComponent);
        return this.showDialogReturnProceed(this.build());
    }

    public ReturnValue<Date> showDateInputDialog(Date initialValue) {
        JGFormattedTextField dateField = JGComponentFactory.getCurrent().createDateField();
        dateField.setValue(initialValue);
        boolean cancelled = this.showInputDialogReturnCancelled(dateField);
        return new ReturnValue<Date>(cancelled, (Date)dateField.getValue());
    }

    public ReturnValue<LocalDate> showLocalDateInputDialog(LocalDate initialValue) {
        JGFormattedTextField dateField = JGComponentFactory.getCurrent().createDateField();
        dateField.setValue(DateUtils.toDate(initialValue));
        boolean cancelled = this.showInputDialogReturnCancelled(dateField);
        return new ReturnValue<LocalDate>(cancelled, DateUtils.toLocalDate((Date)dateField.getValue()));
    }

    public String showSingleLineTextInputDialog(String initialText) {
        return this.showSingleLineTextInputDialog(initialText, -1);
    }

    public String showSingleLineTextInputDialog(String initialText, int columns) {
        boolean proceed;
        JGTextField textField = JGComponentFactory.getCurrent().createTextField(initialText);
        if (columns != -1) {
            textField.setColumns(columns);
            this.contentGrowsHorizontally(false);
            this.preferredWidth(PreferredWidth.NONE);
        }
        if (!this.resizableSet()) {
            this.resizable(false);
        }
        return (proceed = this.showInputDialogReturnProceed(textField)) ? textField.getText() : null;
    }

    public String showSingleLineTextInputDialog(String initialText, String prompt) {
        JGTextField textField = JGComponentFactory.getCurrent().createTextField(initialText);
        textField.setPrompt(prompt);
        textField.setPromptVisibleWhenFocused(true);
        this.resizable(false);
        boolean proceed = this.showInputDialogReturnProceed(textField);
        return proceed ? textField.getText() : null;
    }

    public String showMultiLineTextInputDialog(String initialText) {
        return this.showMultiLineTextInputDialog(initialText, -1, 5);
    }

    public String showMultiLineTextInputDialog(String initialText, int columns, int rows) {
        JGTextArea textArea = JGComponentFactory.getCurrent().createTextArea(initialText);
        if (columns != -1) {
            textArea.setColumns(columns);
            this.contentGrowsHorizontally(false);
            this.preferredWidth(PreferredWidth.NONE);
        }
        textArea.setRows(rows);
        boolean proceed = this.showInputDialogReturnProceed(new JScrollPane(textArea));
        return proceed ? textArea.getText() : null;
    }

    public <V> V showButtonOptionDialog(List<V> options) {
        return this.showButtonOptionDialog((V[])options.toArray(), (V)null);
    }

    public <V> V showButtonOptionDialog(V ... options) {
        return this.showButtonOptionDialog(options, (V)null);
    }

    public <V> V showButtonOptionDialog(V[] options, V defaultOption) {
        Object[] optionsAndCancel = new Object[options.length + 1];
        System.arraycopy(options, 0, optionsAndCancel, 0, options.length);
        optionsAndCancel[options.length] = CommandValue.CANCEL;
        if (defaultOption == null) {
            defaultOption = options[0];
        }
        this.builder.messageType(MessageType.QUESTION).contentText(this.supplementalInstructionText, new Object[0]).commitCommands(optionsAndCancel).defaultCommand(defaultOption);
        return (V)this.showDialogReturnCommitValueOrNullIfCancelled(this.builder.build());
    }

    public Object showCommandLinkOptionDialog(List<Action> options) {
        return this.showCommandLinkOptionDialog(options.toArray(new Action[options.size()]), (Action)null);
    }

    public Object showCommandLinkOptionDialog(Action ... options) {
        return this.showCommandLinkOptionDialog(options, (Action)null);
    }

    public Object showCommandLinkOptionDialog(Action[] options, Action defaultOption) {
        if (defaultOption == null) {
            defaultOption = options[0];
        }
        this.builder.messageType(MessageType.QUESTION).contentText(this.supplementalInstructionText, new Object[0]).commitCommands(CommandValue.CANCEL);
        for (Action option : options) {
            this.builder.addCommandLink(option, false);
        }
        this.builder.defaultCommand(defaultOption);
        return this.showDialogReturnCommitValueOrNullIfCancelled(this.builder.build());
    }

    public <V> V showRadioButtonOptionDialog(List<V> options) {
        return this.showRadioButtonOptionDialog((V[])options.toArray(), (V)null);
    }

    public <V> V showRadioButtonOptionDialog(V ... options) {
        return this.showRadioButtonOptionDialog(options, (V)null);
    }

    public <V> V showRadioButtonOptionDialog(V[] options, V defaultOption) {
        if (defaultOption == null) {
            defaultOption = options[0];
        }
        this.builder.messageType(MessageType.QUESTION).contentText(this.supplementalInstructionText, new Object[0]).commitCommands(CommandValue.OK, CommandValue.CANCEL);
        for (V option : options) {
            this.builder.addRadioButton(option, option.toString());
        }
        TaskPane pane = this.builder.build();
        pane.setRadioValue(defaultOption);
        boolean proceed = this.showDialogReturnProceed(pane);
        return (V)(proceed ? pane.getRadioValue() : null);
    }

    @Override
    protected String getTitle() {
        if (this.title == null) {
            this.title = JSDLBasicsUtils.getApplicationTitle();
        }
        return this.title;
    }

    private void checkStyle() {
        InputPaneBuilder.checkMainInstructionNotBlank(this.builder.build().getMainInstructionText());
        InputPaneBuilder.checkSupplementalInstructionNullOrNotBlank(this.builder.build().getContentText());
    }

    private static void checkMainInstructionNotBlank(String mainInstruction) {
        Preconditions.checkNotBlank(mainInstruction, "The %s must not be null, empty, or whitespace.", "main instruction");
    }

    private static void checkSupplementalInstructionNullOrNotBlank(String supplementalInstruction) {
        if (supplementalInstruction != null) {
            Preconditions.checkNotBlank(supplementalInstruction, "The supplemental instruction must not be empty, or whitespace.");
        }
        JSDLCoreStyleChecker.getInstance().checkSupplementalInstructionIsTrimmed(supplementalInstruction);
    }
}

