/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.domain.contact;

import com.jgoodies.app.persistency.Entity;
import com.jgoodies.common.base.Strings;
import java.util.Objects;

public class ContactData
extends Entity {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_VALUE = "value";
    private ContactType type;
    private String label = "";
    private String value = "";

    public ContactType getType() {
        return this.type;
    }

    public void setType(ContactType newValue) {
        this.type = newValue;
        this.firePropertyChange(PROPERTY_TYPE, (Object)this.type, (Object)this.type);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String newValue) {
        this.label = newValue;
        this.firePropertyChange(PROPERTY_LABEL, this.label, this.label);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
        this.firePropertyChange(PROPERTY_VALUE, this.value, this.value);
    }

    public boolean isEmpty() {
        return Strings.isBlank(this.value);
    }

    public boolean isEmail() {
        return this.getType() == ContactType.EMAIL;
    }

    public boolean isWeb() {
        return this.getType() == ContactType.WEB;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.label, this.type, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactData other = (ContactData)obj;
        return Objects.equals(this.label, other.label) && this.type == other.type && Objects.equals(this.value, other.value);
    }

    public static final class Builder {
        private final ContactData target = new ContactData();

        public Builder type(ContactType type) {
            this.target.setType(type);
            return this;
        }

        public Builder label(String value) {
            this.target.setLabel(value);
            return this;
        }

        public Builder value(String value) {
            this.target.setValue(value);
            return this;
        }

        public ContactData build() {
            return this.target;
        }

        public Builder phone() {
            this.target.setType(ContactType.PHONE);
            return this;
        }

        public Builder email() {
            this.target.setType(ContactType.EMAIL);
            return this;
        }

        public Builder web() {
            this.target.setType(ContactType.WEB);
            return this;
        }

        public Builder facebook() {
            this.target.setType(ContactType.FACEBOOK);
            return this;
        }

        public Builder phone(String value) {
            return this.phone().label("Tel").value(value);
        }

        public Builder workPhone(String value) {
            return this.phone().label("Arbeit").value(value);
        }

        public Builder privatePhone(String value) {
            return this.phone().label("Privat").value(value);
        }

        public Builder mobile(String value) {
            return this.phone().label("Mobil").value(value);
        }

        public Builder fax(String value) {
            return this.phone().label("Fax").value(value);
        }

        public Builder email(String value) {
            return this.email().label("E-Mail").value(value);
        }

        public Builder workEmail(String value) {
            return this.email().label("Arbeit").value(value);
        }

        public Builder web(String value) {
            return this.web().label("Web").value(value);
        }

        public Builder facebook(String value) {
            return this.facebook().label("Facebook").value(value);
        }
    }

    public static enum ContactType {
        PHONE,
        EMAIL,
        WEB,
        FACEBOOK;

    }
}

