/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.SourceLookup;
import org.spockframework.compiler.SpecAnnotator;
import org.spockframework.compiler.SpecParser;
import org.spockframework.compiler.SpecRewriter;
import org.spockframework.compiler.model.Spec;
import org.spockframework.util.VersionChecker;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class SpockTransform
implements ASTTransformation {
    public SpockTransform() {
        VersionChecker.checkGroovyVersion("compiler plugin");
    }

    public void visit(ASTNode[] nodes, SourceUnit sourceUnit) {
        new Impl().visit(nodes, sourceUnit);
    }

    private static class Impl {
        static final AstNodeCache nodeCache = new AstNodeCache();

        private Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void visit(ASTNode[] nodes, SourceUnit sourceUnit) {
            ErrorReporter errorReporter = new ErrorReporter(sourceUnit);
            SourceLookup sourceLookup = new SourceLookup(sourceUnit);
            try {
                ModuleNode module = (ModuleNode)nodes[0];
                List classes = module.getClasses();
                for (ClassNode clazz : classes) {
                    if (!this.isSpec(clazz)) continue;
                    this.processSpec(clazz, errorReporter, sourceLookup);
                }
            }
            finally {
                sourceLookup.close();
            }
        }

        boolean isSpec(ClassNode clazz) {
            return clazz.isDerivedFrom(Impl.nodeCache.Specification);
        }

        void processSpec(ClassNode clazz, ErrorReporter errorReporter, SourceLookup sourceLookup) {
            try {
                Spec spec = new SpecParser(errorReporter).build(clazz);
                spec.accept(new SpecRewriter(nodeCache, sourceLookup, errorReporter));
                spec.accept(new SpecAnnotator(nodeCache));
            }
            catch (Exception e) {
                errorReporter.error("Unexpected error during compilation of spec '%s'. Maybe you have used invalid Spock syntax? Anyway, please file a bug report at http://issues.spockframework.org.", e, clazz.getName());
            }
        }
    }
}

