/*
 * Decompiled with CFR 0.152.
 */
package jrm.batch;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.profile.Profile;
import jrm.profile.fix.Fix;
import jrm.profile.scan.Scan;
import jrm.ui.basic.ResultColUpdater;
import jrm.ui.basic.SDRTableModel;
import jrm.ui.progress.Progress;
import jrm.ui.progress.ProgressHandler;
import one.util.streamex.StreamEx;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.io.FilenameUtils;

public class DirUpdater {
    public DirUpdater(List<SDRTableModel.SrcDstResult> sdrl, Progress progress, List<File> srcdirs, ResultColUpdater result, boolean dryrun) {
        HashMap scancache = new HashMap();
        ((StreamEx)StreamEx.of(sdrl).filter(sdr -> sdr.selected)).forEach(sdr -> result.updateResult(sdrl.indexOf(sdr), ""));
        ((StreamEx)((StreamEx)StreamEx.of(sdrl).filter(sdr -> sdr.selected)).takeWhile(p -> !progress.isCancel())).forEach(sdr -> {
            int row = sdrl.indexOf(sdr);
            result.updateResult(row, "In progress...");
            File dat = sdr.src;
            File dst = sdr.dst;
            try {
                Object[] datlist = new File[]{dat};
                File[] dstlist = new File[]{dst};
                if (dat.isDirectory()) {
                    datlist = dat.listFiles((sdir, sfilename) -> Sets.newHashSet((Object[])new String[]{"xml", "dat"}).contains(FilenameUtils.getExtension(sfilename).toLowerCase()));
                    Arrays.sort(datlist, (a, b) -> a.getAbsolutePath().compareTo(b.getAbsolutePath()));
                    for (Object object : datlist) {
                        Files.copy(Profile.getSettingsFile(dat).toPath(), Profile.getSettingsFile((File)object).toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    dstlist = (File[])StreamEx.of((Object[])datlist).map(datfile -> new File(dst, FilenameUtils.removeExtension(datfile.getName()))).toArray(File.class);
                    for (File file : dstlist) {
                        file.mkdir();
                    }
                }
                long total = 0L;
                long ok = 0L;
                for (int j = 0; j < datlist.length; ++j) {
                    Profile.curr_profile = Profile.load(datlist[j], (ProgressHandler)progress);
                    Scan.report.setProfile(Profile.curr_profile);
                    Profile.curr_profile.setProperty("roms_dest_dir", dstlist[j].getAbsolutePath());
                    Profile.curr_profile.setProperty("src_dir", String.join((CharSequence)"|", srcdirs.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList())));
                    Scan scan = new Scan(Profile.curr_profile, progress, scancache);
                    total += (long)(Scan.report.stats.set_create + Scan.report.stats.set_found + Scan.report.stats.set_missing);
                    ok += (long)(Scan.report.stats.set_create_complete + Scan.report.stats.set_found_fixcomplete + Scan.report.stats.set_found_ok);
                    if (!dryrun) {
                        new Fix(Profile.curr_profile, scan, progress);
                    }
                    result.updateResult(row, String.format(Messages.getString("DirUpdater.Result"), (double)ok * 100.0 / (double)total, total - ok, total));
                }
            }
            catch (BreakException e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }
}

