/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSourceGenerationException;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.AntlrSpecFactory;
import org.gradle.api.plugins.antlr.internal.AntlrWorkerManager;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.MutableBoolean;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.GFileUtils;

@NonNullApi
@CacheableTask
public class AntlrTask
extends SourceTask {
    private boolean trace;
    private boolean traceLexer;
    private boolean traceParser;
    private boolean traceTreeWalker;
    private List<String> arguments = new ArrayList<String>();
    private FileCollection antlrClasspath;
    private File outputDirectory;
    private String maxHeapSize;
    private SourceDirectorySet sourceDirectorySet;

    @Input
    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Input
    public boolean isTraceLexer() {
        return this.traceLexer;
    }

    public void setTraceLexer(boolean traceLexer) {
        this.traceLexer = traceLexer;
    }

    @Input
    public boolean isTraceParser() {
        return this.traceParser;
    }

    public void setTraceParser(boolean traceParser) {
        this.traceParser = traceParser;
    }

    @Input
    public boolean isTraceTreeWalker() {
        return this.traceTreeWalker;
    }

    public void setTraceTreeWalker(boolean traceTreeWalker) {
        this.traceTreeWalker = traceTreeWalker;
    }

    @Internal
    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public void setArguments(List<String> arguments) {
        if (arguments != null) {
            this.arguments = arguments;
        }
    }

    @Input
    public List<String> getArguments() {
        return this.arguments;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Classpath
    public FileCollection getAntlrClasspath() {
        return this.antlrClasspath;
    }

    protected void setAntlrClasspath(FileCollection antlrClasspath) {
        this.antlrClasspath = antlrClasspath;
    }

    @Inject
    protected WorkerProcessFactory getWorkerProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void execute(IncrementalTaskInputs inputs) {
        final HashSet<File> grammarFiles = new HashSet<File>();
        final Set sourceFiles = this.getSource().getFiles();
        final MutableBoolean cleanRebuild = new MutableBoolean();
        inputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails details) {
                File input = details.getFile();
                if (sourceFiles.contains(input)) {
                    grammarFiles.add(input);
                } else {
                    cleanRebuild.set(true);
                }
            }
        });
        inputs.removed((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails details) {
                if (details.isRemoved()) {
                    cleanRebuild.set(true);
                }
            }
        });
        if (cleanRebuild.get()) {
            GFileUtils.cleanDirectory((File)this.outputDirectory);
            grammarFiles.addAll(sourceFiles);
        }
        AntlrWorkerManager manager = new AntlrWorkerManager();
        AntlrSpec spec = new AntlrSpecFactory().create(this, grammarFiles, this.sourceDirectorySet);
        AntlrResult result = manager.runWorker(this.getProject().getProjectDir(), this.getWorkerProcessBuilderFactory(), this.getAntlrClasspath(), spec);
        this.evaluate(result);
    }

    private void evaluate(AntlrResult result) {
        int errorCount = result.getErrorCount();
        if (errorCount < 0) {
            throw new AntlrSourceGenerationException("There were errors during grammar generation", result.getException());
        }
        if (errorCount == 1) {
            throw new AntlrSourceGenerationException("There was 1 error during grammar generation", result.getException());
        }
        if (errorCount > 1) {
            throw new AntlrSourceGenerationException("There were " + errorCount + " errors during grammar generation", result.getException());
        }
    }

    public void setSource(FileTree source) {
        this.setSource((Object)source);
    }

    public void setSource(Object source) {
        super.setSource(source);
        if (source instanceof SourceDirectorySet) {
            this.sourceDirectorySet = (SourceDirectorySet)source;
        }
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }
}

