/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model.internal;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.ModuleDependency;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;

class IdeaDependenciesOptimizer {
    IdeaDependenciesOptimizer() {
    }

    public void optimizeDeps(Collection<Dependency> deps) {
        Multimap<Object, GeneratedIdeaScope> scopesByDependencyKey = this.collectScopesByDependency(deps);
        this.optimizeScopes(scopesByDependencyKey);
        this.applyScopesToDependencies(deps, scopesByDependencyKey);
    }

    private Multimap<Object, GeneratedIdeaScope> collectScopesByDependency(Collection<Dependency> deps) {
        SetMultimap scopesByDependencyKey = MultimapBuilder.hashKeys().enumSetValues(GeneratedIdeaScope.class).build();
        for (Dependency dep : deps) {
            scopesByDependencyKey.put(this.getKey(dep), (Object)GeneratedIdeaScope.nullSafeValueOf(dep.getScope()));
        }
        return scopesByDependencyKey;
    }

    private void optimizeScopes(Multimap<Object, GeneratedIdeaScope> scopesByDependencyKey) {
        for (Map.Entry entry : scopesByDependencyKey.asMap().entrySet()) {
            this.optimizeScopes((Collection)entry.getValue());
        }
    }

    private void applyScopesToDependencies(Collection<Dependency> deps, Multimap<Object, GeneratedIdeaScope> scopesByDependencyKey) {
        Iterator<Dependency> iterator = deps.iterator();
        while (iterator.hasNext()) {
            this.applyScopeToNextDependency(iterator, scopesByDependencyKey);
        }
    }

    private void applyScopeToNextDependency(Iterator<Dependency> iterator, Multimap<Object, GeneratedIdeaScope> scopesByDependencyKey) {
        Dependency dep = iterator.next();
        Object key = this.getKey(dep);
        Collection ideaScopes = scopesByDependencyKey.get(key);
        if (ideaScopes.isEmpty()) {
            iterator.remove();
        } else {
            GeneratedIdeaScope scope = (GeneratedIdeaScope)((Object)ideaScopes.iterator().next());
            dep.setScope(scope.name());
            scopesByDependencyKey.remove(key, (Object)scope);
        }
    }

    private Object getKey(Dependency dep) {
        if (dep instanceof ModuleDependency) {
            return ((ModuleDependency)dep).getName();
        }
        if (dep instanceof SingleEntryModuleLibrary) {
            return ((SingleEntryModuleLibrary)dep).getLibraryFile();
        }
        throw new IllegalArgumentException("Unsupported type: " + dep.getClass().getName());
    }

    private void optimizeScopes(Collection<GeneratedIdeaScope> ideaScopes) {
        boolean isRuntime = ideaScopes.contains((Object)GeneratedIdeaScope.RUNTIME);
        boolean isProvided = ideaScopes.contains((Object)GeneratedIdeaScope.PROVIDED);
        boolean isCompile = ideaScopes.contains((Object)GeneratedIdeaScope.COMPILE);
        if (isProvided) {
            ideaScopes.remove((Object)GeneratedIdeaScope.TEST);
        }
        if (isRuntime && isProvided) {
            ideaScopes.add(GeneratedIdeaScope.COMPILE);
            isCompile = true;
        }
        if (isCompile) {
            ideaScopes.remove((Object)GeneratedIdeaScope.TEST);
            ideaScopes.remove((Object)GeneratedIdeaScope.RUNTIME);
            ideaScopes.remove((Object)GeneratedIdeaScope.PROVIDED);
        }
    }
}

