/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ValidatingArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.RootConfigurationMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.locking.LockOutOfDateException;
import org.gradle.util.CollectionUtils;

public class DependencyLockingArtifactVisitor
implements ValidatingArtifactsVisitor {
    private final DependencyLockingProvider dependencyLockingProvider;
    private final String configurationName;
    private Set<ModuleComponentIdentifier> allResolvedModules;
    private Set<ModuleComponentIdentifier> changingResolvedModules;
    private Set<ModuleComponentIdentifier> extraModules;
    private Set<ModuleComponentIdentifier> incorrectModules;
    private Map<ModuleIdentifier, ModuleComponentIdentifier> modulesToBeLocked;
    private DependencyLockingState dependencyLockingState;

    public DependencyLockingArtifactVisitor(String configurationName, DependencyLockingProvider dependencyLockingProvider) {
        this.configurationName = configurationName;
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    @Override
    public void startArtifacts(RootGraphNode root) {
        RootConfigurationMetadata metadata = root.getMetadata();
        this.dependencyLockingState = metadata.getDependencyLockingState();
        if (this.dependencyLockingState.mustValidateLockState()) {
            Set<ModuleComponentIdentifier> lockedModules = this.dependencyLockingState.getLockedDependencies();
            this.modulesToBeLocked = Maps.newHashMapWithExpectedSize((int)lockedModules.size());
            for (ModuleComponentIdentifier lockedModule : lockedModules) {
                this.modulesToBeLocked.put(lockedModule.getModuleIdentifier(), lockedModule);
            }
            this.allResolvedModules = Sets.newHashSetWithExpectedSize((int)this.modulesToBeLocked.size());
            this.extraModules = Sets.newHashSet();
            this.incorrectModules = Sets.newHashSet();
        } else {
            this.modulesToBeLocked = Collections.emptyMap();
            this.allResolvedModules = Sets.newHashSet();
        }
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        boolean changing = false;
        ComponentIdentifier identifier = node.getOwner().getComponentId();
        ComponentResolveMetadata metadata = node.getOwner().getMetadata();
        if (metadata != null && metadata.isChanging()) {
            changing = true;
        }
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier id = (ModuleComponentIdentifier)identifier;
            if (identifier instanceof MavenUniqueSnapshotComponentIdentifier) {
                id = ((MavenUniqueSnapshotComponentIdentifier)id).getSnapshotComponent();
            }
            if (!id.getVersion().isEmpty() && this.allResolvedModules.add(id)) {
                if (changing) {
                    this.addChangingModule(id);
                }
                if (this.dependencyLockingState.mustValidateLockState()) {
                    ModuleComponentIdentifier lockedId = this.modulesToBeLocked.remove(id.getModuleIdentifier());
                    if (lockedId == null) {
                        this.extraModules.add(id);
                    } else if (!lockedId.getVersion().equals(id.getVersion())) {
                        node.getIncomingEdges();
                        this.incorrectModules.add(lockedId);
                    }
                }
            }
        }
    }

    private void addChangingModule(ModuleComponentIdentifier id) {
        if (this.changingResolvedModules == null) {
            this.changingResolvedModules = new HashSet<ModuleComponentIdentifier>();
        }
        this.changingResolvedModules.add(id);
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
    }

    @Override
    public void finishArtifacts() {
    }

    private Collection<String> getSortedDisplayNames(Collection<ModuleComponentIdentifier> modules) {
        return CollectionUtils.collect(modules, (Transformer)new Transformer<String, ModuleComponentIdentifier>(){

            public String transform(ModuleComponentIdentifier moduleComponentIdentifier) {
                return moduleComponentIdentifier.getDisplayName();
            }
        });
    }

    private void throwLockOutOfDateException(Collection<String> notResolvedConstraints, Collection<String> extraModules, Collection<String> incorrectModules) {
        ArrayList errors = Lists.newArrayListWithCapacity((int)(notResolvedConstraints.size() + extraModules.size() + incorrectModules.size()));
        for (String notResolvedConstraint : notResolvedConstraints) {
            errors.add("Did not resolve '" + notResolvedConstraint + "' which is part of the lock state");
        }
        for (String extraModule : extraModules) {
            errors.add("Resolved '" + extraModule + "' which is not part of the lock state");
        }
        for (String incorrectModule : incorrectModules) {
            errors.add("Lock entry '" + incorrectModule + "' is incompatible with declared dependencies");
        }
        throw LockOutOfDateException.createLockOutOfDateException(this.configurationName, errors);
    }

    @Override
    public void complete() {
        if (!(!this.dependencyLockingState.mustValidateLockState() || this.modulesToBeLocked.isEmpty() && this.extraModules.isEmpty() && this.incorrectModules.isEmpty())) {
            this.throwLockOutOfDateException(this.getSortedDisplayNames(this.modulesToBeLocked.values()), this.getSortedDisplayNames(this.extraModules), this.getSortedDisplayNames(this.incorrectModules));
        }
        Set<ModuleComponentIdentifier> changingModules = this.changingResolvedModules == null ? Collections.emptySet() : this.changingResolvedModules;
        this.dependencyLockingProvider.persistResolvedDependencies(this.configurationName, this.allResolvedModules, changingModules);
    }
}

