/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.MultipleCandidateMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentAttributeMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAttributeMatcher.class);

    public boolean isMatching(AttributeSelectionSchema schema, AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return true;
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        for (Attribute attribute : requestedAttributes.keySet()) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (!candidateValue.isPresent()) continue;
            Object coercedValue = candidateValue.coerce(attribute);
            boolean match = schema.matchValue(attribute, requestedValue.get(), coercedValue);
            if (match) continue;
            return false;
        }
        return true;
    }

    public List<AttributeMatcher.MatchingDescription> describeMatching(AttributeSelectionSchema schema, AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        ImmutableSet attributes = requestedAttributes.keySet();
        ArrayList result = Lists.newArrayListWithCapacity((int)attributes.size());
        for (Attribute attribute : attributes) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (candidateValue.isPresent()) {
                Object coercedValue = candidateValue.coerce(attribute);
                boolean match = schema.matchValue(attribute, requestedValue.get(), coercedValue);
                result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, match));
                continue;
            }
            result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, false));
        }
        return result;
    }

    public <T extends HasAttributes> List<T> match(AttributeSelectionSchema schema, Collection<? extends T> candidates, AttributeContainerInternal requested, @Nullable T fallback) {
        if (candidates.size() == 0) {
            if (fallback != null && this.isMatching(schema, (AttributeContainerInternal)fallback.getAttributes(), requested)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No candidates for {}, selected matching fallback {}", (Object)requested, fallback);
                }
                return ImmutableList.of(fallback);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No candidates for {} and fallback {} does not match. Select nothing.", (Object)requested, fallback);
            }
            return ImmutableList.of();
        }
        if (candidates.size() == 1) {
            HasAttributes candidate = (HasAttributes)candidates.iterator().next();
            if (this.isMatching(schema, (AttributeContainerInternal)candidate.getAttributes(), requested)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Selected match {} from candidates {} for {}", new Object[]{candidate, candidates, requested});
                }
                return Collections.singletonList(candidate);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Selected match [] from candidates {} for {}", candidates, (Object)requested);
            }
            return ImmutableList.of();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        List<? extends T> matches = new MultipleCandidateMatcher<T>(schema, candidates, requestedAttributes).getMatches();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Selected matches {} from candidates {} for {}", new Object[]{matches, candidates, requested});
        }
        return matches;
    }
}

