/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.TimeSource;

class MonotonicClock
implements Clock {
    private static final long SYNC_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private final long syncIntervalMillis;
    private final TimeSource timeSource;
    private final AtomicLong syncMillisRef;
    private final AtomicLong syncNanosRef;
    private final AtomicLong max = new AtomicLong(0L);

    MonotonicClock() {
        this(TimeSource.SYSTEM, SYNC_INTERVAL_MILLIS);
    }

    @VisibleForTesting
    MonotonicClock(TimeSource timeSource, long syncIntervalMillis) {
        long nanoTime = timeSource.nanoTime();
        long currentTimeMillis = timeSource.currentTimeMillis();
        this.timeSource = timeSource;
        this.syncIntervalMillis = syncIntervalMillis;
        this.syncNanosRef = new AtomicLong(nanoTime);
        this.syncMillisRef = new AtomicLong(currentTimeMillis);
        this.max.set(currentTimeMillis);
    }

    @Override
    public long getCurrentTime() {
        long nowNanos = this.timeSource.nanoTime();
        long syncNanos = this.syncNanosRef.get();
        long syncMillis = this.syncMillisRef.get();
        long sinceSyncNanos = nowNanos - syncNanos;
        long sinceSyncMillis = TimeUnit.NANOSECONDS.toMillis(sinceSyncNanos);
        if (this.syncIsDue(nowNanos, syncNanos, sinceSyncMillis)) {
            return this.sync(syncMillis);
        }
        return this.advance(syncMillis + sinceSyncMillis);
    }

    private boolean syncIsDue(long nowNanos, long syncNanos, long sinceSyncMillis) {
        return sinceSyncMillis >= this.syncIntervalMillis && this.syncNanosRef.compareAndSet(syncNanos, nowNanos);
    }

    private long sync(long syncMillis) {
        long newSyncMillis = this.advance(this.timeSource.currentTimeMillis());
        this.syncMillisRef.compareAndSet(syncMillis, newSyncMillis);
        return newSyncMillis;
    }

    private long advance(long timestamp) {
        long next;
        long prev;
        while (!this.max.compareAndSet(prev = this.max.get(), next = Math.max(prev, timestamp))) {
        }
        return next;
    }
}

