/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineMetadataPropertiesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001*\u00020\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u001a\u0018\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0006*\u00020\u0002H\u0002\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0001\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003*\u00020\u0002H\u0002\u001a2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003*\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u000e\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0013H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017\u001a \u0010\u0018\u001a\u00020\u0015*\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u0012\u0010\u001a\u001a\u00020\u0015*\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001a\u0010\u001b\u001a\u00020\u0015*\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000e\u00a8\u0006\u001f"}, d2={"buildGraph", "", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "", "globalCatchBlock", "collectFinallyPaths", "", "collectNodesToSplit", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "breakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectTargetBlocks", "collectVariablesSurvivingBetweenBlocks", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "localVariables", "parameters", "isStateMachineResult", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "replaceCoroutineFlowStatements", "", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "replaceLocalVariables", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "replaceSpecialReferences", "replaceSpecialReferencesInSimpleFunction", "continuationParam", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "resultVar", "js.translator"})
public final class CoroutinePassesKt {
    @NotNull
    public static final Set<JsNode> collectNodesToSplit(@NotNull JsNode $receiver, @NotNull Map<JsContinue, ? extends JsStatement> breakContinueTargets) {
        int countBefore;
        int countAfter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(breakContinueTargets, (String)"breakContinueTargets");
        JsNode root2 = $receiver;
        Set nodes = new LinkedHashSet();
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(nodes, root2, breakContinueTargets){
            private boolean childrenInSet;
            private int finallyLevel;
            final /* synthetic */ Set $nodes;
            final /* synthetic */ JsNode $root;
            final /* synthetic */ Map $breakContinueTargets;

            public final boolean getChildrenInSet() {
                return this.childrenInSet;
            }

            public final void setChildrenInSet(boolean bl) {
                this.childrenInSet = bl;
            }

            public final int getFinallyLevel() {
                return this.finallyLevel;
            }

            public final void setFinallyLevel(int n) {
                this.finallyLevel = n;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                super.visitExpressionStatement(x);
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                if (MetadataProperties.isSuspend(jsExpression)) {
                    Collection collection = this.$nodes;
                    JsExpression jsExpression2 = x.getExpression();
                    collection.add(jsExpression2);
                    this.childrenInSet = true;
                } else {
                    Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x.getExpression());
                    if (assignment != null) {
                        Object object = assignment.getSecond();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"assignment.second");
                        if (MetadataProperties.isSuspend((JsExpression)object)) {
                            Collection collection = this.$nodes;
                            Object object2 = assignment.getSecond();
                            collection.add(object2);
                            this.childrenInSet = true;
                        }
                    }
                }
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                super.visitReturn(x);
                if (this.$nodes.contains(this.$root) || this.finallyLevel > 0) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement breakTarget;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                super.visitBreak(x);
                V v = this.$breakContinueTargets.get(x);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                if (this.$nodes.contains(breakTarget = (JsStatement)v)) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement continueTarget;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                super.visitContinue(x);
                V v = this.$breakContinueTargets.get(x);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                if (this.$nodes.contains(continueTarget = (JsStatement)v)) {
                    Collection collection = this.$nodes;
                    collection.add(x);
                    this.childrenInSet = true;
                }
            }

            public void visitTry(@NotNull JsTry x) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                if (x.getFinallyBlock() != null) {
                    n = this.finallyLevel;
                    this.finallyLevel = n + 1;
                }
                super.visitTry(x);
                if (x.getFinallyBlock() != null) {
                    n = this.finallyLevel;
                    this.finallyLevel = n + -1;
                }
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                boolean oldChildrenInSet = this.childrenInSet;
                this.childrenInSet = false;
                node.acceptChildren(this);
                if (this.childrenInSet) {
                    Collection collection = this.$nodes;
                    collection.add(node);
                } else {
                    this.childrenInSet = oldChildrenInSet;
                }
            }
            {
                this.$nodes = $captured_local_variable$0;
                this.$root = $captured_local_variable$1;
                this.$breakContinueTargets = $captured_local_variable$2;
            }
        };
        do {
            countBefore = nodes.size();
            visitor2.accept($receiver);
        } while ((countAfter = nodes.size()) != countBefore);
        return nodes;
    }

    /*
     * WARNING - void declaration
     */
    public static final void replaceCoroutineFlowStatements(@NotNull List<CoroutineBlock> $receiver, @NotNull CoroutineTransformationContext context) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)$receiver);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map2 = destination$iv$iv;
            IndexedValue $index_block = (IndexedValue)element$iv$iv;
            int index2 = $index_block.component1();
            CoroutineBlock block = (CoroutineBlock)$index_block.component2();
            Pair pair = new Pair((Object)block, (Object)index2);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map blockIndexes = destination$iv$iv;
        JsVisitorWithContextImpl blockReplacementVisitor2 = new JsVisitorWithContextImpl(context, blockIndexes){
            final /* synthetic */ CoroutineTransformationContext $context;
            final /* synthetic */ Map $blockIndexes;

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsDebugger x, @NotNull JsContext<? super JsStatement> ctx) {
                List<CoroutineBlock> finallyPath;
                Object rhs;
                CoroutineBlock exceptionTarget;
                JsExpressionStatement jsExpressionStatement;
                JsExpressionStatement $receiver;
                JsContext<? super JsStatement> jsContext;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                CoroutineBlock target = CoroutineMetadataPropertiesKt.getTargetBlock(x);
                if (target != null) {
                    JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getStateName(), JsAstUtils.stateMachineReceiver());
                    V v = this.$blockIndexes.get(target);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    JsIntLiteral rhs2 = new JsIntLiteral(((Number)v).intValue());
                    JsExpressionStatement jsExpressionStatement2 = new JsExpressionStatement(JsAstUtils.assignment(lhs, rhs2).source(x.getSource()));
                    jsContext = ctx;
                    $receiver = jsExpressionStatement2;
                    CoroutineMetadataPropertiesKt.setTargetBlock($receiver, true);
                    jsExpressionStatement = jsExpressionStatement2;
                    jsContext.replaceMe((JsNode)jsExpressionStatement);
                }
                if ((exceptionTarget = CoroutineMetadataPropertiesKt.getTargetExceptionBlock(x)) != null) {
                    JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getExceptionStateName(), JsAstUtils.stateMachineReceiver());
                    V v = this.$blockIndexes.get(exceptionTarget);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    rhs = new JsIntLiteral(((Number)v).intValue());
                    $receiver = new JsExpressionStatement(JsAstUtils.assignment(lhs, (JsExpression)rhs).source(x.getSource()));
                    jsContext = ctx;
                    JsExpressionStatement $receiver2 = $receiver;
                    CoroutineMetadataPropertiesKt.setTargetExceptionBlock($receiver2, true);
                    jsExpressionStatement = $receiver;
                    jsContext.replaceMe((JsNode)jsExpressionStatement);
                }
                if ((finallyPath = CoroutineMetadataPropertiesKt.getFinallyPath(x)) != null) {
                    rhs = finallyPath;
                    if (!rhs.isEmpty()) {
                        Collection<JsIntLiteral> collection;
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        JsNameRef lhs = new JsNameRef(this.$context.getMetadata().getFinallyPathName(), JsAstUtils.stateMachineReceiver());
                        Iterable $i$a$2$apply = $receiver$iv = (Iterable)finallyPath;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            CoroutineBlock coroutineBlock = (CoroutineBlock)item$iv$iv;
                            collection = destination$iv$iv;
                            V v = this.$blockIndexes.get(it);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            JsIntLiteral jsIntLiteral = new JsIntLiteral(((Number)v).intValue());
                            collection.add(jsIntLiteral);
                        }
                        collection = (List)destination$iv$iv;
                        List list2 = collection;
                        JsArrayLiteral rhs3 = new JsArrayLiteral(list2);
                        JsExpressionStatement jsExpressionStatement3 = new JsExpressionStatement(JsAstUtils.assignment(lhs, rhs3).source(x.getSource()));
                        jsContext = ctx;
                        JsExpressionStatement $receiver3 = jsExpressionStatement3;
                        CoroutineMetadataPropertiesKt.setFinallyPath($receiver3, true);
                        jsExpressionStatement = jsExpressionStatement3;
                        jsContext.replaceMe((JsNode)jsExpressionStatement);
                    } else {
                        ctx.removeMe();
                    }
                }
            }
            {
                this.$context = $captured_local_variable$0;
                this.$blockIndexes = $captured_local_variable$1;
            }
        };
        Iterable $receiver$iv2 = $receiver;
        for (Object element$iv : $receiver$iv2) {
            CoroutineBlock it = (CoroutineBlock)element$iv;
            blockReplacementVisitor2.accept((JsNode)it.getJsBlock());
        }
    }

    @NotNull
    public static final Map<CoroutineBlock, Set<CoroutineBlock>> buildGraph(@NotNull CoroutineBlock $receiver, @Nullable CoroutineBlock globalCatchBlock) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set visitedBlocks = new LinkedHashSet();
        Map graph2 = new LinkedHashMap();
        Function1<CoroutineBlock, Unit> visitBlock$ = new Function1<CoroutineBlock, Unit>($receiver, visitedBlocks, graph2, globalCatchBlock){
            final /* synthetic */ CoroutineBlock receiver$0;
            final /* synthetic */ Set $visitedBlocks;
            final /* synthetic */ Map $graph;
            final /* synthetic */ CoroutineBlock $globalCatchBlock;

            public final void invoke(@NotNull CoroutineBlock block) {
                Object object;
                Object object22;
                Collection<CoroutineBlock> finallyPath2;
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                if (this.$visitedBlocks.contains(block)) {
                    return;
                }
                for (Collection<CoroutineBlock> finallyPath2 : CoroutinePassesKt.access$collectFinallyPaths(block)) {
                    for (Object object22 : CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)block), (Iterable)finallyPath2), (Iterable)finallyPath2)) {
                        Object object3;
                        CoroutineBlock finallySource = (CoroutineBlock)object22.component1();
                        CoroutineBlock finallyTarget = (CoroutineBlock)object22.component2();
                        Object $receiver$iv = this.$graph;
                        V value$iv = $receiver$iv.get(finallySource);
                        if (value$iv == null) {
                            Set answer$iv = new LinkedHashSet<E>();
                            $receiver$iv.put(finallySource, answer$iv);
                            object3 = answer$iv;
                        } else {
                            object3 = value$iv;
                        }
                        if (!((Set)object3).add(finallyTarget)) continue;
                        $receiver$iv = this.$visitedBlocks;
                        $receiver$iv.remove(finallySource);
                    }
                }
                finallyPath2 = this.$visitedBlocks;
                finallyPath2.add(block);
                Object $receiver$iv = this.$graph;
                V value$iv = $receiver$iv.get(block);
                if (value$iv == null) {
                    Set answer$iv = new LinkedHashSet<E>();
                    $receiver$iv.put(block, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Set successors = (Set)object;
                $receiver$iv = successors;
                object22 = CoroutinePassesKt.access$collectTargetBlocks(block);
                CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object22);
                if (Intrinsics.areEqual((Object)block, (Object)this.receiver$0) && this.$globalCatchBlock != null) {
                    $receiver$iv = successors;
                    object22 = this.$globalCatchBlock;
                    $receiver$iv.add(object22);
                }
                $receiver$iv = successors;
                object22 = $receiver$iv.iterator();
                while (object22.hasNext()) {
                    E element$iv = object22.next();
                    CoroutineBlock p1 = (CoroutineBlock)element$iv;
                    this.invoke(p1);
                }
            }
            {
                this.receiver$0 = coroutineBlock;
                this.$visitedBlocks = set;
                this.$graph = map2;
                this.$globalCatchBlock = coroutineBlock2;
                super(1);
            }
        };
        visitBlock$.invoke($receiver);
        return graph2;
    }

    private static final Set<CoroutineBlock> collectTargetBlocks(@NotNull CoroutineBlock $receiver) {
        Set targetBlocks = new LinkedHashSet();
        $receiver.getJsBlock().accept(new RecursiveJsVisitor(targetBlocks){
            final /* synthetic */ Set $targetBlocks;

            public void visitDebugger(@NotNull JsDebugger x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Collection collection = this.$targetBlocks;
                Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)CoroutineMetadataPropertiesKt.getTargetExceptionBlock(x)), (Iterable)CollectionsKt.listOfNotNull((Object)CoroutineMetadataPropertiesKt.getTargetBlock(x)));
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
            {
                this.$targetBlocks = $captured_local_variable$0;
            }
        });
        return targetBlocks;
    }

    private static final List<List<CoroutineBlock>> collectFinallyPaths(@NotNull CoroutineBlock $receiver) {
        List finallyPaths = new ArrayList();
        $receiver.getJsBlock().accept(new RecursiveJsVisitor(finallyPaths){
            final /* synthetic */ List $finallyPaths;

            public void visitDebugger(@NotNull JsDebugger x) {
                block0: {
                    List<CoroutineBlock> list2;
                    Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                    List<CoroutineBlock> list3 = CoroutineMetadataPropertiesKt.getFinallyPath(x);
                    if (list3 == null) break block0;
                    List<CoroutineBlock> it = list2 = list3;
                    Collection collection = this.$finallyPaths;
                    collection.add(it);
                }
            }
            {
                this.$finallyPaths = $captured_local_variable$0;
            }
        });
        return finallyPaths;
    }

    public static final void replaceSpecialReferences(@NotNull JsBlock $receiver, @NotNull CoroutineTransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(context){
            final /* synthetic */ CoroutineTransformationContext $context;

            public void endVisit(@NotNull JsThisRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                ctx.replaceMe((JsNode)new JsNameRef(this.$context.getReceiverFieldName(), (JsExpression)new JsThisRef()));
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return false;
            }

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (MetadataProperties.getCoroutineReceiver(x)) {
                    ctx.replaceMe((JsNode)new JsThisRef());
                } else if (MetadataProperties.getCoroutineController(x)) {
                    JsNameRef jsNameRef = new JsNameRef(this.$context.getControllerFieldName(), x.getQualifier());
                    JsContext<? super JsNode> jsContext = ctx;
                    JsNameRef $receiver = jsNameRef;
                    $receiver.setSource(x.getSource());
                    MetadataProperties.setSideEffects($receiver, SideEffectKind.PURE);
                    JsNameRef jsNameRef2 = jsNameRef;
                    jsContext.replaceMe((JsNode)jsNameRef2);
                } else if (MetadataProperties.getCoroutineResult(x)) {
                    JsNameRef jsNameRef = new JsNameRef(this.$context.getMetadata().getResultName(), x.getQualifier());
                    JsContext<? super JsNode> jsContext = ctx;
                    JsNameRef $receiver = jsNameRef;
                    $receiver.setSource(x.getSource());
                    MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                    JsNameRef jsNameRef3 = jsNameRef;
                    jsContext.replaceMe((JsNode)jsNameRef3);
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    public static final void replaceSpecialReferencesInSimpleFunction(@NotNull JsBlock $receiver, @NotNull JsParameter continuationParam, @NotNull JsName resultVar) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)continuationParam, (String)"continuationParam");
        Intrinsics.checkParameterIsNotNull((Object)resultVar, (String)"resultVar");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(continuationParam, resultVar){
            final /* synthetic */ JsParameter $continuationParam;
            final /* synthetic */ JsName $resultVar;

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return false;
            }

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
                JsExpression jsExpression;
                JsExpression it;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (MetadataProperties.getCoroutineReceiver(x)) {
                    ctx.replaceMe((JsNode)JsAstUtils.pureFqn(this.$continuationParam.getName(), null).source(x.getSource()));
                } else if (MetadataProperties.getCoroutineController(x)) {
                    JsThisRef jsThisRef = new JsThisRef();
                    JsContext<? super JsNode> jsContext = ctx;
                    JsThisRef $receiver = jsThisRef;
                    $receiver.setSource(x.getSource());
                    JsThisRef jsThisRef2 = jsThisRef;
                    jsContext.replaceMe((JsNode)jsThisRef2);
                } else if (MetadataProperties.getCoroutineResult(x) && (it = (jsExpression = x.getQualifier())) instanceof JsNameRef && Intrinsics.areEqual((Object)((JsNameRef)it).getName(), (Object)this.$continuationParam.getName())) {
                    ctx.replaceMe((JsNode)JsAstUtils.pureFqn(this.$resultVar, null).source(x.getSource()));
                }
            }
            {
                this.$continuationParam = $captured_local_variable$0;
                this.$resultVar = $captured_local_variable$1;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final Set<JsName> collectVariablesSurvivingBetweenBlocks(@NotNull List<CoroutineBlock> $receiver, @NotNull Set<? extends JsName> localVariables, @NotNull Set<? extends JsName> parameters) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(localVariables, (String)"localVariables");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        $receiver$iv = localVariables;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        var6_6 = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            var10_17 = destination$iv$iv;
            it = (JsName)element$iv$iv;
            var12_19 = it;
            var13_20 = new LinkedHashSet<E>();
            var15_21 = TuplesKt.to((Object)var12_19, (Object)var13_20);
            var10_17.put(var15_21.getFirst(), var15_21.getSecond());
        }
        varDefinedIn = destination$iv$iv;
        $receiver$iv = localVariables;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        for (E element$iv$iv : $receiver$iv$iv) {
            it = destination$iv$iv;
            var13_20 = it = (JsName)element$iv$iv;
            $i$a$1$associate = new LinkedHashSet<E>();
            $i$f$associateTo = TuplesKt.to((Object)var13_20, (Object)$i$a$1$associate);
            it.put($i$f$associateTo.getFirst(), $i$f$associateTo.getSecond());
        }
        varDeclaredIn = destination$iv$iv;
        $receiver$iv = localVariables;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        var10_17 = $receiver$iv$iv.iterator();
        while (var10_17.hasNext()) {
            element$iv$iv /* !! */  = var10_17.next();
            it = destination$iv$iv;
            it = (JsName)element$iv$iv /* !! */ ;
            $i$a$1$associate = it;
            $i$a$1$associate = new LinkedHashSet<E>();
            var17_25 = TuplesKt.to((Object)$i$a$1$associate, (Object)$i$a$1$associate);
            it.put(var17_25.getFirst(), var17_25.getSecond());
        }
        varUsedIn = destination$iv$iv;
        $receiver$iv = false;
        for (CoroutineBlock block : (Iterable)$receiver) {
            for (JsStatement statement : block.getStatements()) {
                statement.accept(new RecursiveJsVisitor(varUsedIn, (int)blockIndex, varDeclaredIn, varDefinedIn){
                    final /* synthetic */ Map $varUsedIn;
                    final /* synthetic */ int $blockIndex;
                    final /* synthetic */ Map $varDeclaredIn;
                    final /* synthetic */ Map $varDefinedIn;

                    public void visitNameRef(@NotNull JsNameRef nameRef) {
                        block0: {
                            Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
                            super.visitNameRef(nameRef);
                            Map map2 = this.$varUsedIn;
                            JsName jsName = nameRef.getName();
                            Set set = (Set)map2.get(jsName);
                            if (set == null) break block0;
                            set.add(this.$blockIndex);
                        }
                    }

                    public void visit(@NotNull JsVars.JsVar x) {
                        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                        Set set = (Set)this.$varDeclaredIn.get(x.getName());
                        if (set != null) {
                            set.add(this.$blockIndex);
                        }
                        if (x.getInitExpression() != null) {
                            Set set2 = (Set)this.$varDefinedIn.get(x.getName());
                            if (set2 != null) {
                                set2.add(this.$blockIndex);
                            }
                        }
                        super.visit(x);
                    }

                    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                        JsExpression lhs = x.getArg1();
                        JsBinaryOperator jsBinaryOperator = x.getOperator();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsBinaryOperator, (String)"x.operator");
                        if (jsBinaryOperator.isAssignment() && lhs instanceof JsNameRef) {
                            Map map2 = this.$varDefinedIn;
                            JsName jsName = ((JsNameRef)lhs).getName();
                            Set set = (Set)map2.get(jsName);
                            if (set != null) {
                                boolean bl;
                                boolean it = bl = set.add(this.$blockIndex);
                                this.accept((JsNode)x.getArg2());
                                return;
                            }
                        }
                        super.visitBinaryExpression(x);
                    }

                    public void visitFunction(@NotNull JsFunction x) {
                        block1: {
                            JsName jsName;
                            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                            JsName jsName2 = x.getName();
                            if (jsName2 == null) break block1;
                            JsName it = jsName = jsName2;
                            Set set = (Set)this.$varDefinedIn.get(it);
                            if (set != null) {
                                set.add(this.$blockIndex);
                            }
                        }
                    }

                    public void visitLabel(@NotNull JsLabel x) {
                        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                        this.accept((JsNode)x.getStatement());
                    }

                    public void visitBreak(@NotNull JsBreak x) {
                        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                    }

                    public void visitContinue(@NotNull JsContinue x) {
                        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                    }
                    {
                        this.$varUsedIn = $captured_local_variable$0;
                        this.$blockIndex = $captured_local_variable$1;
                        this.$varDeclaredIn = $captured_local_variable$2;
                        this.$varDefinedIn = $captured_local_variable$3;
                    }
                });
            }
            ++blockIndex;
        }
        isLocalInBlock$ = new Function1<JsName, Boolean>(varDefinedIn, varUsedIn, varDeclaredIn){
            final /* synthetic */ Map $varDefinedIn;
            final /* synthetic */ Map $varUsedIn;
            final /* synthetic */ Map $varDeclaredIn;

            public final boolean invoke(@NotNull JsName $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                V v = this.$varDefinedIn.get($receiver);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Set def = (Set)v;
                V v2 = this.$varUsedIn.get($receiver);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                Set use2 = (Set)v2;
                V v3 = this.$varDeclaredIn.get($receiver);
                if (v3 == null) {
                    Intrinsics.throwNpe();
                }
                Set decl = (Set)v3;
                if (def.size() == 1 && use2.size() == 1) {
                    Collection collection;
                    int singleUse;
                    int singleDef = ((Number)CollectionsKt.single((Iterable)def)).intValue();
                    return singleDef == (singleUse = ((Number)CollectionsKt.single((Iterable)use2)).intValue()) && !(collection = (Collection)decl).isEmpty();
                }
                return use2.isEmpty();
            }
            {
                this.$varDefinedIn = map2;
                this.$varUsedIn = map3;
                this.$varDeclaredIn = map4;
                super(1);
            }
        };
        $receiver$iv = localVariables;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        var10_17 = $receiver$iv$iv.iterator();
        while (var10_17.hasNext()) {
            block12: {
                block11: {
                    element$iv$iv /* !! */  = var10_17.next();
                    localVar = (JsName)element$iv$iv /* !! */ ;
                    if (!parameters.contains(localVar)) break block11;
                    v0 = varUsedIn.get(localVar);
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!((Set)v0).isEmpty()) ** GOTO lbl-1000
                    v1 = varDefinedIn.get(localVar);
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!((Set)v1).isEmpty()) ** GOTO lbl-1000
                    v2 = varDeclaredIn.get(localVar);
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((Set)v2).isEmpty()) {
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v3 = false;
                    }
                    break block12;
                }
                v3 = isLocalInBlock$.invoke(localVar);
            }
            if (v3) continue;
            destination$iv$iv.add(element$iv$iv /* !! */ );
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static final void replaceLocalVariables(@NotNull JsBlock $receiver, @NotNull CoroutineTransformationContext context, @NotNull Set<? extends JsName> localVariables) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(localVariables, (String)"localVariables");
        CoroutinePassesKt.replaceSpecialReferences($receiver, context);
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(localVariables, context){
            final /* synthetic */ Set $localVariables;
            final /* synthetic */ CoroutineTransformationContext $context;

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsFunction x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                Set freeVars = CollectionsKt.intersect((Iterable)CollectUtilsKt.collectFreeVariables(x), (Iterable)this.$localVariables);
                Collection collection = freeVars;
                if (!collection.isEmpty()) {
                    Map map2;
                    void $receiver$iv$iv;
                    Object freeVar2;
                    Object object;
                    Object object2;
                    Collection $receiver$iv$iv2;
                    JsFunctionScope jsFunctionScope = x.getScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsFunctionScope, (String)"x.scope");
                    JsFunction wrapperFunction = new JsFunction(jsFunctionScope.getParent(), new JsBlock(), "");
                    JsInvocation wrapperInvocation = new JsInvocation((JsExpression)wrapperFunction, new JsExpression[0]);
                    JsBlock jsBlock = wrapperFunction.getBody();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"wrapperFunction.body");
                    Collection collection2 = jsBlock.getStatements();
                    JsReturn jsReturn = new JsReturn(x);
                    collection2.add(jsReturn);
                    Iterable $receiver$iv = freeVars;
                    int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
                    Iterable iterable = $receiver$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv22);
                    for (T element$iv$iv : $receiver$iv$iv2) {
                        object2 = destination$iv$iv;
                        JsName it = (JsName)element$iv$iv;
                        object = TuplesKt.to((Object)it, (Object)JsScope.declareTemporaryName(it.getIdent()));
                        object2.put(object.getFirst(), object.getSecond());
                    }
                    Map nameMap = destination$iv$iv;
                    for (Object freeVar2 : freeVars) {
                        $receiver$iv$iv2 = wrapperFunction.getParameters();
                        V v = nameMap.get(freeVar2);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        destination$iv$iv = new JsParameter((JsName)v);
                        $receiver$iv$iv2.add(destination$iv$iv);
                        $receiver$iv$iv2 = wrapperInvocation.getArguments();
                        destination$iv$iv = new JsNameRef(this.$context.getFieldName((JsName)freeVar2), (JsExpression)new JsThisRef());
                        $receiver$iv$iv2.add(destination$iv$iv);
                    }
                    freeVar2 = nameMap;
                    JsNode jsNode = x.getBody();
                    JsFunction jsFunction = x;
                    Iterable capacity$iv22 = $receiver$iv;
                    Map destination$iv$iv2 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$receiver$iv.size()));
                    Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        void it;
                        void it$iv$iv;
                        object2 = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv2;
                        K k = it$iv$iv.getKey();
                        object = (Map.Entry)element$iv$iv$iv;
                        K k2 = k;
                        map2 = map3;
                        JsNameRef jsNameRef = ((JsName)it.getValue()).makeRef();
                        map2.put(k2, jsNameRef);
                    }
                    map2 = destination$iv$iv2;
                    jsFunction.setBody((JsBlock)RewriteUtilsKt.replaceNames(jsNode, map2));
                    ctx.replaceMe((JsNode)wrapperInvocation);
                }
            }

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<? super JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (x.getQualifier() == null && CollectionsKt.contains((Iterable)this.$localVariables, (Object)x.getName())) {
                    JsName jsName = x.getName();
                    if (jsName == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"x.name!!");
                    JsName fieldName = this.$context.getFieldName(jsName);
                    ctx.replaceMe((JsNode)new JsNameRef(fieldName, (JsExpression)new JsThisRef()).source(x.getSource()));
                }
            }

            public void endVisit(@NotNull JsVars x, @NotNull JsContext<? super JsStatement> ctx) {
                boolean bl;
                block11: {
                    Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                    Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                    List<JsVars.JsVar> list2 = x.getVars();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.vars");
                    Iterable $receiver$iv = list2;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            JsVars.JsVar it;
                            JsVars.JsVar jsVar = it = (JsVars.JsVar)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"it");
                            if (!this.$localVariables.contains(jsVar.getName())) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
                List statements = new ArrayList<E>();
                List<JsVars.JsVar> list3 = x.getVars();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"x.vars");
                for (Pair<List<JsVars.JsVar>, S> pair : UtilsKt.splitToRanges(list3, (Function1)new Function1<JsVars.JsVar, Boolean>(this){
                    final /* synthetic */ replaceLocalVariables.visitor.1 this$0;

                    public final boolean invoke(JsVars.JsVar it) {
                        Set set = this.this$0.$localVariables;
                        JsVars.JsVar jsVar = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"it");
                        return set.contains(jsVar.getName());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })) {
                    JsVars.JsVar[] jsVarArray;
                    Iterable<JsExpressionStatement> thisCollection$iv;
                    Iterable<JsExpressionStatement> $receiver$iv;
                    List range = (List)pair.component1();
                    boolean shouldReplace = (Boolean)pair.component2();
                    if (shouldReplace) {
                        JsExpressionStatement $receiver$iv$iv;
                        List<JsVars.JsVar> list4 = x.getVars();
                        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"x.vars");
                        Iterable<JsExpressionStatement> iterable = $receiver$iv = (Iterable)list4;
                        Collection destination$iv$iv = new ArrayList<E>();
                        void $receiver$iv$iv$iv = $receiver$iv$iv;
                        Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            JsBinaryOperation jsBinaryOperation;
                            JsVars.JsVar it;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator2.next();
                            JsVars.JsVar jsVar = it = (JsVars.JsVar)element$iv$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"it");
                            JsName jsName = jsVar.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"it.name");
                            JsName fieldName = this.$context.getFieldName(jsName);
                            JsExpression initExpression = it.getInitExpression();
                            JsBinaryOperation jsBinaryOperation2 = initExpression != null ? JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), it.getInitExpression()) : null;
                            if (jsBinaryOperation2 == null) continue;
                            JsBinaryOperation it$iv$iv = jsBinaryOperation = jsBinaryOperation2;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List assignments = (List)destination$iv$iv;
                        $receiver$iv = assignments;
                        if (!(!$receiver$iv.isEmpty())) continue;
                        $receiver$iv = statements;
                        $receiver$iv$iv = new JsExpressionStatement(JsAstUtils.newSequence(assignments));
                        $receiver$iv.add((JsExpressionStatement)$receiver$iv$iv);
                        continue;
                    }
                    Collection collection = statements;
                    $receiver$iv = range;
                    if ($receiver$iv == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    if (thisCollection$iv.toArray(new JsVars.JsVar[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    JsVars.JsVar[] jsVarArray2 = Arrays.copyOf(jsVarArray, jsVarArray.length);
                    JsVars jsVars = new JsVars(jsVarArray2);
                    collection.add(jsVars);
                }
                if (statements.size() == 1) {
                    ctx.replaceMe((JsNode)statements.get(0));
                } else {
                    ctx.removeMe();
                    ctx.addPrevious(statements);
                }
            }
            {
                this.$localVariables = $captured_local_variable$0;
                this.$context = $captured_local_variable$1;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    public static final boolean isStateMachineResult(@Nullable JsExpression $receiver) {
        JsExpression jsExpression;
        JsExpression it;
        return $receiver instanceof JsNameRef && MetadataProperties.getCoroutineResult((JsNameRef)$receiver) && (it = (jsExpression = ((JsNameRef)$receiver).getQualifier())) instanceof JsNameRef && MetadataProperties.getCoroutineReceiver((JsNameRef)it) && ((JsNameRef)it).getQualifier() == null;
    }

    @NotNull
    public static final /* synthetic */ List access$collectFinallyPaths(@NotNull CoroutineBlock $receiver) {
        return CoroutinePassesKt.collectFinallyPaths($receiver);
    }

    @NotNull
    public static final /* synthetic */ Set access$collectTargetBlocks(@NotNull CoroutineBlock $receiver) {
        return CoroutinePassesKt.collectTargetBlocks($receiver);
    }
}

