/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class FsEq
extends Function {
    public FsEq() {
        super(new QName("eq"), 2);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        return FsEq.fs_eq_value(args, this.dynamic_context());
    }

    private static Collection value_convert_args(Collection args) throws DynamicError {
        ArrayList<ResultSequence> result = new ArrayList<ResultSequence>(args.size());
        for (ResultSequence rs : args) {
            if ((rs = FnData.atomize(rs)).empty()) {
                return new ArrayList();
            }
            if (rs.size() > 1) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            AnyType arg = rs.first();
            if (arg instanceof XSUntypedAtomic) {
                arg = new XSString(arg.string_value());
            }
            rs = ResultSequenceFactory.create_new();
            rs.add(arg);
            result.add(rs);
        }
        return result;
    }

    public static ResultSequence fs_eq_value(Collection args, DynamicContext dynamicContext) throws DynamicError {
        return FsEq.do_cmp_value_op(args, CmpEq.class, "eq", dynamicContext);
    }

    public static boolean fs_eq_fast(AnyType one, AnyType two, DynamicContext dynamicContext) throws DynamicError {
        one = FnData.atomize(one);
        two = FnData.atomize(two);
        if (one instanceof XSUntypedAtomic) {
            one = new XSString(one.string_value());
        }
        if (two instanceof XSUntypedAtomic) {
            two = new XSString(two.string_value());
        }
        if (!(one instanceof CmpEq)) {
            DynamicError.throw_type_error();
        }
        CmpEq cmpone = (CmpEq)((Object)one);
        return cmpone.eq(two, dynamicContext);
    }

    private static boolean do_general_pair(AnyType a, AnyType b, Method comparator, DynamicContext dc) throws DynamicError {
        ResultSequence result;
        block17: {
            ResultSequence converted;
            if (a instanceof XSUntypedAtomic && b instanceof NumericType || b instanceof XSUntypedAtomic && a instanceof NumericType) {
                if (a instanceof XSUntypedAtomic) {
                    a = new XSDouble(a.string_value());
                } else {
                    b = new XSDouble(b.string_value());
                }
            } else if (a instanceof XSUntypedAtomic && (b instanceof XSString || b instanceof XSUntypedAtomic) || b instanceof XSUntypedAtomic && (a instanceof XSString || a instanceof XSUntypedAtomic)) {
                if (a instanceof XSUntypedAtomic) {
                    a = new XSString(a.string_value());
                }
                if (b instanceof XSUntypedAtomic) {
                    b = new XSString(b.string_value());
                }
            } else if (a instanceof XSUntypedAtomic) {
                converted = ResultSequenceFactory.create_new(a);
                assert (converted.size() == 1);
                a = converted.first();
            } else if (b instanceof XSUntypedAtomic) {
                converted = ResultSequenceFactory.create_new(b);
                assert (converted.size() == 1);
                b = converted.first();
            }
            ResultSequence one = ResultSequenceFactory.create_new(a);
            ResultSequence two = ResultSequenceFactory.create_new(b);
            ArrayList<ResultSequence> args = new ArrayList<ResultSequence>();
            args.add(one);
            args.add(two);
            Object[] margs = new Object[]{args, dc};
            result = null;
            try {
                result = (ResultSequence)comparator.invoke(null, margs);
            }
            catch (IllegalAccessException err) {
                assert (false);
            }
            catch (InvocationTargetException err) {
                Throwable ex = err.getTargetException();
                if (!(ex instanceof DynamicError)) break block17;
                throw (DynamicError)ex;
            }
        }
        return ((XSBoolean)result.first()).value();
    }

    public static ResultSequence fs_eq_general(Collection args, DynamicContext dc) throws DynamicError {
        return FsEq.do_cmp_general_op(args, FsEq.class, "fs_eq_value", dc);
    }

    public static ResultSequence do_cmp_general_op(Collection args, Class type, String mname, DynamicContext dc) throws DynamicError {
        Method comparator = null;
        try {
            Class[] margsdef = new Class[]{Collection.class, DynamicContext.class};
            comparator = type.getMethod(mname, margsdef);
        }
        catch (NoSuchMethodException err) {
            throw new RuntimeException("Can\u00bf't find method : " + mname, err);
        }
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        Iterator argiter = args.iterator();
        ResultSequence one = (ResultSequence)argiter.next();
        ResultSequence two = (ResultSequence)argiter.next();
        if (one.empty() || two.empty()) {
            return ResultSequenceFactory.create_new(new XSBoolean(false));
        }
        one = FnData.atomize(one);
        two = FnData.atomize(two);
        ListIterator i = one.iterator();
        while (i.hasNext()) {
            AnyType a = (AnyType)i.next();
            ListIterator j = two.iterator();
            while (j.hasNext()) {
                AnyType b = (AnyType)j.next();
                if (!FsEq.do_general_pair(a, b, comparator, dc)) continue;
                return ResultSequenceFactory.create_new(new XSBoolean(true));
            }
        }
        return ResultSequenceFactory.create_new(new XSBoolean(false));
    }

    public static ResultSequence do_cmp_value_op(Collection args, Class type, String mname, DynamicContext dynamicContext) throws DynamicError {
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        Collection cargs = FsEq.value_convert_args(args);
        ResultSequence result = ResultSequenceFactory.create_new();
        if (cargs.size() == 0) {
            return result;
        }
        Iterator argi = cargs.iterator();
        AnyType arg = ((ResultSequence)argi.next()).first();
        ResultSequence arg2 = (ResultSequence)argi.next();
        if (arg2.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!type.isInstance(arg)) {
            DynamicError.throw_type_error();
        }
        try {
            Class[] margsdef = new Class[]{AnyType.class, DynamicContext.class};
            Method method = null;
            method = type.getMethod(mname, margsdef);
            Object[] margs = new Object[]{arg2.first(), dynamicContext};
            Boolean cmpres = (Boolean)method.invoke((Object)arg, margs);
            return ResultSequenceFactory.create_new(new XSBoolean(cmpres));
        }
        catch (NoSuchMethodException err) {
            assert (false);
            throw new RuntimeException("cannot compare using method " + mname, err);
        }
        catch (IllegalAccessException err) {
            assert (false);
            throw new RuntimeException("cannot compare using method " + mname, err);
        }
        catch (InvocationTargetException err) {
            Throwable ex = err.getTargetException();
            if (ex instanceof DynamicError) {
                throw (DynamicError)ex;
            }
            throw new RuntimeException("cannot compare using method " + mname, ex);
        }
    }
}

