/*
 * Decompiled with CFR 0.152.
 */
package xs;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XSSerializer {
    private static final String XSD_LANGUAGE_URI = SchemaSymbols.URI_SCHEMAFORSCHEMA;
    private static final String XML_SCHEMA_VERSION = "http://apache.org/xml/properties/validation/schema/version";
    private static String XSD_LANGUAGE_PREFIX = "xs:";

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length > 5) {
            XSSerializer.printUsage();
            System.exit(-1);
        }
        String string = stringArray[stringArray.length - 1];
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            if (stringArray[i].equals("-version")) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (!stringArray[i].equals("-prefix") || i + 1 >= stringArray.length - 1) continue;
            string3 = stringArray[i + 1];
        }
        XMLSchemaLoader xMLSchemaLoader = new XMLSchemaLoader();
        if ("1.1".equals(string2)) {
            xMLSchemaLoader.setProperty(XML_SCHEMA_VERSION, (Object)Constants.W3C_XML_SCHEMA11_NS_URI);
        } else if (string2 != null && !"1.0".equals(string2)) {
            XSSerializer.printUsage();
            System.exit(-1);
        }
        if (string3 != null) {
            XSD_LANGUAGE_PREFIX = string3 + ":";
        }
        XSModel xSModel = xMLSchemaLoader.loadURI(string);
        try {
            XSSerializer xSSerializer = new XSSerializer();
            xSSerializer.serialize(xSModel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("Usage:");
        System.err.println("java xs.XSSerializer [options] schema.xsd");
        System.err.println("\nOptions:");
        System.err.println("-version [1.0|1.1]      XSD language level (default level is 1.0)");
        System.err.println("-prefix  <prefix>       XSD language URI prefix (for e.g 'xs' or 'xsd'), for the serialized output");
    }

    public void serialize(XSModel xSModel) throws Exception {
        Document document = this.transformXSModelToDOMTree(xSModel);
        DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS"));
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        lSSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setEncoding("UTF-8");
        lSOutput.setByteStream(System.out);
        lSSerializer.write(document, lSOutput);
    }

    public Document transformXSModelToDOMTree(XSModel xSModel) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_SCHEMA);
        document.appendChild(element);
        XSNamedMap xSNamedMap = xSModel.getComponents((short)2);
        this.processGlobalElementDecl(xSNamedMap, document, element);
        XSNamedMap xSNamedMap2 = xSModel.getComponents((short)15);
        this.processGlobalComplexTypeDecl(xSNamedMap2, document, element);
        XSNamedMap xSNamedMap3 = xSModel.getComponents((short)16);
        this.processGlobalSimpleTypeDecl(xSNamedMap3, document, element);
        XSNamedMap xSNamedMap4 = xSModel.getComponents((short)1);
        this.processGlobalAttrDecl(xSNamedMap4, document, element);
        XSNamedMap xSNamedMap5 = xSModel.getComponents((short)5);
        this.processGlobalAttrGroupDecl(xSNamedMap5, document, element);
        XSNamedMap xSNamedMap6 = xSModel.getComponents((short)6);
        this.processGlobalGroupDecl(xSNamedMap6, document, element);
        return document;
    }

    private void processGlobalAttrGroupDecl(XSNamedMap xSNamedMap, Document document, Element element) {
        for (int i = 0; i < xSNamedMap.size(); ++i) {
            XSAttributeGroupDecl xSAttributeGroupDecl = (XSAttributeGroupDecl)xSNamedMap.item(i);
            String string = xSAttributeGroupDecl.getName();
            Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_ATTRIBUTEGROUP);
            element2.setAttributeNS(null, SchemaSymbols.ATT_NAME, string);
            XSAnnotationImpl xSAnnotationImpl = (XSAnnotationImpl)xSAttributeGroupDecl.getAnnotation();
            if (xSAnnotationImpl != null) {
                this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
            }
            XSObjectList xSObjectList = xSAttributeGroupDecl.getAttributeUses();
            for (int j = 0; j < xSObjectList.size(); ++j) {
                String string2;
                XSAttributeUse xSAttributeUse = (XSAttributeUse)xSObjectList.item(j);
                XSAttributeDecl xSAttributeDecl = (XSAttributeDecl)xSAttributeUse.getAttrDeclaration();
                String string3 = null;
                String string4 = null;
                if (xSAttributeUse.getConstraintType() != 0) {
                    string3 = xSAttributeUse.getConstraintType() == 1 ? SchemaSymbols.ATT_DEFAULT : SchemaSymbols.ATT_FIXED;
                    string2 = xSAttributeUse.getValueConstraintValue();
                    string4 = string2.getNormalizedValue();
                }
                string2 = xSAttributeUse.getRequired() ? "required" : "optional";
                this.addAttributeToSchemaComponent(document, element2, xSAttributeDecl, string3, string4, string2);
            }
            XSWildcard xSWildcard = xSAttributeGroupDecl.getAttributeWildcard();
            if (xSWildcard != null) {
                this.addWildcardToSchemaComponent(document, element2, (XSWildcardDecl)xSWildcard, SchemaSymbols.ELT_ANYATTRIBUTE, null, null);
            }
            element.appendChild(element2);
        }
    }

    private void processGlobalElementDecl(XSNamedMap xSNamedMap, Document document, Element element) throws DOMException {
        for (int i = 0; i < xSNamedMap.size(); ++i) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSNamedMap.item(i);
            this.addElementDeclToSchemaComponent(document, element, xSElementDecl, null, null, true);
        }
    }

    private void addElementDeclToSchemaComponent(Document document, Element element, XSElementDecl xSElementDecl, String string, String string2, boolean bl) throws DOMException {
        String string3;
        XSTypeDefinition xSTypeDefinition;
        String string4 = xSElementDecl.getName();
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_ELEMENT);
        element2.setAttributeNS(null, SchemaSymbols.ATT_NAME, string4);
        XSAnnotationImpl xSAnnotationImpl = (XSAnnotationImpl)xSElementDecl.getAnnotation();
        if (xSAnnotationImpl != null) {
            this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
        }
        if (!(xSTypeDefinition = xSElementDecl.getTypeDefinition()).getAnonymous()) {
            string3 = xSTypeDefinition.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(xSTypeDefinition.getNamespace())) {
                element2.setAttributeNS(null, SchemaSymbols.ATT_TYPE, XSD_LANGUAGE_PREFIX + string3);
            } else {
                element2.setAttributeNS(null, SchemaSymbols.ATT_TYPE, string3);
            }
        } else if (xSTypeDefinition.getTypeCategory() == 16) {
            string3 = (XSSimpleTypeDecl)xSTypeDefinition;
            this.processSimpleTypeContents(document, element2, (XSSimpleTypeDecl)string3, string3.getName());
        } else if (xSTypeDefinition.getTypeCategory() == 15) {
            this.processAnonComplexTypeOnElement(document, element2, xSTypeDefinition);
        }
        if (!bl) {
            if (string != null) {
                element2.setAttributeNS(null, SchemaSymbols.ATT_MINOCCURS, string);
            }
            if (string2 != null) {
                element2.setAttributeNS(null, SchemaSymbols.ATT_MAXOCCURS, string2);
            }
        }
        if (xSElementDecl.getAbstract()) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_ABSTRACT, "true");
        }
        if (!(string3 = this.getElementBlockAttrValue(xSElementDecl)).equals("")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_BLOCK, string3);
        }
        if (xSElementDecl.getNillable()) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_NILLABLE, "true");
        }
        this.addIDConstraintsToElementDecl(document, xSElementDecl, element2);
        element.appendChild(element2);
    }

    private String getElementBlockAttrValue(XSElementDecl xSElementDecl) {
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (xSElementDecl.isDisallowedSubstitution((short)1)) {
            bl = true;
        }
        if (xSElementDecl.isDisallowedSubstitution((short)2)) {
            bl2 = true;
        }
        if (xSElementDecl.isDisallowedSubstitution((short)4)) {
            bl3 = true;
        }
        if (bl && bl2 && bl3) {
            string = "#all";
        } else {
            if (bl) {
                string = string + "extension";
            }
            if (bl2) {
                string = string + " " + "restriction";
            }
            if (bl3) {
                string = string + " " + "substitution";
            }
        }
        return string;
    }

    private void addIDConstraintsToElementDecl(Document document, XSElementDecl xSElementDecl, Element element) throws DOMException {
        XSNamedMap xSNamedMap = xSElementDecl.getIdentityConstraints();
        for (int i = 0; i < xSNamedMap.getLength(); ++i) {
            XSAnnotationImpl xSAnnotationImpl;
            IdentityConstraint identityConstraint = (IdentityConstraint)xSNamedMap.item(i);
            String string = null;
            String string2 = null;
            if (identityConstraint.getCategory() == 3) {
                string = SchemaSymbols.ELT_UNIQUE;
            } else if (identityConstraint.getCategory() == 1) {
                string = SchemaSymbols.ELT_KEY;
            } else if (identityConstraint.getCategory() == 2) {
                string = SchemaSymbols.ELT_KEYREF;
                string2 = ((KeyRef)identityConstraint).getKey().getName();
            }
            Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + string);
            String string3 = identityConstraint.getName();
            element2.setAttributeNS(null, SchemaSymbols.ATT_NAME, string3);
            if (string2 != null) {
                element2.setAttributeNS(null, SchemaSymbols.ATT_REFER, string2);
            }
            if ((xSAnnotationImpl = (XSAnnotationImpl)identityConstraint.getAnnotations().item(0)) != null) {
                this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
            }
            Selector selector = identityConstraint.getSelector();
            String string4 = selector.getXPath().toString();
            Element element3 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_SELECTOR);
            element3.setAttributeNS(null, SchemaSymbols.ATT_XPATH, string4);
            element2.appendChild(element3);
            for (int j = 0; j < identityConstraint.getFieldCount(); ++j) {
                Field field = identityConstraint.getFieldAt(j);
                String string5 = field.getXPath().toString();
                Element element4 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_FIELD);
                element4.setAttributeNS(null, SchemaSymbols.ATT_XPATH, string5);
                element2.appendChild(element4);
            }
            element.appendChild(element2);
        }
    }

    private void processGlobalComplexTypeDecl(XSNamedMap xSNamedMap, Document document, Element element) throws DOMException {
        for (int i = 0; i < xSNamedMap.size() - 1; ++i) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSNamedMap.item(i);
            String string = xSComplexTypeDecl.getName();
            Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_COMPLEXTYPE);
            element2.setAttributeNS(null, SchemaSymbols.ATT_NAME, string);
            XSAnnotationImpl xSAnnotationImpl = (XSAnnotationImpl)xSComplexTypeDecl.getAnnotations().item(0);
            if (xSAnnotationImpl != null) {
                this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
            }
            this.addChildrenToComplexType(document, element, xSComplexTypeDecl, element2);
        }
    }

    private void processGlobalSimpleTypeDecl(XSNamedMap xSNamedMap, Document document, Element element) throws DOMException {
        for (int i = 0; i < xSNamedMap.size(); ++i) {
            XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSNamedMap.item(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(xSSimpleTypeDecl.getNamespace())) continue;
            String string = xSSimpleTypeDecl.getName();
            this.processSimpleTypeContents(document, element, xSSimpleTypeDecl, string);
        }
    }

    private void processSimpleTypeContents(Document document, Element element, XSSimpleTypeDecl xSSimpleTypeDecl, String string) throws DOMException {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_SIMPLETYPE);
        if (string != null) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_NAME, string);
        }
        element.appendChild(element2);
        XSAnnotationImpl xSAnnotationImpl = (XSAnnotationImpl)xSSimpleTypeDecl.getAnnotations().item(0);
        if (xSAnnotationImpl != null) {
            this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
        }
        if (xSSimpleTypeDecl.getVariety() == 1) {
            Element element3 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_RESTRICTION);
            XSTypeDefinition xSTypeDefinition = xSSimpleTypeDecl.getBaseType();
            this.addRestrictionToSimpleContent(document, (XSTypeDefinition)xSSimpleTypeDecl, element2, element3, xSTypeDefinition);
        } else if (xSSimpleTypeDecl.getVariety() == 2) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = xSSimpleTypeDecl.getItemType();
            this.addListDeclToSimpleType(document, element2, xSSimpleTypeDefinition);
        } else if (xSSimpleTypeDecl.getVariety() == 3) {
            XSObjectList xSObjectList = xSSimpleTypeDecl.getMemberTypes();
            this.addUnionDeclToSimpleType(document, element2, xSObjectList);
        }
    }

    private void addRestrictionToSimpleContent(Document document, XSTypeDefinition xSTypeDefinition, Element element, Element element2, XSTypeDefinition xSTypeDefinition2) throws DOMException {
        Object object;
        XSComplexTypeDefinition xSComplexTypeDefinition;
        if ("http://www.w3.org/2001/XMLSchema".equals(xSTypeDefinition2.getNamespace())) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_BASE, XSD_LANGUAGE_PREFIX + xSTypeDefinition2.getName());
        } else {
            element2.setAttributeNS(null, SchemaSymbols.ATT_BASE, xSTypeDefinition2.getName());
        }
        XSSimpleTypeDefinition xSSimpleTypeDefinition = null;
        if (xSTypeDefinition instanceof XSComplexTypeDefinition) {
            xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
            xSSimpleTypeDefinition = xSComplexTypeDefinition.getSimpleType();
        } else {
            xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
        }
        xSComplexTypeDefinition = xSSimpleTypeDefinition.getFacets();
        for (int i = 0; i < xSComplexTypeDefinition.getLength(); ++i) {
            XSFacet xSFacet = (XSFacet)xSComplexTypeDefinition.item(i);
            object = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + this.getFacetName(xSFacet.getFacetKind()));
            object.setAttributeNS(null, SchemaSymbols.ATT_VALUE, xSFacet.getLexicalFacetValue());
            element2.appendChild((Node)object);
        }
        XSObjectList xSObjectList = xSSimpleTypeDefinition.getMultiValueFacets();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            object = (XSMultiValueFacet)xSObjectList.item(i);
            StringList stringList = object.getLexicalFacetValues();
            for (int j = 0; j < stringList.getLength(); ++j) {
                String string = (String)stringList.get(j);
                Element element3 = null;
                if (object.getFacetKind() == 2048) {
                    element3 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_ENUMERATION);
                } else if (object.getFacetKind() == 8) {
                    element3 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_PATTERN);
                }
                element3.setAttributeNS(null, SchemaSymbols.ATT_VALUE, string);
                element2.appendChild(element3);
            }
        }
        element.appendChild(element2);
    }

    private void processGlobalAttrDecl(XSNamedMap xSNamedMap, Document document, Element element) throws DOMException {
        for (int i = 0; i < xSNamedMap.size(); ++i) {
            XSAttributeDecl xSAttributeDecl = (XSAttributeDecl)xSNamedMap.item(i);
            String string = null;
            String string2 = null;
            if (xSAttributeDecl.getConstraintType() != 0) {
                string = xSAttributeDecl.getConstraintType() == 1 ? SchemaSymbols.ATT_DEFAULT : SchemaSymbols.ATT_FIXED;
                string2 = xSAttributeDecl.getConstraintValue();
            }
            this.addAttributeToSchemaComponent(document, element, xSAttributeDecl, string, string2, null);
        }
    }

    private void processGlobalGroupDecl(XSNamedMap xSNamedMap, Document document, Element element) {
        for (int i = 0; i < xSNamedMap.size(); ++i) {
            XSGroupDecl xSGroupDecl = (XSGroupDecl)xSNamedMap.item(i);
            this.addGroupChildToSchemaComponent(document, element, xSGroupDecl, true);
        }
    }

    private void addGroupChildToSchemaComponent(Document document, Element element, XSGroupDecl xSGroupDecl, boolean bl) {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_GROUP);
        XSAnnotationImpl xSAnnotationImpl = (XSAnnotationImpl)xSGroupDecl.getAnnotation();
        if (xSAnnotationImpl != null) {
            this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
        }
        if (bl) {
            String string = xSGroupDecl.getName();
            element2.setAttributeNS(null, SchemaSymbols.ATT_NAME, string);
            XSModelGroup xSModelGroup = xSGroupDecl.getModelGroup();
            if (xSModelGroup.getCompositor() == 1) {
                this.addCompositorOnSchemaComponent(document, element2, xSModelGroup, SchemaSymbols.ELT_SEQUENCE, "1", "1");
            } else if (xSModelGroup.getCompositor() == 2) {
                this.addCompositorOnSchemaComponent(document, element2, xSModelGroup, SchemaSymbols.ELT_CHOICE, "1", "1");
            } else if (xSModelGroup.getCompositor() == 3) {
                this.addAllCompositorOnComplexType(document, element2, xSModelGroup, "1", "1");
            }
        }
        element.appendChild(element2);
    }

    private void addAttributeToSchemaComponent(Document document, Element element, XSAttributeDecl xSAttributeDecl, String string, String string2, String string3) throws DOMException {
        XSSimpleTypeDefinition xSSimpleTypeDefinition;
        String string4 = xSAttributeDecl.getName();
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_ATTRIBUTE);
        element2.setAttributeNS(null, SchemaSymbols.ATT_NAME, string4);
        element.appendChild(element2);
        XSAnnotationImpl xSAnnotationImpl = (XSAnnotationImpl)xSAttributeDecl.getAnnotation();
        if (xSAnnotationImpl != null) {
            this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
        }
        if (string != null) {
            element2.setAttributeNS(null, string, string2);
        }
        if (string3 != null) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_USE, string3);
        }
        if (!(xSSimpleTypeDefinition = xSAttributeDecl.getTypeDefinition()).getAnonymous()) {
            String string5 = xSSimpleTypeDefinition.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(xSSimpleTypeDefinition.getNamespace())) {
                element2.setAttributeNS(null, SchemaSymbols.ATT_TYPE, XSD_LANGUAGE_PREFIX + string5);
            } else {
                element2.setAttributeNS(null, SchemaSymbols.ATT_TYPE, string5);
            }
        } else {
            XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSSimpleTypeDefinition;
            this.processSimpleTypeContents(document, element2, xSSimpleTypeDecl, xSSimpleTypeDecl.getName());
        }
    }

    private void processAnonComplexTypeOnElement(Document document, Element element, XSTypeDefinition xSTypeDefinition) throws DOMException {
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDefinition;
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_COMPLEXTYPE);
        XSAnnotationImpl xSAnnotationImpl = (XSAnnotationImpl)xSComplexTypeDecl.getAnnotations().item(0);
        if (xSAnnotationImpl != null) {
            this.addAnnotationToSchemaComponent(document, element2, xSAnnotationImpl);
        }
        this.addChildrenToComplexType(document, element, xSComplexTypeDecl, element2);
    }

    private void addChildrenToComplexType(Document document, Element element, XSComplexTypeDecl xSComplexTypeDecl, Element element2) throws DOMException {
        boolean bl;
        boolean bl2 = xSComplexTypeDecl.getAbstract();
        boolean bl3 = bl = xSComplexTypeDecl.getContentType() == 3;
        if (bl2) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_ABSTRACT, "true");
        }
        if (bl) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_MIXED, "true");
        }
        short s = xSComplexTypeDecl.getProhibitedSubstitutions();
        String string = "";
        if (s == 3) {
            string = "#all";
        } else if (s == 1) {
            string = SchemaSymbols.ELT_EXTENSION;
        } else if (s == 2) {
            string = SchemaSymbols.ELT_RESTRICTION;
        }
        if (!string.equals("")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_BLOCK, string);
        }
        short s2 = xSComplexTypeDecl.getFinalSet();
        String string2 = "";
        if (s2 == 3) {
            string2 = "#all";
        } else if (s2 == 1) {
            string2 = SchemaSymbols.ELT_EXTENSION;
        } else if (s2 == 2) {
            string2 = SchemaSymbols.ELT_RESTRICTION;
        }
        if (!string2.equals("")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_FINAL, string2);
        }
        element.appendChild(element2);
        short s3 = xSComplexTypeDecl.getDerivationMethod();
        if (xSComplexTypeDecl.getContentType() == 1) {
            this.addSimpleContentToComplexType(document, element2, xSComplexTypeDecl);
        } else if (s3 == 2 || s3 == 1) {
            if (!"http://www.w3.org/2001/XMLSchema".equals(xSComplexTypeDecl.getBaseType().getNamespace())) {
                this.addComplexContentToComplexType(document, element2, xSComplexTypeDecl, s3);
            } else {
                XSParticle xSParticle = xSComplexTypeDecl.getParticle();
                if (xSParticle != null) {
                    this.processParticleFromComplexType(document, element2, xSParticle);
                    this.addAttributesToComplexType(document, xSComplexTypeDecl, element2);
                } else {
                    this.addAttributesToComplexType(document, xSComplexTypeDecl, element2);
                }
            }
        }
    }

    private void addSimpleContentToComplexType(Document document, Element element, XSComplexTypeDecl xSComplexTypeDecl) {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_SIMPLECONTENT);
        if (xSComplexTypeDecl.getDerivationMethod() == 2) {
            Element element3 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_RESTRICTION);
            XSTypeDefinition xSTypeDefinition = xSComplexTypeDecl.getBaseType();
            if ("http://www.w3.org/2001/XMLSchema".equals(xSTypeDefinition.getNamespace())) {
                element3.setAttributeNS(null, SchemaSymbols.ATT_BASE, XSD_LANGUAGE_PREFIX + xSTypeDefinition.getName());
            } else {
                element3.setAttributeNS(null, SchemaSymbols.ATT_BASE, xSTypeDefinition.getName());
            }
            this.addRestrictionToSimpleContent(document, (XSTypeDefinition)xSComplexTypeDecl, element2, element3, xSComplexTypeDecl.getBaseType());
            this.addAttributesToComplexType(document, xSComplexTypeDecl, element3);
            element2.appendChild(element3);
        } else if (xSComplexTypeDecl.getDerivationMethod() == 1) {
            Element element4 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_EXTENSION);
            XSTypeDefinition xSTypeDefinition = xSComplexTypeDecl.getBaseType();
            if ("http://www.w3.org/2001/XMLSchema".equals(xSTypeDefinition.getNamespace())) {
                element4.setAttributeNS(null, SchemaSymbols.ATT_BASE, XSD_LANGUAGE_PREFIX + xSTypeDefinition.getName());
            } else {
                element4.setAttributeNS(null, SchemaSymbols.ATT_BASE, xSTypeDefinition.getName());
            }
            this.addAttributesToComplexType(document, xSComplexTypeDecl, element4);
            element2.appendChild(element4);
        }
        element.appendChild(element2);
    }

    private void addComplexContentToComplexType(Document document, Element element, XSComplexTypeDecl xSComplexTypeDecl, short s) {
        XSTypeDefinition xSTypeDefinition;
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_COMPLEXCONTENT);
        Element element3 = null;
        if (s == 2) {
            element3 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_RESTRICTION);
        } else if (s == 1) {
            element3 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_EXTENSION);
        }
        if (element3 != null) {
            xSTypeDefinition = xSComplexTypeDecl.getBaseType();
            if ("http://www.w3.org/2001/XMLSchema".equals(xSTypeDefinition.getNamespace())) {
                element3.setAttributeNS(null, SchemaSymbols.ATT_BASE, XSD_LANGUAGE_PREFIX + xSTypeDefinition.getName());
            } else {
                element3.setAttributeNS(null, SchemaSymbols.ATT_BASE, xSTypeDefinition.getName());
            }
            element2.appendChild(element3);
        }
        xSTypeDefinition = xSComplexTypeDecl.getParticle();
        if (s == 1) {
            XSTerm xSTerm = null;
            if (xSTypeDefinition != null) {
                xSTerm = xSTypeDefinition.getTerm();
                XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSTerm;
                if (xSModelGroupImpl.fParticles.length == 2) {
                    xSTypeDefinition = xSModelGroupImpl.fParticles[1];
                }
            }
        }
        if (xSTypeDefinition != null) {
            this.processParticleFromComplexType(document, element3, (XSParticle)xSTypeDefinition);
        }
        this.addAttributesToComplexType(document, xSComplexTypeDecl, element3);
        element.appendChild(element2);
    }

    private void addAttributesToComplexType(Document document, XSComplexTypeDecl xSComplexTypeDecl, Element element) throws DOMException {
        XSObjectList xSObjectList = xSComplexTypeDecl.getAttributeUses();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            boolean bl;
            String string;
            XSAttributeUse xSAttributeUse = (XSAttributeUse)xSObjectList.item(i);
            String string2 = null;
            String string3 = null;
            if (xSAttributeUse.getConstraintType() != 0) {
                string2 = xSAttributeUse.getConstraintType() == 1 ? SchemaSymbols.ATT_DEFAULT : SchemaSymbols.ATT_FIXED;
                string = xSAttributeUse.getValueConstraintValue();
                string3 = string.getNormalizedValue();
            }
            string = xSAttributeUse.getRequired() ? "required" : "optional";
            XSAttributeDecl xSAttributeDecl = (XSAttributeDecl)xSAttributeUse.getAttrDeclaration();
            XSComplexTypeDefinition xSComplexTypeDefinition = xSAttributeDecl.getEnclosingCTDefinition();
            boolean bl2 = bl = xSComplexTypeDefinition == null ? false : XS11TypeHelper.isSchemaTypesIdentical((XSTypeDefinition)xSComplexTypeDecl, (XSTypeDefinition)xSComplexTypeDefinition);
            if (!bl) continue;
            this.addAttributeToSchemaComponent(document, element, xSAttributeDecl, string2, string3, string);
        }
        XSWildcard xSWildcard = xSComplexTypeDecl.getAttributeWildcard();
        if (xSWildcard != null) {
            this.addWildcardToSchemaComponent(document, element, (XSWildcardDecl)xSWildcard, SchemaSymbols.ELT_ANYATTRIBUTE, null, null);
        }
    }

    private void processParticleFromComplexType(Document document, Element element, XSParticle xSParticle) throws DOMException {
        XSTerm xSTerm = xSParticle.getTerm();
        if (xSTerm instanceof XSModelGroup) {
            XSModelGroup xSModelGroup = (XSModelGroup)xSTerm;
            String string = this.getMinOccursVal(xSParticle);
            String string2 = this.getMaxOccursVal(xSParticle);
            if (xSModelGroup.getCompositor() == 1) {
                this.addCompositorOnSchemaComponent(document, element, xSModelGroup, SchemaSymbols.ELT_SEQUENCE, string, string2);
            } else if (xSModelGroup.getCompositor() == 2) {
                this.addCompositorOnSchemaComponent(document, element, xSModelGroup, SchemaSymbols.ELT_CHOICE, string, string2);
            } else if (xSModelGroup.getCompositor() == 3) {
                this.addAllCompositorOnComplexType(document, element, xSModelGroup, string, string2);
            }
        }
    }

    private void addCompositorOnSchemaComponent(Document document, Element element, XSModelGroup xSModelGroup, String string, String string2, String string3) throws DOMException {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + string);
        if (string2 != null && !string2.equals("1")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_MINOCCURS, string2);
        }
        if (string3 != null && !string3.equals("1")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_MAXOCCURS, string3);
        }
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            XSElementDecl xSElementDecl;
            XSObject xSObject = xSObjectList.item(i);
            XSParticle xSParticle = (XSParticle)xSObject;
            String string4 = this.getMinOccursVal(xSParticle);
            String string5 = this.getMaxOccursVal(xSParticle);
            XSTerm xSTerm = xSParticle.getTerm();
            if (xSTerm instanceof XSElementDeclaration) {
                xSElementDecl = (XSElementDecl)xSTerm;
                this.addElementDeclToSchemaComponent(document, element2, xSElementDecl, string4, string5, false);
                continue;
            }
            if (xSTerm instanceof XSModelGroup) {
                xSElementDecl = (XSModelGroup)xSTerm;
                if (xSElementDecl.getCompositor() == 2) {
                    this.addCompositorOnSchemaComponent(document, element2, (XSModelGroup)xSElementDecl, SchemaSymbols.ELT_CHOICE, string4, string5);
                    continue;
                }
                if (xSElementDecl.getCompositor() != 1) continue;
                this.addCompositorOnSchemaComponent(document, element2, (XSModelGroup)xSElementDecl, SchemaSymbols.ELT_SEQUENCE, string4, string5);
                continue;
            }
            if (!(xSTerm instanceof XSWildcard)) continue;
            this.addWildcardToSchemaComponent(document, element2, (XSWildcardDecl)xSTerm, SchemaSymbols.ELT_ANY, string4, string5);
        }
        element.appendChild(element2);
    }

    private void addAllCompositorOnComplexType(Document document, Element element, XSModelGroup xSModelGroup, String string, String string2) throws DOMException {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_ALL);
        if (string != null && !string.equals("1")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_MINOCCURS, string);
        }
        if (string2 != null && !string2.equals("1")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_MAXOCCURS, string2);
        }
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            XSParticle xSParticle = (XSParticle)xSObjectList.item(i);
            String string3 = this.getMinOccursVal(xSParticle);
            String string4 = this.getMaxOccursVal(xSParticle);
            XSTerm xSTerm = xSParticle.getTerm();
            if (xSTerm instanceof XSElementDeclaration) {
                this.addElementDeclToSchemaComponent(document, element2, (XSElementDecl)xSTerm, string3, string4, false);
                continue;
            }
            if (!(xSTerm instanceof XSWildcard)) continue;
            XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)xSTerm;
            this.addWildcardToSchemaComponent(document, element2, xSWildcardDecl, SchemaSymbols.ELT_ANY, string3, string4);
        }
        element.appendChild(element2);
    }

    private void addWildcardToSchemaComponent(Document document, Element element, XSWildcardDecl xSWildcardDecl, String string, String string2, String string3) {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + string);
        String string4 = xSWildcardDecl.getProcessContentsAsString();
        if (!string4.equals("strict")) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_PROCESSCONTENTS, string4);
        }
        if (string2 != null) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_MINOCCURS, string2);
        }
        if (string3 != null) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_MAXOCCURS, string3);
        }
        element.appendChild(element2);
    }

    private void addListDeclToSimpleType(Document document, Element element, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + SchemaSymbols.ELT_LIST);
        element.appendChild(element2);
        if ("http://www.w3.org/2001/XMLSchema".equals(xSSimpleTypeDefinition.getNamespace())) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_ITEMTYPE, XSD_LANGUAGE_PREFIX + xSSimpleTypeDefinition.getName());
        } else if (xSSimpleTypeDefinition.getName() != null) {
            element2.setAttributeNS(null, SchemaSymbols.ATT_ITEMTYPE, xSSimpleTypeDefinition.getName());
        } else {
            XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSSimpleTypeDefinition;
            this.processSimpleTypeContents(document, element2, xSSimpleTypeDecl, xSSimpleTypeDecl.getName());
        }
    }

    private void addUnionDeclToSimpleType(Document document, Element element, XSObjectList xSObjectList) {
        Element element2 = document.createElementNS(XSD_LANGUAGE_URI, XSD_LANGUAGE_PREFIX + "union");
        element.appendChild(element2);
        String string = "";
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSObjectList.item(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(xSSimpleTypeDecl.getNamespace())) {
                string = string + " " + XSD_LANGUAGE_PREFIX + xSSimpleTypeDecl.getName();
                continue;
            }
            if (xSSimpleTypeDecl.getName() != null) {
                string = string + " " + xSSimpleTypeDecl.getName();
                continue;
            }
            XSSimpleTypeDecl xSSimpleTypeDecl2 = xSSimpleTypeDecl;
            this.processSimpleTypeContents(document, element2, xSSimpleTypeDecl2, xSSimpleTypeDecl2.getName());
        }
        if (!string.equals("")) {
            string = string.substring(1);
            element2.setAttributeNS(null, SchemaSymbols.ATT_MEMBERTYPES, string);
        }
    }

    private void addAnnotationToSchemaComponent(Document document, Element element, XSAnnotationImpl xSAnnotationImpl) throws DOMException {
        String string = xSAnnotationImpl.getAnnotationString();
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Element element2 = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document2 = documentBuilder.parse(inputSource);
            element2 = (Element)document.importNode(document2.getDocumentElement(), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        element.appendChild(element2);
    }

    private String getFacetName(short s) {
        if (s == 128) {
            return SchemaSymbols.ELT_MINEXCLUSIVE;
        }
        if (s == 256) {
            return SchemaSymbols.ELT_MININCLUSIVE;
        }
        if (s == 64) {
            return SchemaSymbols.ELT_MAXEXCLUSIVE;
        }
        if (s == 32) {
            return SchemaSymbols.ELT_MAXINCLUSIVE;
        }
        if (s == 512) {
            return SchemaSymbols.ELT_TOTALDIGITS;
        }
        if (s == 1024) {
            return SchemaSymbols.ELT_FRACTIONDIGITS;
        }
        if (s == 1) {
            return SchemaSymbols.ELT_LENGTH;
        }
        if (s == 2) {
            return SchemaSymbols.ELT_MINLENGTH;
        }
        if (s == 4) {
            return SchemaSymbols.ELT_MAXLENGTH;
        }
        if (s == 16) {
            return SchemaSymbols.ELT_WHITESPACE;
        }
        return null;
    }

    private String getMinOccursVal(XSParticle xSParticle) {
        String string = null;
        int n = xSParticle.getMinOccurs();
        if (n != 1) {
            string = String.valueOf(n);
        }
        return string;
    }

    private String getMaxOccursVal(XSParticle xSParticle) {
        String string = null;
        if (xSParticle.getMaxOccursUnbounded()) {
            string = "unbounded";
        } else {
            int n = xSParticle.getMaxOccurs();
            if (n != 1) {
                string = String.valueOf(n);
            }
        }
        return string;
    }
}

